@q file: o2linker_types.w@>
@q%   Copyright Dave Bone 1998 - 2015@>
@q% /*@>
@q%    This Source Code Form is subject to the terms of the Mozilla Public@>
@q%    License, v. 2.0. If a copy of the MPL was not distributed with this@>
@q%    file, You can obtain one at http://mozilla.org/MPL/2.0/.@>
@q% */@>
\input "eplain"
\input "supp-pdf"
\input"/usr/local/yacco2/diagrams/o2mac.tex"
@*2 Global definitions and files.\fbreak
Basic preamble include files used by all others.
@(globals.h@>=
// file: globals.h
// prelude files using yacco2: for o2, o2linker utilities
#ifndef globals_h__
#define globals_h__ 1
#include <stdarg.h> 
#include <stdlib.h> 
#include <string.h> 
#include <limits.h> 

#include "yacco2.h"
#include "yacco2_T_enumeration.h"
#include "yacco2_err_symbols.h"
#include "yacco2_characters.h"
#include "yacco2_k_symbols.h"
#include "yacco2_terminals.h"
using namespace std;
using namespace NS_yacco2_T_enum;
using namespace NS_yacco2_k_symbols;
using namespace NS_yacco2_terminals;
using namespace yacco2;
#endif

@*3 ``o2linker\_types'' header file of common set of definitions and structures.\fbreak
``o2linker\_types.h'' file is a common set of definitions 
and structures used by ``o2linker\_externs.w''
external routines.
Contains definitions and type-defs. 
@(o2linker_types.h@>=
#ifndef o2linker_types_
#define o2linker_types_ 1
@<defines@>;
@<Type defs@>;
@<Structure defs@>;
#endif

@ Definitions for O2 and my external routines --- ``yacco2\_extn.w''.\fbreak
As i'm writing directly out to a file, the use of the ctangle macro directive
displays its displeasure so i'm using the direct c code route.  
@<defines@>=
#define CWEAVE_TITLE_LIMIT 75
#define RESERVE_FIXED_NO_THREADS 1024
#define NO_BITS_PER_SET_PARTITION 8
#define ACCEPT_FILTER true
#define BYPASS_FILTER false
#define Success true
#define Failure false
#define Nested_file_cnt_limit 15
#define O2_library_file "yacco2.h"
#define Yacco2_holding_file "yacco2cmd.tmp"
#define Linker_holding_file "linkercmd.tmp"
#define Max_buf_size 2*1024
#define Max_cweb_item_size 10*1024
@ Typedef definitions.
@<Type defs@>=
typedef int Voc_ENO;
typedef int RULE_ENO;

@ @<Type defs@>+=
typedef std::set<int> INT_SET_type; 
@ @<Type defs@>+=
typedef INT_SET_type::iterator INT_SET_ITER_type; 
@ @<Type defs@>+=
typedef std::vector< INT_SET_type> INT_SET_LIST_type; 
@ @<Type defs@>+=
typedef INT_SET_LIST_type::iterator INT_SET_LIST_ITER_type; 
@ @<Type defs@>+=
typedef std::map<int,std::string> INT_STR_MAP_type; 
@ @<Type defs@>+=
typedef INT_STR_MAP_type::iterator INT_STR_MAP_ITER_type; 
@ @<Type defs@>+=
typedef std::set<std::string*> STR_SET_type; 
@ @<Type defs@>+=
typedef STR_SET_type::iterator STR_SET_ITER_type; 
@ @<Type defs@>+=
typedef std::map<NS_yacco2_terminals::T_in_stbl*,STR_SET_type > T_IN_STBL_SET_STR_MAP_type; 
@ @<Type defs@>+=
typedef T_IN_STBL_SET_STR_MAP_type::iterator T_IN_STBL_SET_STR_MAP_ITER_type;
@ @<Type defs@>+=
typedef int Voc_ENO;
@ @<Type defs@>+=
typedef int RULE_ENO;
@ @<Type defs@>+=
typedef int T_ENO;
@ 
@<Type defs@>+=
typedef std::set<T_in_stbl*> T_IN_STBL_SET_type;
@ 
@<Type defs@>+=
typedef T_IN_STBL_SET_type::iterator T_IN_STBL_SET_ITER_type;
@ @<Type defs@>+=
typedef vector<T_ENO> T_COUNT_type;
@ @<Type defs@>+=
typedef T_COUNT_type::iterator T_COUNT_ITER_type;
@ @<Type defs@>+=
typedef vector<T_in_stbl*> STBL_T_ITEMS_type;
@ @<Type defs@>+=
typedef STBL_T_ITEMS_type::iterator STBL_T_ITEMS_ITER_type;
@ @<Type defs@>+=
typedef std::map<int,int> BIT_MAP_type; 
@ @<Type defs@>+=
typedef BIT_MAP_type::iterator BIT_MAP_ITER_type; 

@*2 |prt_called_thread_list_ast_functor|.\fbreak
@<Structure defs@>+=
struct prt_called_thread_list_ast_functor :public Type_AST_functor{
  functor_result_type  operator()(yacco2::ast_base_stack* Stk_env);
  typedef void (*PFF)(AST*,std::ofstream*,int);
  prt_called_thread_list_ast_functor(PFF Func);
  void o_file(std::ofstream* Ow_linker_file);
  void reset_cnt();
  private:@/
  yacco2::ast_base_stack* stk_env_;
  yacco2::INT idx_;
  yacco2::AST* cnode_;
  yacco2::ast_base_stack::s_rec* srec_;
  PFF prt_funct_;
  yacco2::INT cnt_;
  std::ofstream* ow_linker_file_;
};

