/*
 * Decompiled with CFR 0.152.
 */
package nts.command;

import java.io.Serializable;
import nts.base.BoolPar;
import nts.base.BytePar;
import nts.base.Dimen;
import nts.base.EqTable;
import nts.base.Glue;
import nts.base.IntPar;
import nts.base.LevelEqTable;
import nts.base.Num;
import nts.command.BottomGroup;
import nts.command.BraceNesting;
import nts.command.Command;
import nts.command.CommandBase;
import nts.command.FileName;
import nts.command.Group;
import nts.command.InpTokChecker;
import nts.command.ReadInput;
import nts.command.Token;
import nts.command.TokenList;
import nts.command.TokenizerStack;
import nts.command.Undefined;
import nts.io.CharCode;
import nts.io.DoubleLineOutput;
import nts.io.EqTraceable;
import nts.io.InputLine;
import nts.io.LineInput;
import nts.io.LineOutput;
import nts.io.Log;
import nts.io.Loggable;
import nts.io.MaxLoggable;
import nts.io.Name;
import nts.io.NullLog;

public abstract class CommandBase {
    private static LevelEqTable eqTable;
    private static TokenizerStack tokStack;
    private static BraceNesting braceNesting;
    private static int MAX_INT_PARAM;
    private static int MAX_DIM_PARAM;
    private static int MAX_GLUE_PARAM;
    private static int MAX_TOKS_PARAM;
    private static int MAX_NODE_PARAM;
    private static int MAX_BOOL_PARAM;
    private static Config config;
    private static IOHandler ioHandler;
    private static LineOutput terminal;
    private static LineOutput logFile;
    private static LineOutput termAndLog;
    public static Log termLog;
    public static Log fileLog;
    public static Log normLog;
    public static Log diagLog;
    private static boolean termEnable;
    private static boolean diagOnTerm;
    private static LineInput input;
    public static final int INTP_MAX_RUNAWAY_WIDTH;
    public static final int BOOLP_TRACING_TOKEN_LISTS;
    public static final int INTP_MAX_TLRES_TRACE;
    public static final int BOOLP_TRACING_RESTORES;
    public static final int RESTORING = 0;
    public static final int RETAINING = 1;
    private static CurrGroup currGroup;
    protected static final int DIMEN_DENOMINATOR = 65536;
    public static final int DIMP_EM;
    public static final int DIMP_EX;
    private static DimUnitDesc[] dimUnits;
    public static final int INTP_MAGNIFICATION;

    public static void setEqt(LevelEqTable eqtab) {
        eqTable = eqtab;
    }

    public static EqTable getEqt() {
        return eqTable;
    }

    public static Command meaningOf(Token tok) {
        Command cmd = tok.meaning();
        return cmd != null ? cmd : Undefined.getUndefined();
    }

    public static Command meaningOf(Token tok, boolean expOK) {
        return CommandBase.meaningOf(tok).meaning(expOK);
    }

    public static void setTokStack(TokenizerStack tokstack) {
        tokStack = tokstack;
    }

    public static TokenizerStack getTokStack() {
        return tokStack;
    }

    public static InpTokChecker setTokenChecker(InpTokChecker chk) {
        return tokStack.setChecker(chk);
    }

    public static int currLineNumber() {
        return tokStack.lineNumber();
    }

    public static int braceNestingDifference(Token tok) {
        return tok.matchLeftBrace() ? 1 : (tok.matchRightBrace() ? -1 : 0);
    }

    public static Token nextRawToken(BoolPar canExpand) {
        Token tok;
        Command cmd;
        while ((cmd = CommandBase.meaningOf(tok = tokStack.nextToken(canExpand))).explosive()) {
            cmd.detonate(tok);
        }
        CommandBase.adjustBraceNesting(CommandBase.braceNestingDifference(tok));
        return tok;
    }

    public static Token nextRawToken() {
        return CommandBase.nextRawToken(null);
    }

    public static Token nextUncheckedRawToken(BoolPar canExpand) {
        InpTokChecker savedChk = CommandBase.setTokenChecker(null);
        Token tok = CommandBase.nextRawToken(canExpand);
        CommandBase.setTokenChecker(savedChk);
        return tok;
    }

    public static Token nextUncheckedRawToken() {
        return CommandBase.nextUncheckedRawToken(null);
    }

    public static void backToken(Token tok) {
        tokStack.cleanFinishedLists();
        CommandBase.backTokenWithoutCleaning(tok);
    }

    public static void backTokenWithoutCleaning(Token tok) {
        tokStack.backUp(tok, true);
        CommandBase.adjustBraceNesting(-CommandBase.braceNestingDifference(tok));
    }

    public static void backList(TokenList list) {
        tokStack.backUp(list);
    }

    public static void pushToken(Token tok, String desc) {
        tokStack.push(tok, "<" + desc + "> ");
    }

    public static void pushList(TokenList list, String desc) {
        tokStack.push(list, "<" + desc + "> ");
    }

    public static void insertToken(Token tok) {
        tokStack.cleanFinishedLists();
        tokStack.push(tok, "<inserted text> ");
    }

    public static void insertTokenWithoutCleaning(Token tok) {
        tokStack.push(tok, "<inserted text> ");
    }

    public static void insertList(TokenList list) {
        tokStack.push(list, "<inserted text> ");
    }

    public static Token nextExpToken() {
        Token tok;
        while ((tok = CommandBase.onlyRawToken()) == null) {
        }
        return tok;
    }

    public static Token onlyRawToken() {
        BoolPar exp = new BoolPar();
        Token tok = CommandBase.nextRawToken(exp);
        Command cmd = CommandBase.meaningOf(tok);
        if (cmd.expandable() && exp.get()) {
            cmd.doExpansion(tok);
            return null;
        }
        return tok;
    }

    public static Token nextExpToken(TokenList.Buffer buf) {
        BoolPar exp = new BoolPar();
        Token tok = CommandBase.nextRawToken(exp);
        Command cmd = CommandBase.meaningOf(tok);
        if (exp.get()) {
            if (cmd.appendToks(buf)) {
                return null;
            }
            if (cmd.expandable()) {
                cmd.doExpansion(tok);
                return null;
            }
        }
        return tok;
    }

    public static BraceNesting setBraceNesting(BraceNesting nesting) {
        BraceNesting old = braceNesting;
        braceNesting = nesting;
        return old;
    }

    public static void adjustBraceNesting(int count) {
        braceNesting.adjust(count);
    }

    public static int maxIntParam() {
        return MAX_INT_PARAM;
    }

    public static int maxDimParam() {
        return MAX_DIM_PARAM;
    }

    public static int maxGlueParam() {
        return MAX_GLUE_PARAM;
    }

    public static int maxToksParam() {
        return MAX_TOKS_PARAM;
    }

    public static int maxBoolParam() {
        return MAX_BOOL_PARAM;
    }

    protected static int newIntParam() {
        return MAX_INT_PARAM++;
    }

    protected static int newDimParam() {
        return MAX_DIM_PARAM++;
    }

    protected static int newGlueParam() {
        return MAX_GLUE_PARAM++;
    }

    protected static int newToksParam() {
        return MAX_TOKS_PARAM++;
    }

    protected static int newBoolParam() {
        return MAX_BOOL_PARAM++;
    }

    public static void setConfig(Config conf) {
        config = conf;
    }

    public static Config getConfig() {
        return config;
    }

    public static void setIOHandler(IOHandler ioHand) {
        ioHandler = ioHand;
    }

    public static IOHandler getIOHandler() {
        return ioHandler;
    }

    public static Log makeLog(LineOutput out) {
        return ioHandler.makeLog(out);
    }

    public static void ensureOpenLog() {
        ioHandler.ensureOpenLog();
    }

    public static void startInput() {
        ioHandler.openInput(CommandBase.scanFileName());
    }

    public static boolean isTermLogActive() {
        return termLog != NullLog.LOG;
    }

    public static boolean isFileLogActive() {
        return fileLog != NullLog.LOG;
    }

    public static boolean termDiagActive() {
        return diagOnTerm;
    }

    private static void setupLogs(LineOutput term, LineOutput file, boolean ten) {
        LineOutput both = termAndLog;
        if (term != terminal || file != logFile) {
            LineOutput lineOutput = term != null && file != null ? new DoubleLineOutput(term, file) : (both = term != null ? term : file);
        }
        if (ten != termEnable || term != terminal) {
            Log log = termLog = ten && term != null ? CommandBase.makeLog(term) : NullLog.LOG;
        }
        if (file != logFile) {
            Log log = fileLog = file != null ? CommandBase.makeLog(file) : NullLog.LOG;
        }
        if (ten != termEnable || both != termAndLog) {
            normLog = !ten ? fileLog : (both != null ? CommandBase.makeLog(both) : NullLog.LOG);
        }
        diagLog = diagOnTerm ? normLog : fileLog;
        terminal = term;
        logFile = file;
        termEnable = ten;
        termAndLog = both;
    }

    public static void setTermEnable(boolean ten) {
        if (ten != termEnable) {
            CommandBase.setupLogs(terminal, logFile, ten);
        }
    }

    public static void setDiagOnTerm(boolean dot) {
        diagOnTerm = dot;
        diagLog = diagOnTerm ? normLog : fileLog;
    }

    public static void setTerminal(LineOutput term) {
        CommandBase.setupLogs(term, logFile, termEnable);
    }

    public static void setLogFile(LineOutput file) {
        CommandBase.setupLogs(terminal, file, termEnable);
    }

    public static void setInput(LineInput in) {
        input = in;
    }

    public static InputLine promptInput(String prompt) {
        if (terminal != null) {
            termAndLog.add(prompt);
            terminal.flush();
            InputLine line = input.readLine();
            if (line != null) {
                terminal.setStartLine();
                fileLog.add(line).endLine();
            } else {
                CommandBase.fatalError("EOFonTerm");
            }
            return line;
        }
        return null;
    }

    public static Loggable num(int n) {
        return new Loggable(n){
            private final /* synthetic */ int val$n;

            public void addOn(Log log) {
                log.add(this.val$n);
            }
            {
                this.val$n = val$n;
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
    }

    public static Loggable str(String s) {
        return new Loggable(s){
            private final /* synthetic */ String val$s;

            public void addOn(Log log) {
                log.add(this.val$s);
            }
            {
                this.val$s = val$s;
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
    }

    public static Loggable str(Object o) {
        return new Loggable(o){
            private final /* synthetic */ Object val$o;

            public void addOn(Log log) {
                log.add(this.val$o.toString());
            }
            {
                this.val$o = val$o;
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
    }

    public static Loggable esc(String s) {
        return new Loggable(s){
            private final /* synthetic */ String val$s;

            public void addOn(Log log) {
                log.addEsc(this.val$s);
            }
            {
                this.val$s = val$s;
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
    }

    public static Loggable esc(Name n) {
        return new Loggable(n){
            private final /* synthetic */ Name val$n;

            public void addOn(Log log) {
                this.val$n.addEscapedOn(log);
            }
            {
                this.val$n = val$n;
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
    }

    public static void error(String ident) {
        ioHandler.error(ident, null, true);
    }

    public static void error(String ident, Loggable p1) {
        Loggable[] params = new Loggable[]{p1};
        ioHandler.error(ident, params, true);
    }

    public static void error(String ident, Loggable p1, Loggable p2) {
        Loggable[] params = new Loggable[]{p1, p2};
        ioHandler.error(ident, params, true);
    }

    public static void error(String ident, Loggable p1, Loggable p2, Loggable p3) {
        Loggable[] params = new Loggable[]{p1, p2, p3};
        ioHandler.error(ident, params, true);
    }

    public static void error(String ident, Loggable p1, Loggable p2, Loggable p3, Loggable p4) {
        Loggable[] params = new Loggable[]{p1, p2, p3, p4};
        ioHandler.error(ident, params, true);
    }

    public static void error(String ident, Loggable[] params) {
        ioHandler.error(ident, params, true);
    }

    public static void nonDelError(String ident, Loggable[] params) {
        ioHandler.error(ident, params, false);
    }

    public static void fatalError(String ident) {
        ioHandler.fatalError(ident);
    }

    public static void errMessage(TokenList message) {
        ioHandler.errMessage(message);
    }

    public static void completeShow() {
        ioHandler.completeShow();
    }

    public static void illegalCommand(Command cmd) {
        ioHandler.illegalCommand(cmd);
    }

    public static void runAway(String desc, MaxLoggable list) {
        normLog.startLine().add("Runaway ").add(desc).add('?').endLine();
        list.addOn(normLog, CommandBase.getConfig().getIntParam(INTP_MAX_RUNAWAY_WIDTH));
    }

    public static void traceCommand(Command cmd) {
        diagLog.startLine().add('{');
        ioHandler.logMode();
        cmd.addOn(diagLog);
        diagLog.add('}').startLine();
    }

    public static void traceExpandable(Command cmd) {
        diagLog.startLine().add('{');
        ioHandler.logMode();
        cmd.addExpandable(diagLog);
        diagLog.add('}').startLine();
    }

    public static void tracedPushXList(TokenList list, String desc) {
        if (CommandBase.getConfig().getBoolParam(BOOLP_TRACING_TOKEN_LISTS)) {
            diagLog.startLine().addEsc(desc).add("->").add(list).startLine();
        }
        CommandBase.pushList(list, desc);
    }

    public static void tracedPushList(TokenList list, String desc) {
        if (!list.isEmpty()) {
            CommandBase.tracedPushXList(list, desc);
        }
    }

    public static void traceRestore(int action, EqTraceable eqt) {
        if (CommandBase.getConfig().getBoolParam(BOOLP_TRACING_RESTORES)) {
            String s;
            switch (action) {
                case 0: {
                    s = "restoring";
                    break;
                }
                case 1: {
                    s = "retaining";
                    break;
                }
                default: {
                    throw new RuntimeException("invalid action for traceRestore (" + action + ")");
                }
            }
            diagLog.add('{').add(s).add(' ');
            eqt.addEqDescOn(diagLog);
            diagLog.add('=');
            eqt.addEqValueOn(diagLog);
            diagLog.add('}').startLine();
        }
    }

    public static Group getGrp() {
        return currGroup.get();
    }

    public static void pushLevel(Group grp) {
        currGroup.push(grp);
    }

    public static void popLevel() {
        currGroup.pop();
    }

    public static void killLevel() {
        currGroup.kill();
    }

    public static void finishGroups() {
        if (eqTable.getLevel() > 0) {
            normLog.startLine().add('(').addEsc("end").add(" occurred inside a group at level ").add(eqTable.getLevel()).add(')');
        }
    }

    protected static TokenList theToks() {
        String s;
        String string;
        Token tok = CommandBase.nextExpToken();
        Command cmd = CommandBase.meaningOf(tok);
        if (cmd.hasToksValue()) {
            return cmd.getToksValue();
        }
        if (cmd.hasFontTokenValue()) {
            CommandBase.backToken(tok);
            CommandBase.nextRawToken();
            return new TokenList(cmd.getFontTokenValue());
        }
        if (cmd.hasCrazyValue()) {
            string = "0";
        } else if (cmd.hasMuGlueValue()) {
            string = cmd.getMuGlueValue().toString("mu");
        } else if (cmd.hasGlueValue()) {
            string = cmd.getGlueValue().toString("pt");
        } else if (cmd.hasMuDimenValue()) {
            string = cmd.getMuDimenValue().toString("mu");
        } else if (cmd.hasDimenValue()) {
            string = cmd.getDimenValue().toString("pt");
        } else if (cmd.hasNumValue()) {
            string = cmd.getNumValue().toString();
        } else {
            s = "0";
            CommandBase.error("CantAfterThe", cmd, CommandBase.esc("the"));
        }
        return new TokenList(s);
    }

    public static int scanInt() {
        return CommandBase.scanInt(null);
    }

    public static Num scanNum() {
        return Num.valueOf(CommandBase.scanInt(null));
    }

    public static Dimen scanDimen() {
        return CommandBase.scanDimen(false, null);
    }

    public static Dimen scanMuDimen() {
        return CommandBase.scanDimen(true, null);
    }

    public static Glue scanGlue() {
        return CommandBase.scanGlue(false);
    }

    public static Glue scanMuGlue() {
        return CommandBase.scanGlue(true);
    }

    protected static int scanInt(IntPar radix) {
        int rdx = 0;
        long val = 0L;
        BoolPar negative = new BoolPar(false);
        Token tok = CommandBase.scanSign(negative);
        if (tok.matchOther('`')) {
            tok = CommandBase.nextRawToken();
            val = tok.numValue();
            if (val < 0L) {
                val = 48L;
                CommandBase.backToken(tok);
                CommandBase.error("NonNumericToken");
            } else {
                CommandBase.adjustBraceNesting(-CommandBase.braceNestingDifference(tok));
                CommandBase.skipOptExpSpacer();
            }
        } else {
            Command cmd = CommandBase.meaningOf(tok);
            if (cmd.hasNumValue()) {
                val = cmd.getNumValue().intVal();
            } else {
                if (tok.matchOther('\'')) {
                    rdx = 8;
                    tok = CommandBase.nextExpToken();
                } else if (tok.matchOther('\"')) {
                    rdx = 16;
                    tok = CommandBase.nextExpToken();
                } else {
                    rdx = 10;
                }
                boolean empty = true;
                boolean ok = true;
                while (true) {
                    int digit = -1;
                    char dig = tok.otherChar();
                    if (dig != '\uffff') {
                        if (rdx > 10 && dig >= 'A') {
                            digit = dig - 65 + 10;
                        } else if (dig >= '0' && dig <= '9') {
                            digit = dig - 48;
                        }
                    } else if (rdx > 10 && (dig = tok.letterChar()) != '\uffff' && dig >= 'A') {
                        digit = dig - 65 + 10;
                    }
                    if (digit < 0 || digit >= rdx) break;
                    if (ok) {
                        empty = false;
                        if ((val = val * (long)rdx + (long)digit) > Integer.MAX_VALUE) {
                            ok = false;
                            CommandBase.error("NumberTooBig");
                            val = Integer.MAX_VALUE;
                        }
                    }
                    tok = CommandBase.nextExpToken();
                }
                if (empty) {
                    CommandBase.backToken(tok);
                    CommandBase.error("MissingNumber");
                } else {
                    CommandBase.skipOptSpacer(tok);
                }
            }
        }
        IntPar.set(radix, rdx);
        return negative.get() ? -((int)val) : (int)val;
    }

    protected static Dimen scanDimen(boolean mu, BytePar glueOrder) {
        int n;
        Dimen val = null;
        BytePar.set(glueOrder, (byte)0);
        BoolPar negative = new BoolPar(false);
        Token tok = CommandBase.scanSign(negative);
        Command cmd = CommandBase.meaningOf(tok);
        if (mu) {
            if (cmd.hasMuDimenValue()) {
                val = cmd.getMuDimenValue();
            } else if (cmd.hasDimenValue()) {
                n = cmd.getDimenValue().toInt(65536);
                CommandBase.muError();
                val = CommandBase.convToDimenUnit(n, Dimen.ZERO, mu, glueOrder);
            } else if (CommandBase.hasOtherValue(cmd)) {
                CommandBase.backToken(tok);
                CommandBase.error("MissingNumber");
                CommandBase.muError();
                val = CommandBase.convToDimenUnit(0, Dimen.ZERO, mu, glueOrder);
            }
        } else if (cmd.hasDimenValue()) {
            val = cmd.getDimenValue();
        } else if (cmd.hasMuDimenValue()) {
            val = cmd.getMuDimenValue();
            CommandBase.muError();
        } else if (CommandBase.hasOtherValue(cmd)) {
            val = Dimen.ZERO;
            CommandBase.backToken(tok);
            CommandBase.error("MissingNumber");
        }
        if (val == null) {
            if (cmd.hasNumValue()) {
                n = cmd.getNumValue().intVal();
                if (n < 0) {
                    negative.negate();
                    n = -n;
                }
                val = CommandBase.convToDimenUnit(n, Dimen.ZERO, mu, glueOrder);
            } else {
                IntPar radix = new IntPar(10);
                boolean point = CommandBase.isPoint(tok);
                int whole = 0;
                Dimen fract = Dimen.ZERO;
                if (!point) {
                    CommandBase.backToken(tok);
                    whole = CommandBase.scanInt(radix);
                    tok = CommandBase.nextExpToken();
                    point = CommandBase.isPoint(tok);
                }
                if (point && radix.get() == 10) {
                    char dig;
                    StringBuffer buf = new StringBuffer();
                    buf.append('0').append('.');
                    while ((dig = (tok = CommandBase.nextExpToken()).otherChar()) != '\uffff' && dig >= '0' && dig <= '9') {
                        buf.append(dig);
                    }
                    try {
                        fract = Dimen.valueOf(buf.toString());
                    }
                    catch (NumberFormatException e) {
                        whole = Integer.MIN_VALUE;
                    }
                }
                CommandBase.skipOptSpacer(tok);
                val = CommandBase.convToDimenUnit(whole, fract, mu, glueOrder);
            }
        }
        val = CommandBase.checkDimen(val);
        return negative.get() ? val.negative() : val;
    }

    private static Dimen convToDimenUnit(int whole, Dimen fract, boolean mu, BytePar glueOrder) {
        if (glueOrder != null) {
            glueOrder.set(CommandBase.scanGlueOrderUnit());
            if (glueOrder.get() != 0) {
                return fract.plus(whole);
            }
        }
        return CommandBase.convToDimenUnit(whole, fract, mu);
    }

    private static byte scanGlueOrderUnit() {
        if (CommandBase.scanKeyword("fil")) {
            byte glord = 1;
            while (CommandBase.scanKeyword("l")) {
                if (glord < 3) {
                    glord = (byte)(glord + 1);
                    continue;
                }
                CommandBase.error("IllegalFil");
            }
            CommandBase.skipOptExpSpacer();
            return glord;
        }
        return 0;
    }

    private static Dimen convToDimenUnit(int whole, Dimen fract, boolean mu) {
        Dimen val = null;
        Token tok = CommandBase.nextExpNonSpacer();
        Command cmd = CommandBase.meaningOf(tok);
        if (mu) {
            if (cmd.hasMuDimenValue()) {
                val = cmd.getMuDimenValue();
            } else if (cmd.hasDimenValue()) {
                val = cmd.getDimenValue();
                CommandBase.muError();
            } else if (CommandBase.hasOtherValue(cmd)) {
                CommandBase.backToken(tok);
                CommandBase.error("MissingNumber");
                val = Dimen.ZERO;
                CommandBase.muError();
            } else if (cmd.hasNumValue()) {
                val = Dimen.valueOf(cmd.getNumValue().intVal(), 65536);
                CommandBase.muError();
            }
        } else if (cmd.hasDimenValue()) {
            val = cmd.getDimenValue();
        } else if (cmd.hasMuDimenValue()) {
            val = cmd.getMuDimenValue();
            CommandBase.muError();
        } else if (CommandBase.hasOtherValue(cmd)) {
            val = Dimen.ZERO;
            CommandBase.backToken(tok);
            CommandBase.error("MissingNumber");
        } else if (cmd.hasNumValue()) {
            val = Dimen.valueOf(cmd.getNumValue().intVal(), 65536);
        }
        if (val == null) {
            CommandBase.backToken(tok);
            if (mu) {
                if (!CommandBase.scanKeyword("mu")) {
                    CommandBase.error("IllegalMu");
                }
                CommandBase.skipOptExpSpacer();
                return fract.plus(whole);
            }
            if (CommandBase.scanKeyword("em")) {
                val = CommandBase.getConfig().getDimParam(DIMP_EM);
            } else if (CommandBase.scanKeyword("ex")) {
                val = CommandBase.getConfig().getDimParam(DIMP_EX);
            } else {
                val = CommandBase.convToDimenUnit(whole, fract);
                CommandBase.skipOptExpSpacer();
                return val;
            }
            CommandBase.skipOptExpSpacer();
        }
        return val.times(whole).plus(val.times(fract));
    }

    public static Dimen makeDimen(int dim, String unit) {
        int i = 0;
        while (i < dimUnits.length) {
            if (CommandBase.dimUnits[i].id.equals(unit)) {
                int num = CommandBase.dimUnits[i].num;
                int den = CommandBase.dimUnits[i].den;
                return den != 0 ? Dimen.valueOf(dim).times(num, den) : Dimen.shiftedValueOf(dim, num);
            }
            ++i;
        }
        throw new RuntimeException("Illegal unit of measure (" + unit + ")");
    }

    private static Dimen convToDimenUnit(int whole, Dimen fract) {
        if (CommandBase.scanKeyword("true")) {
            int mag = CommandBase.getConfig().getIntParam(INTP_MAGNIFICATION);
            long w = (long)whole * 1000L;
            fract = fract.times(1000).plus((int)(w % (long)mag)).over(mag);
            int i = fract.toInt();
            whole = (int)(w / (long)mag) + i;
            fract = fract.minus(i);
        }
        int i = 0;
        while (i < dimUnits.length) {
            if (CommandBase.scanKeyword(CommandBase.dimUnits[i].id)) {
                int num = CommandBase.dimUnits[i].num;
                int den = CommandBase.dimUnits[i].den;
                return den != 0 ? fract.plus(whole).times(num, den) : Dimen.shiftedValueOf(whole, num).plus(fract.shifted(num));
            }
            ++i;
        }
        CommandBase.error("IllegalUnit");
        return fract.plus(whole);
    }

    protected static void muError() {
        CommandBase.error("MixedGlueUnits");
    }

    private static Dimen checkDimen(Dimen val) {
        if (val.moreThan(Dimen.MAX_VALUE)) {
            val = Dimen.MAX_VALUE;
            CommandBase.error("DimenTooLarge");
        }
        return val;
    }

    protected static Glue scanGlue(boolean mu) {
        Glue val = null;
        Dimen width = null;
        Dimen plus = Dimen.ZERO;
        Dimen minus = Dimen.ZERO;
        BytePar plusOrder = new BytePar(0);
        BytePar minusOrder = new BytePar(0);
        BoolPar negative = new BoolPar(false);
        Token tok = CommandBase.scanSign(negative);
        Command cmd = CommandBase.meaningOf(tok);
        if (mu) {
            if (cmd.hasMuGlueValue()) {
                val = cmd.getMuGlueValue();
            } else if (cmd.hasGlueValue()) {
                val = cmd.getGlueValue();
                CommandBase.muError();
            } else if (cmd.hasMuDimenValue()) {
                width = cmd.getMuDimenValue();
            } else if (cmd.hasDimenValue()) {
                width = cmd.getDimenValue();
                CommandBase.muError();
            } else if (CommandBase.hasOtherValue(cmd)) {
                CommandBase.backToken(tok);
                CommandBase.error("MissingNumber");
                width = Dimen.ZERO;
                CommandBase.muError();
            }
        } else if (cmd.hasGlueValue()) {
            val = cmd.getGlueValue();
        } else if (cmd.hasMuGlueValue()) {
            val = cmd.getMuGlueValue();
            CommandBase.muError();
        } else if (cmd.hasDimenValue()) {
            width = cmd.getDimenValue();
        } else if (cmd.hasMuDimenValue()) {
            width = cmd.getMuDimenValue();
            CommandBase.muError();
        } else if (CommandBase.hasOtherValue(cmd)) {
            width = Dimen.ZERO;
            CommandBase.backToken(tok);
            CommandBase.error("MissingNumber");
        }
        if (val != null) {
            return negative.get() ? val.negative() : val;
        }
        if (width == null) {
            if (cmd.hasNumValue()) {
                int n = cmd.getNumValue().intVal();
                if (n < 0) {
                    negative.negate();
                    n = -n;
                }
                width = CommandBase.convToDimenUnit(n, Dimen.ZERO, mu);
                width = CommandBase.checkDimen(width);
            } else {
                CommandBase.backToken(tok);
                width = CommandBase.scanDimen(mu, null);
            }
        }
        if (negative.get()) {
            width = width.negative();
        }
        if (CommandBase.scanKeyword("plus")) {
            plus = CommandBase.scanDimen(mu, plusOrder);
        }
        if (CommandBase.scanKeyword("minus")) {
            minus = CommandBase.scanDimen(mu, minusOrder);
        }
        return Glue.valueOf(width, plus, plusOrder.get(), minus, minusOrder.get());
    }

    private static boolean isPoint(Token tok) {
        return tok.matchOther('.') || tok.matchOther(',');
    }

    private static boolean hasOtherValue(Command cmd) {
        return cmd.hasToksValue() || cmd.hasFontTokenValue();
    }

    protected static Token scanSign(BoolPar negative) {
        Token tok;
        while (true) {
            if ((tok = CommandBase.nextExpNonSpacer()).matchOther('-')) {
                negative.set(!negative.get());
                continue;
            }
            if (!tok.matchOther('+')) break;
        }
        return tok;
    }

    protected static final void skipOptSpacer(Token tok) {
        if (!CommandBase.meaningOf(tok).isSpacer()) {
            CommandBase.backToken(tok);
        }
    }

    protected static final void skipOptExpSpacer() {
        CommandBase.skipOptSpacer(CommandBase.nextExpToken());
    }

    protected static final Token nextExpNonSpacer() {
        Token tok;
        while (CommandBase.meaningOf(tok = CommandBase.nextExpToken()).isSpacer()) {
        }
        return tok;
    }

    public static void skipOptEquals() {
        Token tok = CommandBase.nextExpNonSpacer();
        if (!tok.matchOther('=')) {
            CommandBase.backToken(tok);
        }
    }

    protected static final Token nextNonRelax() {
        Token tok;
        Command command;
        while ((command = CommandBase.meaningOf(tok = CommandBase.nextExpToken())).isSpacer() || command.isRelax()) {
        }
        return tok;
    }

    protected static final Token nextNonAssignment() {
        Token tok;
        Command cmd;
        while ((cmd = CommandBase.meaningOf(tok = CommandBase.nextNonRelax())).assignable()) {
            cmd.doAssignment(tok, 0);
        }
        return tok;
    }

    public static void scanLeftBrace() {
        Token tok = CommandBase.nextNonRelax();
        if (!CommandBase.meaningOf(tok).isLeftBrace()) {
            CommandBase.backToken(tok);
            CommandBase.error("MissingLeftBrace");
            CommandBase.adjustBraceNesting(1);
        }
    }

    protected static boolean scanKeyword(String keyword) {
        Token[] backup = new Token[keyword.length()];
        Token tok = CommandBase.nextExpNonSpacer();
        int i = 0;
        while (true) {
            CharCode code;
            if ((code = tok.nonActiveCharCode()) == null || !code.match(keyword.charAt(i)) && !code.match(Character.toUpperCase(keyword.charAt(i)))) {
                CommandBase.backToken(tok);
                if (i > 0) {
                    CommandBase.backList(new TokenList(backup, 0, i));
                }
                return false;
            }
            backup[i++] = tok;
            if (i >= keyword.length()) {
                return true;
            }
            tok = CommandBase.nextExpToken();
        }
    }

    protected static FileName scanFileName() {
        int i;
        Token tok;
        Command command;
        boolean inpEnbl = CommandBase.getConfig().enableInput(false);
        FileName name = ioHandler.makeFileName();
        while ((command = CommandBase.meaningOf(tok = CommandBase.nextExpToken())).isSpacer()) {
        }
        while (true) {
            Command cmd;
            CharCode code;
            int n = i = (code = cmd.charCode()) != null ? name.accept(code) : -1;
            if (i <= 0) break;
            tok = CommandBase.nextExpToken();
            cmd = CommandBase.meaningOf(tok);
        }
        if (i < 0) {
            CommandBase.backToken(tok);
        }
        CommandBase.getConfig().enableInput(inpEnbl);
        return name;
    }

    static {
        braceNesting = new 1();
        MAX_INT_PARAM = 0;
        MAX_DIM_PARAM = 0;
        MAX_GLUE_PARAM = 0;
        MAX_TOKS_PARAM = 0;
        MAX_NODE_PARAM = 0;
        MAX_BOOL_PARAM = 0;
        terminal = null;
        logFile = null;
        termAndLog = null;
        termLog = NullLog.LOG;
        fileLog = NullLog.LOG;
        normLog = NullLog.LOG;
        diagLog = NullLog.LOG;
        termEnable = false;
        diagOnTerm = false;
        INTP_MAX_RUNAWAY_WIDTH = CommandBase.newIntParam();
        BOOLP_TRACING_TOKEN_LISTS = CommandBase.newBoolParam();
        INTP_MAX_TLRES_TRACE = CommandBase.newIntParam();
        BOOLP_TRACING_RESTORES = CommandBase.newBoolParam();
        currGroup = new CurrGroup();
        DIMP_EM = CommandBase.newDimParam();
        DIMP_EX = CommandBase.newDimParam();
        dimUnits = new DimUnitDesc[]{new DimUnitDesc("pt", 0), new DimUnitDesc("in", 7227, 100), new DimUnitDesc("pc", 12, 1), new DimUnitDesc("cm", 7227, 254), new DimUnitDesc("mm", 7227, 2540), new DimUnitDesc("bp", 7227, 7200), new DimUnitDesc("dd", 1238, 1157), new DimUnitDesc("cc", 14856, 1157), new DimUnitDesc("sp", -16)};
        INTP_MAGNIFICATION = CommandBase.newIntParam();
    }

    public static abstract class NumKind
    extends EqTable.NumKind
    implements Serializable {
        public final void restored(int key, Object oldVal) {
            this.trace("restoring", key);
        }

        public final void retained(int key) {
            this.trace("retaining", key);
        }

        private void trace(String action, int key) {
            if (CommandBase.getConfig().getBoolParam(BOOLP_TRACING_RESTORES)) {
                diagLog.add('{').add(action).add(' ');
                this.addDescOn(key, diagLog);
                diagLog.add('=');
                this.addValueOn(key, diagLog);
                diagLog.add('}').startLine();
            }
        }

        protected abstract void addDescOn(int var1, Log var2);

        protected abstract void addValueOn(int var1, Log var2);
    }

    public static abstract class TokKind
    extends EqTable.ObjKind
    implements Serializable {
        public final void restored(Object key, Object oldVal) {
            this.trace("restoring", key);
        }

        public final void retained(Object key) {
            this.trace("retaining", key);
        }

        private void trace(String action, Object key) {
            if (CommandBase.getConfig().getBoolParam(BOOLP_TRACING_RESTORES)) {
                Token tok = this.getToken(key);
                diagLog.add('{').add(action).add(' ');
                diagLog.add(tok).add('=');
                CommandBase.meaningOf(tok).addExpandable(diagLog, CommandBase.getConfig().getIntParam(INTP_MAX_TLRES_TRACE));
                diagLog.add('}').startLine();
            }
        }

        protected abstract Token getToken(Object var1);
    }

    public static abstract class ExtEquiv
    implements EqTable.ExtEquiv,
    EqTraceable {
        private int eqLevel = 0;

        public final int getEqLevel() {
            return this.eqLevel;
        }

        public final void setEqLevel(int lev) {
            this.eqLevel = lev;
        }

        public final void retainEqValue() {
            CommandBase.traceRestore(1, this);
        }

        public final void restoreEqValue(Object val) {
            this.setEqValue(val);
            CommandBase.traceRestore(0, this);
        }

        protected final void beforeSetting(boolean glob) {
            CommandBase.getEqt().beforeSetting(this, glob);
        }

        public abstract Object getEqValue();

        public abstract void setEqValue(Object var1);

        public abstract void addEqDescOn(Log var1);

        public abstract void addEqValueOn(Log var1);
    }

    private static class CurrGroup
    implements EqTable.ExtEquiv {
        private int eqLevel = 0;
        private Group group = new BottomGroup();

        public final int getEqLevel() {
            return this.eqLevel;
        }

        public final void setEqLevel(int lev) {
            this.eqLevel = lev;
        }

        public final Group get() {
            return this.group;
        }

        public void push(Group grp) {
            grp.open();
            eqTable.pushLevel();
            eqTable.save(this);
            grp.start();
            this.group = grp;
        }

        public void pop() {
            Group grp = this.group;
            grp.stop();
            eqTable.popLevel();
            grp.close();
        }

        public void kill() {
            eqTable.popLevel();
        }

        public final Object getEqValue() {
            return this.group;
        }

        public final void retainEqValue() {
        }

        public final void restoreEqValue(Object val) {
            this.group.unsaveAfter();
            this.group = (Group)val;
        }

        CurrGroup() {
        }
    }

    private static class DimUnitDesc {
        String id;
        int num;
        int den;

        DimUnitDesc(String i, int n, int d) {
            this.id = i;
            this.num = n;
            this.den = d;
        }

        DimUnitDesc(String i, int n) {
            this.id = i;
            this.num = n;
            this.den = 0;
        }
    }

    public static interface Config {
        public int getIntParam(int var1);

        public Dimen getDimParam(int var1);

        public Glue getGlueParam(int var1);

        public TokenList getToksParam(int var1);

        public boolean getBoolParam(int var1);

        public String getGlueName(int var1);

        public TokenList.Inserter getToksInserter(int var1);

        public boolean enableInput(boolean var1);

        public boolean enableAfterAssignment(boolean var1);

        public void afterAssignment();

        public boolean formatLoaded();

        public Token frozenFi();
    }

    public static interface IOHandler {
        public Name getJobName();

        public void ensureOpenLog();

        public void openInput(FileName var1);

        public ReadInput openRead(FileName var1, int var2);

        public ReadInput defaultRead(int var1);

        public Log makeLog(LineOutput var1);

        public Log makeStringLog();

        public Log openWrite(FileName var1, int var2);

        public FileName makeFileName();

        public void resetErrorCount();

        public void error(String var1, Loggable[] var2, boolean var3);

        public void fatalError(String var1);

        public void errMessage(TokenList var1);

        public void logMode();

        public void completeShow();

        public void illegalCommand(Command var1);
    }
}

