/***************************************************************************\
*                                                                           *
*   WINMEM.H                                                                *
*                                                                           *
*   Some headers are used from the cygnus project                           *
*   Modified by:                                                            *
*    kiefer@isys.de                                                         *
*    rainer@mathematik.uni-bielefeld.de                                     *
*									    *
\***************************************************************************/

#if !defined (_WINMEM_H)
#define _WINMEM_H

#ifdef __cplusplus
extern "C" {
#endif

/* Old fashioned heap handling */

#define LMEM_FIXED	    0x0000
#define LMEM_MOVEABLE	    0x0002
#define LMEM_NOCOMPACT	    0x0010
#define LMEM_NODISCARD	    0x0020
#define LMEM_ZEROINIT	    0x0040
#define LMEM_MODIFY         0x0080
#define LMEM_DISCARDABLE    0x0F00
#define LMEM_VALID_FLAGS    0x0F72
#define LMEM_DISCARDED      0x4000
#define LMEM_LOCKCOUNT      0x00FF
#define LMEM_INVALID_HANDLE 0x8000

#define LHND		(LMEM_MOVEABLE | LMEM_ZEROINIT)
#define LPTR		(LMEM_FIXED | LMEM_ZEROINIT)
#define NONZEROLHND	(LMEM_MOVEABLE)
#define NONZEROLPTR		(LMEM_FIXED)

HLOCAL WINAPI LocalAlloc(UINT flags, DWORD size);
HLOCAL WINAPI LocalReAlloc(HLOCAL hMem, DWORD size, UINT flags);
UINT WINAPI LocalSize(HLOCAL hMem);
UINT WINAPI LocalFlags(HLOCAL hMem);
HLOCAL WINAPI LocalHandle(LPCVOID pMem);
LPVOID WINAPI LocalLock(HLOCAL hMem);
BOOL WINAPI LocalUnlock(HLOCAL hMem);
#define LocalDiscard(h) LocalReAlloc((h), 0, LMEM_MOVEABLE)
HLOCAL WINAPI LocalFree(HLOCAL hMem);
UINT WINAPI LocalCompact(UINT uMinFree);

#define GMEM_FIXED	    0x0000
#define GMEM_MOVEABLE       0x0002
#define GMEM_NOCOMPACT      0x0010
#define GMEM_NODISCARD      0x0020
#define GMEM_ZEROINIT       0x0040
#define GMEM_MODIFY         0x0080
#define GMEM_DISCARDABLE    0x0100
#define GMEM_NOT_BANKED     0x1000
#define GMEM_SHARE          0x2000
#define GMEM_DDESHARE       0x2000
#define GMEM_NOTIFY         0x4000
#define GMEM_LOWER          GMEM_NOT_BANKED
#define GMEM_VALID_FLAGS    0x7F72
#define GMEM_INVALID_HANDLE 0x8000

#define GHND                (GMEM_MOVEABLE | GMEM_ZEROINIT)
#define GPTR                (GMEM_FIXED | GMEM_ZEROINIT)

HGLOBAL WINAPI GlobalAlloc (UINT flags, DWORD size);
HGLOBAL WINAPI GlobalReAlloc(HGLOBAL hMem, DWORD dwBytes, UINT uFlags);
DWORD WINAPI GlobalSize(HGLOBAL hMem);
UINT WINAPI GlobalFlags(HGLOBAL hMem);
HGLOBAL WINAPI GlobalHandle(LPCVOID pMem);
LPVOID WINAPI GlobalLock (HGLOBAL hMem);
BOOL WINAPI GlobalUnlock (HGLOBAL hMem);
#define GlobalDiscard(h) GlobalReAlloc( (h), 0, GMEM_MOVEABLE )
HGLOBAL WINAPI GlobalFree (HGLOBAL hMem);



#define SECTION_QUERY	0x0001
#define SECTION_MAP_WRITE	0x0002
#define SECTION_MAP_READ	0x0004
#define SECTION_MAP_EXECUTE	0x0008
#define SECTION_EXTEND_SIZE	0x0010
#define SECTION_ALL_ACCESS (STANDARD_RIGHTS_REQUIRED|SECTION_QUERY| \
	SECTION_MAP_WRITE | SECTION_MAP_READ | \
	SECTION_MAP_EXECUTE | SECTION_EXTEND_SIZE)

#define PAGE_NOACCESS	       0x01
#define PAGE_READONLY	       0x02
#define PAGE_READWRITE	       0x04
#define PAGE_WRITECOPY	       0x08
#define PAGE_EXECUTE	       0x10
#define PAGE_EXECUTE_READ      0x20
#define PAGE_EXECUTE_READWRITE 0x40
#define PAGE_EXECUTE_WRITECOPY 0x80
#define PAGE_GUARD	      0x100
#define PAGE_NOCACHE	      0x200

#define MEM_COMMIT	     0x1000
#define MEM_RESERVE	     0x2000
#define MEM_DECOMMIT	     0x4000
#define MEM_RELEASE	     0x8000
#define MEM_FREE	    0x10000
#define MEM_PRIVATE	    0x20000
#define MEM_MAPPED	    0x40000
#define MEM_TOP_DOWN	   0x100000

#define SEC_FILE	   0x800000
#define SEC_IMAGE	  0x1000000
#define SEC_RESERVE	  0x4000000
#define SEC_COMMIT	  0x8000000
#define SEC_NOCACHE	 0x10000000
#define MEM_IMAGE         0x1000000

typedef struct {
    PVOID BaseAddress;
    PVOID AllocationBase;
    DWORD AllocationProtect;
    DWORD RegionSize;
    DWORD State;
    DWORD Protect;
    DWORD Type;
} MEMORY_BASIC_INFORMATION,
*PMEMORY_BASIC_INFORMATION;

LPVOID WINAPI VirtualAlloc(LPVOID lpAddress, DWORD dwSize,
	DWORD flAllocationType, DWORD flProtect);
BOOL WINAPI VirtualFree(LPVOID lpAddress, DWORD dwSize, DWORD dwFreeType);
BOOL WINAPI VirtualProtect(LPVOID lpAddress, DWORD dwSize, 
	DWORD flNewProtect, PDWORD lpflOldProtect);
DWORD WINAPI VirtualQuery(LPCVOID lpAddress, 
	PMEMORY_BASIC_INFORMATION lpBuffer, DWORD dwLength);
BOOL WINAPI VirtualProtectEx(HANDLE hProcess, LPVOID lpAddress,
	DWORD dwSize, DWORD flNewProtect, PDWORD lpflOldProtect);
DWORD WINAPI VirtualQueryEx(HANDLE hProcess, LPCVOID lpAddress,
	PMEMORY_BASIC_INFORMATION lpBuffer, DWORD dwLength);


#define HEAP_NO_SERIALIZE               0x00000001      
#define HEAP_GROWABLE                   0x00000002      
#define HEAP_GENERATE_EXCEPTIONS        0x00000004      
#define HEAP_ZERO_MEMORY                0x00000008      
#define HEAP_REALLOC_IN_PLACE_ONLY      0x00000010      
#define HEAP_TAIL_CHECKING_ENABLED      0x00000020      
#define HEAP_FREE_CHECKING_ENABLED      0x00000040      
#define HEAP_DISABLE_COALESCE_ON_FREE   0x00000080      

HANDLE WINAPI HeapCreate(DWORD flOptions, DWORD dwInitialSize,
	DWORD dwMaximumSize);
BOOL WINAPI HeapDestroy(HANDLE hHeap);
LPVOID WINAPI HeapAlloc(HANDLE hHeap, DWORD dwFlags, DWORD dwBytes);
LPVOID WINAPI HeapReAlloc(HANDLE hHeap, DWORD dwFlags, 
	LPVOID lpMem, DWORD dwBytes);
BOOL WINAPI HeapFree(HANDLE hHeap, DWORD dwFlags, LPVOID lpMem);
DWORD WINAPI HeapSize(HANDLE hHeap, DWORD dwFlags, LPCVOID lpMem);
BOOL WINAPI HeapValidate(HANDLE hHeap, DWORD dwFlags, LPCVOID lpMem);
UINT WINAPI HeapCompact(HANDLE hHeap, DWORD dwFlags);
BOOL WINAPI HeapLock(HANDLE hHeap);
BOOL WINAPI HeapUnlock(HANDLE hHeap);
HANDLE WINAPI GetProcessHeap(VOID);
DWORD WINAPI GetProcessHeaps(DWORD NumberOfHeaps, PHANDLE ProcessHeaps);


typedef struct {
    PVOID lpData;
    DWORD cbData;
    BYTE cbOverhead;
    BYTE iRegionIndex;
    WORD wFlags;
    union {
        struct {
            HANDLE hMem;
            DWORD dwReserved[ 3 ];
        } Block;
        struct {
            DWORD dwCommittedSize;
            DWORD dwUnCommittedSize;
            LPVOID lpFirstBlock;
            LPVOID lpLastBlock;
        } Region;
    } u;
} PROCESS_HEAP_ENTRY, *LPPROCESS_HEAP_ENTRY, *PPROCESS_HEAP_ENTRY;

#define PROCESS_HEAP_REGION             0x0001
#define PROCESS_HEAP_UNCOMMITTED_RANGE  0x0002
#define PROCESS_HEAP_ENTRY_BUSY         0x0004
#define PROCESS_HEAP_ENTRY_MOVEABLE     0x0010
#define PROCESS_HEAP_ENTRY_DDESHARE     0x0020

BOOL WINAPI HeapWalk(HANDLE hHeap, LPPROCESS_HEAP_ENTRY lpEntry);


#define TLS_OUT_OF_INDEXES (DWORD)0xFFFFFFFF

DWORD WINAPI TlsAlloc(VOID);
LPVOID WINAPI TlsGetValue(DWORD dwTlsIndex);
BOOL WINAPI TlsSetValue(DWORD dwTlsIndex, LPVOID lpTlsValue);
BOOL WINAPI TlsFree(DWORD dwTlsIndex);

#ifdef __cplusplus
}
#endif

#endif /* !defined (_WINMEM_H) */
