/* vgetctyp.c (emx+gcc) -- Copyright (c) 1987-1994 by Eberhard Mattes */

#include <stdlib.h>
#include <sys/video.h>
#include "video2.h"
#include "video3.h"

#if defined (IF_WIN32)
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif

void v_getctype (int *start, int *end)
{
#if defined (IF_WIN32)
      IF_WIN32
        {
          CONSOLE_CURSOR_INFO cci;
          GetConsoleCursorInfo(GetStdHandle(STD_OUTPUT_HANDLE), &cci);
          *start = 1;
          *end = (0x1f * cci.dwSize / 100) & 0x1f;
        }
#endif
#if defined (IF_DOS)
  IF_DOS
    {
      union REGS r;

      r.h.ah = 0x03;
      r.h.bh = 0x00;
      _int86 (0x10, &r, &r);
      *start = r.h.ch & 0x1f;
      *end = r.h.cl & 0x1f;
    }
#endif
}
