/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.pencil;

import de.tu_darmstadt.sp.pencil.PageCommand;
import de.tu_darmstadt.sp.pencil.PageCommandParser;
import de.tu_darmstadt.sp.pencil.ParseException;
import de.tu_darmstadt.sp.pencil.Visitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class PageDescription {
    private List commandList;

    public PageDescription() {
        this.commandList = new ArrayList();
    }

    public PageDescription(InputStream inStream) throws ParseException {
        PageCommandParser pcp = new PageCommandParser(inStream);
        this.commandList = pcp.getAllCommands();
    }

    public PageDescription(Reader reader) throws ParseException {
        PageCommandParser pcp = new PageCommandParser(reader);
        this.commandList = pcp.getAllCommands();
    }

    public void accept(Visitor v) {
        ListIterator i = this.getIterator();
        while (i.hasNext()) {
            ((PageCommand)i.next()).accept(v);
        }
    }

    public void addCommand(int position, PageCommand com) {
        this.commandList.add(position, com);
    }

    public void addCommand(PageCommand com) {
        this.commandList.add(com);
    }

    public ListIterator getIterator() {
        return this.commandList.listIterator();
    }

    public void removeCommand(int idx) {
        this.commandList.remove(idx);
    }

    public void write(Writer wr) throws IOException {
        ListIterator i = this.getIterator();
        while (i.hasNext()) {
            ((PageCommand)i.next()).write(wr);
        }
        wr.flush();
    }
}

