/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.xml.bind.DatatypeConverter;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.metadata.PDFAIdentificationValidation;
import org.apache.pdfbox.preflight.metadata.RDFAboutAttributeConcordanceValidation;
import org.apache.pdfbox.preflight.metadata.SynchronizedMetaDataValidation;
import org.apache.pdfbox.preflight.metadata.XpacketParsingException;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.XMPBasicSchema;
import org.apache.xmpbox.type.BadFieldValueException;
import org.apache.xmpbox.type.ThumbnailType;
import org.apache.xmpbox.xml.DomXmpParser;
import org.apache.xmpbox.xml.XmpParsingException;

public class MetadataValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext ctx) throws ValidationException {
        try {
            PreflightDocument document = ctx.getDocument();
            InputStream is = MetadataValidationProcess.getXpacket(document.getDocument());
            DomXmpParser builder = new DomXmpParser();
            XMPMetadata metadata = builder.parse(is);
            is.close();
            ctx.setMetadata(metadata);
            if (metadata.getXpacketBytes() != null) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("7.0.0", "bytes attribute is forbidden"));
            }
            if (metadata.getXpacketEncoding() != null) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("7.0.0", "encoding attribute is forbidden"));
            }
            this.checkThumbnails(ctx, metadata);
            this.addValidationErrors(ctx, new SynchronizedMetaDataValidation().validateMetadataSynchronization(document, metadata));
            this.addValidationErrors(ctx, new PDFAIdentificationValidation().validatePDFAIdentifer(metadata));
            try {
                new RDFAboutAttributeConcordanceValidation().validateRDFAboutAttributes(metadata);
            }
            catch (RDFAboutAttributeConcordanceValidation.DifferentRDFAboutException e) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("7.0.1", e.getMessage(), e));
            }
        }
        catch (XpacketParsingException e) {
            if (e.getError() != null) {
                this.addValidationError(ctx, e.getError());
            } else {
                this.addValidationError(ctx, new ValidationResult.ValidationError("7", "Unexpected error", e));
            }
        }
        catch (XmpParsingException e) {
            if (e.getErrorType() == XmpParsingException.ErrorType.NoValueType) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("7.6", e.getMessage(), e));
            } else if (e.getErrorType() == XmpParsingException.ErrorType.RequiredProperty) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("7.5", e.getMessage(), e));
            } else if (e.getErrorType() == XmpParsingException.ErrorType.InvalidPrefix) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("7.3", e.getMessage(), e));
            } else if (e.getErrorType() == XmpParsingException.ErrorType.InvalidType) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("7.1.1", e.getMessage(), e));
            } else {
                if (e.getErrorType() == XmpParsingException.ErrorType.XpacketBadEnd) {
                    throw new ValidationException("Unable to parse font metadata due to : " + e.getMessage(), e);
                }
                if (e.getErrorType() == XmpParsingException.ErrorType.NoSchema) {
                    this.addValidationError(ctx, new ValidationResult.ValidationError("7.3", e.getMessage(), e));
                } else if (e.getErrorType() == XmpParsingException.ErrorType.InvalidPdfaSchema) {
                    this.addValidationError(ctx, new ValidationResult.ValidationError("7.4.1", e.getMessage(), e));
                } else {
                    this.addValidationError(ctx, new ValidationResult.ValidationError("7.1", e.getMessage(), e));
                }
            }
        }
        catch (IOException e) {
            throw new ValidationException("Failed while validating", e);
        }
    }

    private void checkThumbnails(PreflightContext ctx, XMPMetadata metadata) {
        List<ThumbnailType> tbProp;
        XMPBasicSchema xmp = metadata.getXMPBasicSchema();
        if (xmp == null) {
            return;
        }
        try {
            tbProp = xmp.getThumbnailsProperty();
        }
        catch (BadFieldValueException e) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("7.1", e.getMessage(), e));
            return;
        }
        if (tbProp == null) {
            return;
        }
        for (ThumbnailType tb : tbProp) {
            this.checkThumbnail(tb, ctx);
        }
    }

    private void checkThumbnail(ThumbnailType tb, PreflightContext ctx) {
        BufferedImage bim;
        byte[] binImage;
        try {
            binImage = DatatypeConverter.parseBase64Binary((String)tb.getImage());
        }
        catch (IllegalArgumentException e) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("7.1", "xapGImg:image is not correct base64 encoding"));
            return;
        }
        if (!this.hasJpegMagicNumber(binImage)) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("7.1", "xapGImg:image decoded base64 content is not in JPEG format"));
            return;
        }
        try {
            bim = ImageIO.read(new ByteArrayInputStream(binImage));
        }
        catch (IOException e) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("7.1", e.getMessage(), e));
            return;
        }
        if (!"JPEG".equals(tb.getFormat())) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("7.1", "xapGImg:format must be 'JPEG'"));
        }
        if (bim.getHeight() != tb.getHeight().intValue()) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("7.1", "xapGImg:height does not match the actual base64-encoded thumbnail image data"));
        }
        if (bim.getWidth() != tb.getWidth().intValue()) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("7.1", "xapGImg:witdh does not match the actual base64-encoded thumbnail image data"));
        }
    }

    private boolean hasJpegMagicNumber(byte[] binImage) {
        if (binImage.length < 4) {
            return false;
        }
        return binImage[0] == -1 && binImage[1] == -40 && binImage[binImage.length - 2] == -1 && binImage[binImage.length - 1] == -39;
    }

    private static InputStream getXpacket(COSDocument cdocument) throws IOException, XpacketParsingException {
        COSObject catalog = cdocument.getCatalog();
        COSBase cb = catalog.getDictionaryObject(COSName.METADATA);
        if (cb == null) {
            ValidationResult.ValidationError error = new ValidationResult.ValidationError("7.1", "Missing Metadata Key in catalog");
            throw new XpacketParsingException("Failed while retrieving xpacket", error);
        }
        COSDictionary metadataDictionnary = COSUtils.getAsDictionary(cb, cdocument);
        if (metadataDictionnary.getItem(COSName.FILTER) != null) {
            ValidationResult.ValidationError error = new ValidationResult.ValidationError("1.2.7", "Filter specified in metadata dictionnary");
            throw new XpacketParsingException("Failed while retrieving xpacket", error);
        }
        if (!(metadataDictionnary instanceof COSStream)) {
            ValidationResult.ValidationError error = new ValidationResult.ValidationError("7.1", "Metadata is not a stream");
            throw new XpacketParsingException("Failed while retrieving xpacket", error);
        }
        COSStream stream = (COSStream)metadataDictionnary;
        return stream.createInputStream();
    }

    protected List<ValidationResult.ValidationError> checkStreamFilterUsage(PDDocument doc) {
        ArrayList<ValidationResult.ValidationError> ve = new ArrayList<ValidationResult.ValidationError>();
        List<COSName> filters = doc.getDocumentCatalog().getMetadata().getFilters();
        if (filters != null && !filters.isEmpty()) {
            ve.add(new ValidationResult.ValidationError("7", "Using stream filter on metadata dictionary is forbidden"));
        }
        return ve;
    }
}

