/****************************************************************************
  PROJECT: FlowerSoft C++ library
  FILE   : loptions.h
--*/
#ifndef __LONG_OPTIONS_H
#define __LONG_OPTIONS_H

#ifndef __OPTIONS_H
#include "options.h"
#endif

/****************************************************************************
  class Long_option
--*/

#include "getoptin.h"

class Long_option : public Option 
    {
     friend class Long_option_list;
     
 protected:
     struct option info; 

 public:
    static int compare_name( const Object& option, void* name )
	    {
#if 0                          // some compilers do not understand...   
            return ( String( ( (Long_option&)option ).info.name ) == (char*)name );
#else    
            Long_option& o = (Long_option&)option;
            return ( String( o.info.name ) == (char*)name );
#endif
	    }
	                       // some compilers need this...
    virtual operator int() const = 0;
    
    const char* long_option() const;
    void printOn( ostream& os ) const;

    Long_option( const char* long_name, const char short_name );
    ~Long_option();
    };

//-- class Long_option //

/****************************************************************************
  class Long_switch_option
--*/

class Long_switch_option : public Long_option
    {
     friend class Long_option_list;

    int sw_tch;
    
public:
    operator int() const;
    void printOn( ostream& os ) const;

    Long_switch_option( const char* name, const char short_name = 0, const int s = 0 );
    ~Long_switch_option();
    };

//-- class Long_switch_option //

/****************************************************************************
  class Long_string_option
--*/

class Long_string_option : public Long_option
    {
     friend class Long_option_list;

    const char* string;
    
public:
    operator int() const;
    const char* long_option() const;
    const char* short_option() const;
    const char* argument() const;
    void printOn( ostream& os ) const;

    Long_string_option( const char* name, const char short_name = 0, const char* s = 0);
    ~Long_string_option();
    };

//-- class Long_string_option //

/****************************************************************************
  class Long_option_list
--*/

class Long_option_list : public Option_list
    {
public:
    Long_option& get( const char* name );
    void parse( const int argc, char* const argv[] );

    int put( Option& );
    int put( Long_option& long_option );
    
    Long_option_list();
    ~Long_option_list();
    };
    
//-- class Long_option_list //
 
extern Long_switch_option null_long_switch;
    
#endif // __LONG_OPTIONS_H //
