/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.ipdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import de.nm.ant.ipdf.AbstractPagesPdfTask;
import java.io.File;
import java.io.IOException;

public class PdfRotateTask
extends AbstractPagesPdfTask {
    private int angle = 0;

    public void execute() {
        File input = this.getInputFile("pdf", this.usesrcfile);
        File output = this.getOutputFile("pdf");
        this.logVerboseHeader(input, this.pages, output);
        try {
            PdfReader reader = this.createPdfReaderFromFile(input);
            this.maxPage = reader.getNumberOfPages();
            PdfStamper stamper = new PdfStamper(reader, this.createOutputStream(output), this.version);
            int i = 1;
            while (i <= this.maxPage) {
                if (this.isPageinRange(i)) {
                    int rot = reader.getPageRotation(i);
                    PdfDictionary pageDict = reader.getPageN(i);
                    pageDict.put(PdfName.ROTATE, (PdfObject)new PdfNumber(rot + this.angle));
                }
                ++i;
            }
            stamper.close();
        }
        catch (IOException e) {
            this.throwBuildException(e);
        }
        catch (DocumentException e) {
            this.throwBuildException((Exception)((Object)e));
        }
    }

    public void setAngle(int angle) {
        this.angle = angle;
    }
}

