\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{sibjnm}
         [2002/03/24 v1.01 Article class for SibJNM (NCC)]
%
\DeclareOption{a5paper}{\OptionNotUsed}
\DeclareOption{a5a4paper}{\OptionNotUsed}
\DeclareOption{b5paper}{\OptionNotUsed}
\DeclareOption{letterpaper}{\OptionNotUsed}
\DeclareOption{legalpaper}{\OptionNotUsed}
\DeclareOption{executivepaper}{\OptionNotUsed}
\DeclareOption{fittopage}{\OptionNotUsed}
\DeclareOption{10pt}{\OptionNotUsed}
\DeclareOption{12pt}{\OptionNotUsed}
\DeclareOption{14pt}{\OptionNotUsed}
\DeclareOption{oneside}{\OptionNotUsed}
\DeclareOption{twocolumn}{\OptionNotUsed}
\DeclareOption{openbib}{\OptionNotUsed}
\DeclareOption{small}{\OptionNotUsed}
\DeclareOption{fleqn}{\OptionNotUsed}
\DeclareOption{leqno}{\OptionNotUsed}
\DeclareOption{preprint}{\OptionNotUsed}
\DeclareOption{monography}{\OptionNotUsed}
\DeclareOption{report}{\OptionNotUsed}
\DeclareOption{russian}{}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{ncc}}
\PassOptionsToClass{11pt,twoside,onecolumn,article,a4paper}{ncc}
\ProcessOptions\relax
\LoadClass{ncc}
%
% Text area size
%
\ToCenter[h]{155mm}{225mm}
%
% Change TeX parameters
%
\setlength\smallskipamount{2pt plus 1pt minus .5pt}
\setlength\medskipamount  {4pt plus 1pt minus .5pt}
\setlength\bigskipamount  {8pt plus 1pt minus .5pt}
\setlength\floatsep      {12pt plus 1pt minus .5pt}
\setlength\textfloatsep  {12pt plus 1pt minus .5pt}
\setlength\intextsep     {\floatsep}
%
% Centered sections with indentation after them
%
\sectionstyle{center}
\indentaftersection
%
% Russian and English abstracts
%
\@ifclasswith{sibjnm}{russian}{\NCC@rustrue
  \RequirePackage[english,russian]{babel}
  \RequirePackage{nccltrus}
  \def\UDCname{{\cyr\CYRU\CYRD\CYRK}}
  \frenchspacing
  %
  %  Rabstract and Eabstract
  %
  \newenvironment{Rabstract}{\par\addvspace\bigskipamount
    {\footnotesize\noindent \UDCname~\SJNM@UDC}\par\smallskip
    \SJNM@abstr{\SJNM@Rname}%
  }{\par\addvspace{1.5\bigskipamount}}
  \newenvironment{Eabstract}{\par\addvspace\bigskipamount
    \begin{otherlanguage*}{english}\SJNM@abstr{\SJNM@Ename}%
  }{\end{otherlanguage*}%
    \par\smallskip{\centering\rule\linewidth{.5pt}\par}%
    \addvspace{1.5\bigskipamount}%
  }
}{\NCC@rusfalse
  \RequirePackage[russian,english]{babel}
  \def\UDCname{UDC}
  %
  %  Rabstract and Eabstract
  %
  \newenvironment{Rabstract}{\par\addvspace\bigskipamount
    {\footnotesize\noindent \UDCname~\SJNM@UDC}\par\smallskip
    \begin{otherlanguage*}{russian}\SJNM@abstr{\SJNM@Rname}%
  }{\end{otherlanguage*}%
    \par\addvspace{1.5\bigskipamount}%
  }
  \newenvironment{Eabstract}{\par\addvspace\bigskipamount
    \SJNM@abstr{\SJNM@Ename}%
  }{%
    \par\smallskip{\centering\rule\linewidth{.5pt}\par}%
    \addvspace{1.5\bigskipamount}%
  }
}
%
% \SJNM@Rname and \SJNM@Ename are brief journal titles used in abstracts.
% They are defined in the local definition file sibjnm.def.
%
\let\SJNM@Rname\@empty
\let\SJNM@Ename\@empty
\newcommand*\SJNM@abstr[3]{%
  {\hbadness=4000 \pretolerance=1000 {\bf #2} #3~// #1\par}%
  \bigskip\footnotesize
}
%
% UDC or AMS Subject Classification can be used in articles.
%
\newcommand*\UDC[1]{\def\SJNM@UDC{#1}}
\newcommand\AmSclassification{%
  \def\UDCname{\AmS\ subject classification:\,}%
  \let\AmSclassification\UDC
  \UDC
}
\def\No{{\cyr\textnumero}}
%
% Redefine title making command
%
\def\@maketitle{%
  \NCC@null\vskip 2em \centering
  {\LARGE\bff \@title \par} \vskip 1.5em 
  {\large\sf \lineskip .5em \pbox{\@author}\par}%
}
\RequirePackage[title,myheadings]{ncchdr}
\def\NCC@articlehead{\thispagestyle{title}}
%
% Defaults
%
\UDC{???}
\renewcommand{\headrulewidth}{\p@}
\renewcommand{\headstrutheight}{.2\normalbaselineskip}
\InputIfFileExists{sibjnm.def}{}{}% Load a file of local definitions
\endinput
