{$A+,B-,D-,E-,F-,I+,L-,N-,O-,R-,S-,V+}
{$M 2000,0,655360}
{ Turbo Pascal 6.0 }
program ViewPCL;

(*
View a PCL file on the screen.
Only bitmaps of the form <Esc>*b#W.... are supported.
All other escape sequences are ignored.

Erik Frambach
*)

uses GRAPH, CRT;

const
  gc_MaxBitmap = 5000;
var
  gv_File      : file;
  gv_Bitmap    : array [1..gc_MaxBitmap] of byte; { *8 pixels per line }
  gv_Xadjust   : integer;


procedure ShowSyntax;
begin
WriteLn ('Syntax: VIEWPCL <filename> [bgi-path] [x-adjust] [y-adjust]');
WriteLn ('examples:');
WriteLn ('  VIEWPCL myfile.pcl');
WriteLn ('  VIEWPCL myfile.pcl c:\pascal');
WriteLn ('  VIEWPCL myfile.pcl c:\pascal +300 -100');
WriteLn ('The file must contain HP LaserJet bitmaps of the form <Esc>*b#W....');
WriteLn ('All other escape sequences are ignored.');
Halt
end;


procedure RestoreScreen;
begin
Close (gv_File);
Sound (2000);
Delay (100);
NoSound;
if ReadKey = 'x' then;
CloseGraph
end;


procedure OpenFile;
var
  lv_Seq      : array [1..3] of byte;
  lv_SeqFound : boolean;
  lv_FilePos  : longint;
begin
if ParamCount = 0 then
  ShowSyntax;
Assign (gv_File, ParamStr (1));
Reset (gv_File, 1);
lv_SeqFound := false;
repeat
  lv_FilePos := FilePos (gv_File);
  BlockRead (gv_File, lv_Seq [1], 1);
  if Ord (lv_Seq [1]) = Ord (#27) then
    begin
    BlockRead (gv_File, lv_Seq [2], 1);
    if Ord (lv_Seq [2]) = Ord ('*') then
      BlockRead (gv_File, lv_Seq [3], 1)
    else
      lv_Seq [3]:= 0;
    lv_SeqFound := (Ord (lv_Seq [2]) = Ord ('*')) and
                   (Ord (lv_Seq [3]) = Ord ('b'))
    end
until lv_SeqFound;
Seek (gv_File, lv_FilePos)
end;


procedure ReadBitmap (var pv_Count : word);
var
  lv_Size,
  i        : word;
  lv_Byte  : byte;
  lv_Check : word;
begin
pv_Count := 0;
repeat
  BlockRead (gv_File, lv_Byte, 1, lv_Check)
until (Ord (lv_Byte) = Ord (#27)) or (lv_Check = 0);
if lv_Check = 0 then
  lv_Byte := 0
else
  BlockRead (gv_File, lv_Byte, 1, lv_Check);
if Ord (lv_Byte) <> Ord ('*') then
  pv_Count := 0
else
  begin
  BlockRead (gv_File, lv_Byte, 1, lv_Check);
  if Ord (lv_Byte) = Ord ('b') then
    repeat
      BlockRead (gv_File, lv_Byte, 1, lv_Check);
      if Chr (lv_Byte) in ['0','1','2','3','4','5','6','7','8','9'] then
        pv_Count := (pv_Count * 10) + lv_Byte - 48;
    until Ord (lv_Byte) = Ord ('W');
  if pv_Count > gc_MaxBitmap then
    begin
    RestoreScreen;
    WriteLn (pv_Count, ' bitmaps is too much for me...');
    Halt
    end;
  BlockRead (gv_File, gv_Bitmap, pv_Count, lv_Check)
  end
end;


procedure ShowBitmap (y        : integer;
                      pc_Count : word);
var
  i,
  x        : integer;
  lv_Image : record
               _x, _y,
               _reserved : word;
               _map      : byte;
               _resmap   : byte;
             end;
begin
x := gv_Xadjust;
with lv_Image do
  begin
  _x := 7;
  _y := 0;
  _reserved := 0;
  _resmap := 0
  end;
for i := 1 to pc_Count do
  begin
  if (gv_Bitmap [i] <> 0) and (x >= 0) and (x + 8 < GetMaxX) then
    begin
    lv_Image._map := gv_Bitmap [i];
    PutImage (x, y, lv_Image, NormalPut)
    end;
  Inc (x, 8)
  end
end;


procedure ShowPicture;
var
  lv_GrDriver,
  lv_GrMode,
  lv_Check,
  y            : integer;
  lv_Count     : word;
begin
lv_GrDriver := Detect;
InitGraph (lv_GrDriver, lv_GrMode, ParamStr (2));
if ParamStr (3) <> '' then
  Val (ParamStr (3), gv_Xadjust, lv_Check)
else
  gv_Xadjust := 0;
if ParamStr (4) <> '' then
  Val (ParamStr (4), y, lv_Check)
else
  y := 0;
repeat
  ReadBitmap (lv_Count);
  if y >= 0 then
    ShowBitmap (y, lv_Count);
  Inc (y)
until y > GetMaxY
end;


begin
OpenFile;
ShowPicture;
RestoreScreen
end.
