{$IFDEF WINDOWS}
{$N-,V-,W-,G+,C MOVEABLE DISCARDABLE}
{$ELSE}
{$N-,E-,V-,F+,O+}
{$ENDIF}

Unit bibsort;

Interface

Uses
{$IFDEF WINDOWS}
  Wobjects, WinDos, wbibdisp, strings, wintypes, wbibgui,
{$ELSE}
  Dos, Objects, bibdisp,
{$ENDIF}
  bibstrg, streams, bibstrm, bibvars, bibfile, bibutil,rc_strng;

type
  TSortReadWriteProc = procedure(P: PAuxStream; Rec: pointer); 
  TSortCompProc      = function(R1,R2: pointer): integer;

function SortAList(TEList: PAuxstream; N: longint; Rec1,Rec2: Pointer;
                   ReadRec,WriteRec: TSortReadWriteProc;
                   CompRecs: TSortCompProc): boolean;

implementation


function SortAList(TEList: PAuxStream; N: longint; Rec1,Rec2: Pointer;
                   ReadRec,WriteRec: TSortReadWriteProc;
                   CompRecs: TSortCompProc): boolean;         
var
  Srec: array[0..1] of pointer;
  P: array[0..1,0..1] of PAuxStream;
  nwr: array[0..1,0..1] of longint;
  ind: array[0..1] of longint;
  Finish: array[0..1] of Boolean;
  Current,i,j,Block,Next: byte;
  BlockSize,ii,orgsize,BlockStart: longint;
  Filler: TNulStream;
  ok: boolean;

procedure CreateStream(var F: PAuxStream; FillCount: longint; var ok: boolean);
begin
  if not ok then Exit;
  ok:=false;
  New(F,Init(WorkStreamOrder)); if F=Nil then Exit;
  F^.seek(0); F^.truncate;
  if FillCount>0 then
  begin
    F^.CopyFrom(Filler,FillCount);
    F^.seek(0);
  end;
  if F^.status=stOK then ok:=true;
end;                { CreateStream }

procedure TidyUp;

procedure KillStream(var F: PAuxStream);
begin
  if F=Nil then Exit;
  F^.reset; Dispose(F,Done); F:=Nil;
end;

begin
  KillStream(P[1,1]); KillStream(P[0,1]); KillStream(P[0,0]);
  SortAList:=ok;
  Filler.Done;
end;

begin         { SortAList }
  ok:=true; SortAList:=true;
  if (TElist=Nil) or (N<2) then Exit;
  Srec[0]:=Rec1; Srec[1]:=Rec2;
  TElist^.Reset;
  OrgSize:=TElist^.getsize;
  for i:=0 to 1 do for j:=0 to 1 do P[i,j]:=Nil;
  Filler.Init(255);
  CreateStream(P[0,0],OrgSize,ok);
  CreateStream(P[0,1],OrgSize,ok);
  CreateStream(P[1,1],0,ok);
  if not ok then
  begin
    TidyUp; Exit;
  end;
                                         { First iteration }
  TElist^.seek(0);
  ii:=1; Block:=0;
  nwr[0,0]:=0; nwr[0,1]:=0;
  while (ii<N) do
  begin
    ReadRec(TElist,Srec[0]);
    ReadRec(TElist,Srec[1]);
    if CompRecs(Srec[0],Srec[1])<1 then
    begin
      WriteRec(P[0,Block],Srec[0]); WriteRec(P[0,Block],Srec[1]);
    end else
    begin
      WriteRec(P[0,Block],Srec[1]); WriteRec(P[0,Block],Srec[0]);
    end;
    nwr[0,Block]:=nwr[0,Block]+2;
    if TElist^.status<>stOK then ErrorMessage(' TElist is stuck at '+num2str(ii)+' ');
    if P[0,Block]^.status<>stOK then
      ErrorMessage(' P[0,'+num2str(Block)+'] is stuck at '+num2str(ii)+' ');
    Block:=1-Block;
    ii:=ii+2;
  end;
  if ii=N then
  begin
    ReadRec(TElist,Srec[0]); WriteRec(P[0,Block],Srec[0]);
    nwr[0,Block]:=nwr[0,Block]+1;
  end;
  if (P[0,0]^.status<>stOK) or (P[0,1]^.status<>stOK) then
  begin
    ok:=false; TidyUp; Exit;
  end;
  P[1,0]:=TElist;
  MaxMemAvail;
                            { Start work }
  Current:=0; BlockSize:=2;
  TrapAbort;
  while (BlockSize<N) and (not AbortFlag) do              { Iterations }
  begin
    Next:=1-Current;
    for i:=0 to 1 do for j:=0 to 1 do P[i,j]^.seek(0);
    Block:=0; BlockStart:=0;
    ind[0]:=1; Ind[1]:=1;
    nwr[next,0]:=0; nwr[next,1]:=0;
    repeat                                { Loop over pairs of blocks }
      for i:=0 to 1 do
      if ind[i]<=nwr[Current,i] then
      begin
        ReadRec(P[Current,i],Srec[i]); inc(ind[i]); Finish[i]:=false;
      end else Finish[i]:=true;
      while not (Finish[0] and Finish[1]) do    { Inside each block }
      begin
        if (not Finish[0]) and (Finish[1] or (CompRecs(Srec[0],Srec[1])<1))
          then i:=0
        else i:=1;
        WriteRec(P[Next,Block],Srec[i]);
        if (ind[i]<=nwr[Current,i]) and (ind[i]-BlockStart<=BlockSize) then
        begin
          ReadRec(P[Current,i],Srec[i]); inc(ind[i]);
        end else Finish[i]:=true;
        inc(nwr[next,block]);
      end;
      Block:=1-Block;
      BlockStart:=BlockStart+BlockSize;
      TrapAbort;
    until ((ind[0]>nwr[Current,0]) and (ind[1]>nwr[Current,1])) or AbortFlag;
    Current:=Next; BlockSize:=BlockSize*2;
  end;
  for i:=0 to 1 do for j:=0 to 1 do if P[i,j]^.Status<>stOK then ok:=false;
  if AbortFlag then ok:=false;
  if ok and (Next=0) then  { Otherwise P[Next,0]=TElist anyway }
  begin
    P[Next,0]^.Reset; P[Next,0]^.seek(0);
    TElist^.Reset; TElist^.seek(0); TElist^.Truncate;
    TElist^.CopyFrom(P[Next,0]^,P[Next,0]^.GetSize);
  end;
  TidyUp;
  TElist^.seek(0);
end;                          { SortElist }

end.
