/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.internal.wizards.XMind2008Exporter;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.wizards.AbstractMindMapExportPage;
import org.xmind.ui.wizards.AbstractMindMapExportWizard;

public class XMind2008ExportWizard
extends AbstractMindMapExportWizard {
    private static final String DIALOG_SETTINGS_SECTION_ID = "org.xmind.ui.export.xmind2008";
    private static final String PAGE_NAME = "htmlExportPage";
    private static final String FILE_EXT = ".xmap";
    private static final String FILTER = "*.xmap";
    private IWorkbook sourceWorkbook;
    private XMind2008ExportPage page;

    public XMind2008ExportWizard() {
        this.setWindowTitle(WizardMessages.XMind2008ExportWizard_windowTitle);
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
        this.setDialogSettings(MindMapUIPlugin.getDefault().getDialogSettings(DIALOG_SETTINGS_SECTION_ID));
    }

    @Override
    public void setSourceEditor(IGraphicalEditor sourceEditor) {
        super.setSourceEditor(sourceEditor);
        this.sourceWorkbook = this.findWorkbook(sourceEditor);
    }

    @Override
    public boolean hasSource() {
        return this.getSourceEditor() != null && this.sourceWorkbook != null;
    }

    private IWorkbook findWorkbook(IGraphicalEditor editor) {
        if (editor == null) {
            return null;
        }
        return (IWorkbook)editor.getAdapter(IWorkbook.class);
    }

    @Override
    protected void addValidPages() {
        this.page = new XMind2008ExportPage();
        this.addPage((IWizardPage)this.page);
    }

    @Override
    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    @Override
    protected String getFormatName() {
        return WizardMessages.XMind2008ExportWizard_formatName;
    }

    @Override
    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ExportToXMind2008Count");
        XMind2008Exporter exporter = new XMind2008Exporter(this.sourceWorkbook, this.getTargetPath());
        exporter.setMonitor(monitor);
        exporter.export();
    }

    @Override
    protected String getSuggestedFileName() {
        String suggestedName = null;
        IGraphicalEditor editor = this.getSourceEditor();
        IWorkbookRef workbookRef = (IWorkbookRef)editor.getAdapter(IWorkbookRef.class);
        if (workbookRef != null) {
            suggestedName = workbookRef.getName();
        }
        if (suggestedName == null) {
            suggestedName = this.getSourceEditor().getTitle();
        }
        return String.valueOf(FileUtils.getNoExtensionFileName((String)new File(suggestedName).getName())) + FILE_EXT;
    }

    private class XMind2008ExportPage
    extends AbstractMindMapExportPage {
        public XMind2008ExportPage() {
            super(XMind2008ExportWizard.PAGE_NAME, WizardMessages.XMind2008ExportPage_title);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            this.setControl((Control)composite);
            Control fileGroup = this.createFileControls(composite);
            fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        }

        @Override
        protected void setDialogFilters(FileDialog dialog, List<String> filterNames, List<String> filterExtensions) {
            filterNames.add(0, WizardMessages.XMind2008ExportPage_filterName);
            filterExtensions.add(0, XMind2008ExportWizard.FILTER);
            super.setDialogFilters(dialog, filterNames, filterExtensions);
        }
    }
}

