/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IEditorInput;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.internal.editor.WorkbookHistoryItem;

@Deprecated
public class WorkbookHistory {
    private static final int MAX_SIZE = 100;
    private static WorkbookHistory instance = null;
    private List<WorkbookHistoryItem> items = new ArrayList<WorkbookHistoryItem>(100);
    private long lastModifiedTime = 0L;
    private Thread saveRunner = null;
    private ListenerList listeners = new ListenerList();

    private WorkbookHistory() {
        this.load();
    }

    public void addWorkbookHistoryListener(IWorkbookHistoryListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeWorkbookHistoryListener(IWorkbookHistoryListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void add(IEditorInput input) {
        File file = MME.getFile(input);
        if (file != null) {
            String uri = WorkbookHistoryItem.toURI(file.getAbsolutePath());
            this.remove(input, uri);
            this.items.add(0, new WorkbookHistoryItem(input, uri, System.currentTimeMillis()));
            while (this.items.size() > 100) {
                this.items.remove(this.items.size() - 1);
            }
            this.lastModifiedTime = System.currentTimeMillis();
            this.scheduleSave();
            this.fireUpdated();
        }
    }

    private void remove(IEditorInput input, String uri) {
        Iterator<WorkbookHistoryItem> it = this.items.iterator();
        while (it.hasNext()) {
            WorkbookHistoryItem item = it.next();
            if ((uri == null || !uri.equals(item.getURI())) && (item.getExistingEditorInput() == null || !item.getExistingEditorInput().equals(input))) continue;
            it.remove();
        }
    }

    public void remove(IEditorInput input) {
        if (input == null) {
            return;
        }
        this.remove(input, null);
        this.lastModifiedTime = System.currentTimeMillis();
        this.scheduleSave();
        this.fireUpdated();
    }

    public void clear() {
        this.items.clear();
        this.lastModifiedTime = System.currentTimeMillis();
        this.save();
    }

    public WorkbookHistoryItem[] getItems() {
        return this.items.toArray(new WorkbookHistoryItem[this.items.size()]);
    }

    public WorkbookHistoryItem[] getTopItems(int size) {
        size = Math.max(0, Math.min(size, this.items.size()));
        return this.items.subList(0, size).toArray(new WorkbookHistoryItem[size]);
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public boolean load() {
        File file = WorkbookHistory.getHistoryFile();
        if (file == null) {
            return false;
        }
        Properties cache = new Properties();
        try {
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file), 1024);
            try {
                cache.load(stream);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            return false;
        }
        this.items.clear();
        if (!cache.isEmpty()) {
            int i = 0;
            while (i < 100) {
                int sepPos;
                String value = cache.getProperty("item." + i);
                if (value != null && (sepPos = value.indexOf(44)) > 0) {
                    try {
                        long time = Long.parseLong(value.substring(0, sepPos), 10);
                        String uri = value.substring(sepPos + 1);
                        this.items.add(new WorkbookHistoryItem(null, uri, time));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ++i;
            }
        }
        this.lastModifiedTime = System.currentTimeMillis();
        return true;
    }

    private synchronized void scheduleSave() {
        Thread t = this.saveRunner;
        if (t != null) {
            t.interrupt();
        }
        t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                WorkbookHistory.this.save();
            }
        });
        t.setDaemon(true);
        t.setName("Save Workbook History");
        t.start();
        this.saveRunner = t;
    }

    public synchronized boolean save() {
        File file = WorkbookHistory.getHistoryFile();
        if (file == null) {
            return false;
        }
        File dir = file.getParentFile();
        if (!dir.exists() || !dir.isDirectory()) {
            if (!dir.mkdirs()) {
                return false;
            }
            if (!dir.exists() || !dir.isDirectory()) {
                return false;
            }
        }
        Properties cache = new Properties();
        int i = 0;
        while (i < this.items.size()) {
            WorkbookHistoryItem item = this.items.get(i);
            String key = "item." + i;
            String value = String.valueOf(Long.toString(item.getTime(), 10)) + "," + item.getURI();
            cache.put(key, value);
            ++i;
        }
        try {
            FileOutputStream stream = new FileOutputStream(file);
            try {
                cache.store(stream, "Generated by org.xmind.ui.internal.editor.WorkbookHistory");
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void fireUpdated() {
        if (this.listeners.isEmpty()) {
            return;
        }
        Object[] theListeners = this.listeners.getListeners();
        int i = 0;
        while (i < theListeners.length) {
            final IWorkbookHistoryListener listener = (IWorkbookHistoryListener)theListeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.workbookHistoryUpdated();
                }
            });
            ++i;
        }
    }

    private static File getHistoryFile() {
        Location instanceLocation = Platform.getInstanceLocation();
        if (instanceLocation == null) {
            return null;
        }
        URL url = instanceLocation.getURL();
        if (url == null) {
            return null;
        }
        try {
            url = FileLocator.toFileURL((URL)url);
        }
        catch (IOException iOException) {
            return null;
        }
        String workspace = url.getFile();
        if (workspace == null || "".equals(workspace)) {
            return null;
        }
        IProduct product = Platform.getProduct();
        if (product != null && "org.xmind.cathy.application".equals(product.getApplication())) {
            return new File(workspace, "workbookhistory.properties");
        }
        return new File(new File(workspace, ".xmind"), "workbookhistory.properties");
    }

    public static WorkbookHistory getInstance() {
        if (instance == null) {
            instance = new WorkbookHistory();
        }
        return instance;
    }

    @Deprecated
    public static interface IWorkbookHistoryListener {
        public void workbookHistoryUpdated();
    }
}

