/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorators;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.TextStyle;
import org.xmind.gef.draw2d.IMinimizable;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.mindmap.INumberingPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.style.StyleUtils;

public class NumberingDecorator
extends Decorator {
    private static final NumberingDecorator instance = new NumberingDecorator();

    protected NumberingDecorator() {
    }

    public void activate(IGraphicalPart part, IFigure figure) {
        super.activate(part, figure);
        figure.setMinimumSize(IMinimizable.DEFAULT_MIN_SIZE);
    }

    public void decorate(IGraphicalPart part, IFigure figure) {
        super.decorate(part, figure);
        if (figure instanceof ITextFigure && part instanceof INumberingPart) {
            ITextFigure textFigure = (ITextFigure)figure;
            String text = ((INumberingPart)part).getFullNumberingText();
            if (text != null) {
                textFigure.setText(text);
            }
            this.decorateTextFigure(part, textFigure);
        }
    }

    protected void decorateTextFigure(IGraphicalPart part, ITextFigure figure) {
        IGraphicalPart parent = this.getOwnerPart(part);
        if (parent != null) {
            part = parent;
        }
        this.decorateTextFigure(part, StyleUtils.getStyleSelector(part), figure);
    }

    protected void decorateTextFigure(IGraphicalPart ownerPart, IStyleSelector ss, ITextFigure figure) {
        TextStyle style = StyleUtils.getTextStyle(ownerPart, ss);
        if (style != null) {
            figure.setStyle(style);
        } else {
            figure.setFont(StyleUtils.getCompositeFont(ownerPart, ss, JFaceResources.getDefaultFont()));
            figure.setForegroundColor(StyleUtils.getColor(ownerPart, ss, "fo:color", null, "#000000"));
        }
    }

    protected IGraphicalPart getOwnerPart(IGraphicalPart part) {
        if (part.getParent() instanceof ITopicPart) {
            return ((ITopicPart)part.getParent()).getOwnerBranch();
        }
        return null;
    }

    public static NumberingDecorator getInstance() {
        return instance;
    }
}

