/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.decoration.CompoundDecoration;
import org.xmind.gef.draw2d.decoration.IConnectionDecoration;
import org.xmind.gef.draw2d.decoration.ICorneredDecoration;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.draw2d.decoration.ILineDecoration;
import org.xmind.gef.draw2d.decoration.IShadowedDecoration;
import org.xmind.ui.decorations.IBranchConnectionDecoration;
import org.xmind.ui.decorations.IBranchConnections2;

public class CalloutBranchConnections
extends CompoundDecoration
implements IBranchConnections2,
IShadowedDecoration {
    private List<IAnchor> sourceAnchors = new ArrayList<IAnchor>();
    private List<Color> lineColors = new ArrayList<Color>();
    private List<Integer> lineStyles = new ArrayList<Integer>();
    private List<Integer> lineWidths = new ArrayList<Integer>();
    private List<Integer> sourceOrientations = new ArrayList<Integer>();
    private List<Integer> sourceExpansions = new ArrayList<Integer>();
    private List<Integer> cornerSizes = new ArrayList<Integer>();
    private boolean tapered = false;
    private HashMap<IFigure, IDecoration> figureToDecoration = new HashMap();

    @Override
    public Color getLineColor(int index) {
        if (this.lineColors.size() <= index) {
            return null;
        }
        return this.lineColors.get(index);
    }

    @Override
    public int getLineStyle(int index) {
        if (this.lineStyles.size() <= index) {
            return 1;
        }
        return this.lineStyles.get(index);
    }

    @Override
    public int getLineWidth(int index) {
        if (this.lineWidths.size() <= index) {
            return 1;
        }
        return this.lineWidths.get(index);
    }

    @Override
    public void setLineColor(IFigure figure, int index, Color color) {
        if (this.lineColors.size() > index) {
            Color oldColor = this.lineColors.get(index);
            if (oldColor == color || oldColor != null && oldColor.equals((Object)color)) {
                return;
            }
            this.lineColors.set(index, color);
        } else {
            this.lineColors.add(index, color);
        }
        if (figure != null) {
            this.repaint(figure);
        }
        this.update(figure, index);
    }

    public void putFigureToDecoration(IFigure figure, IDecoration decoration) {
        this.figureToDecoration.put(figure, decoration);
    }

    public IDecoration getDecoration(IFigure figure) {
        return this.figureToDecoration.get(figure);
    }

    private void update(IFigure figure) {
        for (IDecoration decoration : this.getDecorations()) {
            if (decoration == null) continue;
            this.update(figure, decoration);
        }
    }

    protected void update(IFigure figure, IDecoration decoration) {
        super.update(figure, decoration);
        this.updateAnchor(figure, this.getDecorations().indexOf(decoration));
        this.updateConnection(figure, decoration);
    }

    private void updateConnection(IFigure figure, IDecoration decoration) {
        int index = this.getDecorations().indexOf(decoration);
        if (decoration instanceof ICorneredDecoration) {
            ((ICorneredDecoration)decoration).setCornerSize(figure, this.getCornerSize(index));
        }
        if (decoration instanceof ILineDecoration) {
            ILineDecoration line = (ILineDecoration)decoration;
            line.setLineColor(figure, this.getLineColor(index));
            line.setLineStyle(figure, this.getLineStyle(index));
            line.setLineWidth(figure, this.getLineWidth(index));
        }
        if (decoration instanceof IBranchConnectionDecoration) {
            IBranchConnectionDecoration conn = (IBranchConnectionDecoration)decoration;
            conn.setSourceOrientation(figure, this.getSourceOrientation(index));
            conn.setSourceExpansion(figure, this.getSourceExpansion(index));
            conn.setTapered(figure, this.tapered);
        }
    }

    private void update(IFigure figure, int index) {
        IDecoration decoration = (IDecoration)this.getDecorations().get(index);
        super.update(figure, decoration);
        this.updateAnchor(figure, index);
        this.updateConnection(figure, decoration);
    }

    @Override
    public void setLineWidth(IFigure figure, int index, int width) {
        if (this.lineWidths.size() > index) {
            Integer lineWidth = this.lineWidths.get(index);
            if (lineWidth == width) {
                return;
            }
            this.lineWidths.set(index, width);
        } else {
            this.lineWidths.add(index, width);
        }
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
        this.update(figure, index);
    }

    @Override
    public void setLineStyle(IFigure figure, int index, int style) {
        if (this.lineStyles.size() > index) {
            Integer lineStyle = this.lineStyles.get(index);
            if (lineStyle == style) {
                return;
            }
            this.lineStyles.set(index, style);
        } else {
            this.lineStyles.add(index, style);
        }
        if (figure != null) {
            this.repaint(figure);
        }
        this.update(figure, index);
    }

    @Override
    public int getCornerSize(int index) {
        if (this.cornerSizes.size() <= index) {
            return 0;
        }
        return this.cornerSizes.get(index);
    }

    @Override
    public void setCornerSize(IFigure figure, int index, int cornerSize) {
        if (this.cornerSizes.size() > index) {
            Integer size = this.cornerSizes.get(index);
            if (size == cornerSize) {
                return;
            }
            this.cornerSizes.set(index, cornerSize);
        } else {
            this.cornerSizes.add(index, cornerSize);
        }
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
        this.update(figure);
    }

    public void paintShadow(IFigure figure, Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        this.checkValidation(figure);
        for (IDecoration decoration : this.getDecorations()) {
            if (!(decoration instanceof IShadowedDecoration)) continue;
            ((IShadowedDecoration)decoration).paintShadow(figure, graphics);
        }
    }

    @Override
    public void setSourceOrientation(IFigure figure, int index, int orientation) {
        if (this.sourceOrientations.size() > index) {
            Integer oldOrientation = this.sourceOrientations.get(index);
            if (oldOrientation == orientation) {
                return;
            }
            this.sourceOrientations.set(index, orientation);
        } else {
            this.sourceOrientations.add(index, orientation);
        }
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
        this.update(figure, index);
    }

    @Override
    public void setSourceExpansion(IFigure figure, int index, int expansion) {
        if (this.sourceExpansions.size() > index) {
            Integer oldExpansion = this.sourceExpansions.get(index);
            if (oldExpansion == expansion) {
                return;
            }
            this.sourceExpansions.set(index, expansion);
        } else {
            this.sourceExpansions.add(index, expansion);
        }
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
        this.update(figure, index);
    }

    @Override
    public void setTapered(IFigure figure, boolean tapered) {
        if (tapered == this.tapered) {
            return;
        }
        this.tapered = tapered;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
        this.update(figure);
    }

    @Override
    public int getSourceExpansion(int index) {
        if (this.sourceExpansions.size() <= index) {
            return 0;
        }
        return this.sourceExpansions.get(index);
    }

    @Override
    public int getSourceOrientation(int index) {
        if (this.sourceOrientations.size() <= index) {
            return 0;
        }
        return this.sourceOrientations.get(index);
    }

    @Override
    public boolean isTapered() {
        return this.tapered;
    }

    @Override
    public IAnchor getSourceAnchor(int index) {
        if (this.sourceAnchors.size() <= index) {
            return null;
        }
        return this.sourceAnchors.get(index);
    }

    @Override
    public void setSourceAnchor(IFigure figure, int index, IAnchor anchor) {
        if (this.sourceAnchors.size() > index) {
            IAnchor oldAnchor = this.sourceAnchors.get(index);
            if (oldAnchor == anchor || oldAnchor != null && oldAnchor.equals(anchor)) {
                return;
            }
            this.sourceAnchors.set(index, anchor);
        } else {
            this.sourceAnchors.add(index, anchor);
        }
        this.updateAnchor(figure, index);
    }

    private void updateAnchor(IFigure figure, int index) {
        IDecoration decoration = this.getDecoration(index);
        if (decoration instanceof IConnectionDecoration) {
            ((IConnectionDecoration)decoration).setSourceAnchor(figure, this.getSourceAnchor(index));
        }
    }

    @Override
    public void rerouteAll(IFigure figure) {
        int size = this.size();
        int i = 0;
        while (i < size) {
            IDecoration decoration = this.getDecoration(i);
            if (decoration instanceof IConnectionDecoration) {
                ((IConnectionDecoration)decoration).reroute(figure);
            }
            ++i;
        }
        if (figure != null) {
            this.repaint(figure);
        }
    }
}

