/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import java.util.ArrayList;
import org.xmind.core.Core;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;

public class CopiedSheetStorageSupport {
    private static CopiedSheetStorageSupport instance = null;
    private ISheet copiedSheet = null;

    private CopiedSheetStorageSupport() {
    }

    public static CopiedSheetStorageSupport getInstance() {
        if (instance == null) {
            instance = new CopiedSheetStorageSupport();
        }
        return instance;
    }

    public void setCopiedSheet(ISheet sheet) {
        this.copiedSheet = this.cloneSheet(sheet);
    }

    public ISheet getCopiedSheet(IWorkbook workbook) {
        return this.cloneSheet(workbook, this.copiedSheet);
    }

    public boolean isCopiedSheetExist() {
        return this.copiedSheet != null;
    }

    private ISheet cloneSheet(ISheet sheet) {
        IWorkbook workbook = Core.getWorkbookBuilder().createWorkbook();
        return this.cloneSheet(workbook, sheet);
    }

    public ISheet cloneSheet(IWorkbook workbook, ISheet sheet) {
        if (sheet == null) {
            return null;
        }
        ArrayList<ISheet> sheetList = new ArrayList<ISheet>();
        sheetList.add(sheet);
        ISheet clonedSheet = (ISheet)workbook.clone(sheetList).getCloneds().iterator().next();
        return clonedSheet;
    }
}

