/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.commands;

import org.xmind.core.IComment;
import org.xmind.core.IWorkbook;
import org.xmind.gef.command.SourceCommand;

public class AddCommentCommand
extends SourceCommand {
    private String author;
    private long time;
    private String objectId;
    private String content;
    private IWorkbook workbook;
    private IComment comment;

    public AddCommentCommand(String author, long time, String objectId, String content, IWorkbook workbook) {
        super(workbook.getElementById(objectId));
        this.author = author;
        this.time = time;
        this.objectId = objectId;
        this.content = content;
        this.workbook = workbook;
    }

    public AddCommentCommand(String author, long time, String objectId, String content, IWorkbook workbook, IComment comment) {
        this(author, time, objectId, content, workbook);
        this.comment = comment;
    }

    public void redo() {
        if (this.comment == null) {
            this.comment = this.workbook.getCommentManager().createComment(this.author, this.time, this.objectId);
        }
        if (!this.content.equals(this.comment.getContent())) {
            this.comment.setContent(this.content);
        }
        this.workbook.getCommentManager().addComment(this.comment);
        super.redo();
    }

    public void undo() {
        this.workbook.getCommentManager().removeComment(this.comment);
        super.undo();
    }
}

