/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.workbench.internal;

import java.lang.reflect.InvocationTargetException;
import net.xmind.core.IAccount;
import net.xmind.workbench.internal.AuthDataCollector;
import net.xmind.workbench.internal.CathyUsageDataCollector;
import net.xmind.workbench.internal.NewsletterSubscriptionReminder;
import net.xmind.workbench.internal.XMindNetWorkbench;
import net.xmind.workbench.internal.notification.SiteEventNotificationService;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.services.IEvaluationService;
import org.xmind.core.net.http.HttpException;
import org.xmind.core.usagedata.IUsageDataSampler;

public class XMindNetWorkbenchServiceCenter
implements IStartup,
IWorkbenchListener,
IPropertyChangeListener {
    private static final int NEXT_ACCOUNT_UPDATE_DELAY = 86400000;
    private static final String USAGE_DATA_UPLOADING_ENABLED = "usageDataUploadingEnabled";
    private SiteEventNotificationService eventService = null;
    private AuthDataCollector authDataCollector = new AuthDataCollector();
    private IPreferenceStore udcPrefStore = null;

    public void earlyStartup() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            this.startServices(workbench);
            workbench.addWorkbenchListener((IWorkbenchListener)this);
        }
    }

    private IAccount findPrimaryAccount(IWorkbench workbench) {
        IEvaluationService service = (IEvaluationService)workbench.getService(IEvaluationService.class);
        if (service == null) {
            return null;
        }
        IEvaluationContext state = service.getCurrentState();
        if (state == null) {
            return null;
        }
        return (IAccount)state.getVariable("net.xmind.ui.primaryAccount");
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        return true;
    }

    public void postShutdown(IWorkbench workbench) {
        this.stopServices();
    }

    private void startServices(IWorkbench workbench) {
        IAccount account = this.findPrimaryAccount(workbench);
        if (account != null) {
            this.updateAuthInfo(workbench.getDisplay(), account);
        }
        if (this.eventService == null) {
            this.eventService = new SiteEventNotificationService(workbench, account);
            this.eventService.start();
        }
        new NewsletterSubscriptionReminder(workbench).start();
        this.authDataCollector.setAccount(account);
        this.udcPrefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.xmind.cathy");
        this.udcPrefStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.updateUsageDataSampler();
    }

    private void updateAuthInfo(final Display display, final IAccount account) {
        Job job = XMindNetWorkbench.getDefault().createJob("Update XMind.net Account Info", false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    account.update(monitor);
                }
                catch (HttpException e) {
                    throw new InvocationTargetException(e);
                }
            }
        });
        job.setSystem(true);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                super.done(event);
                if (display.isDisposed()) {
                    return;
                }
                display.asyncExec(new Runnable(){

                    public void run() {
                        display.timerExec(86400000, new Runnable(){

                            public void run() {
                                XMindNetWorkbenchServiceCenter.this.updateAuthInfo(display, account);
                            }
                        });
                    }
                });
            }
        });
        job.schedule();
    }

    private void updateUsageDataSampler() {
        IUsageDataSampler usageDataSampler = XMindNetWorkbench.getDefault().getUsageDataCollector();
        if (usageDataSampler instanceof CathyUsageDataCollector) {
            ((CathyUsageDataCollector)usageDataSampler).setUploadEnabled(this.udcPrefStore.getBoolean(USAGE_DATA_UPLOADING_ENABLED));
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (USAGE_DATA_UPLOADING_ENABLED.equals(event.getProperty())) {
            this.updateUsageDataSampler();
        }
    }

    private void stopServices() {
        this.udcPrefStore.removePropertyChangeListener((IPropertyChangeListener)this);
        this.udcPrefStore = null;
        this.authDataCollector.setAccount(null);
        if (this.eventService != null) {
            this.eventService.shutdown();
            this.eventService = null;
        }
    }
}

