/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.decoration;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.decoration.IDecoration;

public abstract class AbstractDecoration
implements IDecoration {
    private String id;
    private int alpha = 255;
    private boolean visible = true;
    private boolean valid = false;

    protected AbstractDecoration() {
    }

    protected AbstractDecoration(String id) {
        this.id = id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void invalidate() {
        this.setValid(false);
    }

    protected boolean isValid() {
        return this.valid;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void paint(IFigure figure, Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        this.checkValidation(figure);
        if (!this.isVisible()) {
            return;
        }
        graphics.pushState();
        try {
            this.performPaint(figure, graphics);
        }
        finally {
            graphics.popState();
        }
    }

    protected void checkValidation(IFigure figure) {
        if (!this.isValid()) {
            this.validate(figure);
        }
    }

    public void validate(IFigure figure) {
        this.setValid(true);
    }

    protected abstract void performPaint(IFigure var1, Graphics var2);

    public void setAlpha(IFigure figure, int alpha) {
        if (alpha == this.alpha) {
            return;
        }
        this.alpha = alpha;
        if (figure != null) {
            this.repaint(figure);
        }
    }

    protected void repaint(IFigure figure) {
        figure.repaint();
    }

    protected void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setVisible(IFigure figure, boolean visible) {
        if (visible == this.visible) {
            return;
        }
        this.visible = visible;
        if (figure != null) {
            this.repaint(figure);
        }
    }
}

