/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.SkippingStreamCipher;
import org.bouncycastle.crypto.StreamBlockCipher;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Pack;

public class SICBlockCipher
extends StreamBlockCipher
implements SkippingStreamCipher {
    private final BlockCipher cipher;
    private final int blockSize;
    private byte[] IV;
    private byte[] counter;
    private byte[] counterOut;
    private int byteCount;

    public SICBlockCipher(BlockCipher c) {
        super(c);
        this.cipher = c;
        this.blockSize = this.cipher.getBlockSize();
        this.IV = new byte[this.blockSize];
        this.counter = new byte[this.blockSize];
        this.counterOut = new byte[this.blockSize];
        this.byteCount = 0;
    }

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (params instanceof ParametersWithIV) {
            ParametersWithIV ivParam = (ParametersWithIV)params;
            byte[] iv = ivParam.getIV();
            System.arraycopy(iv, 0, this.IV, 0, this.IV.length);
            if (ivParam.getParameters() != null) {
                this.cipher.init(true, ivParam.getParameters());
            }
        } else {
            throw new IllegalArgumentException("SIC mode requires ParametersWithIV");
        }
        this.reset();
    }

    public String getAlgorithmName() {
        return String.valueOf(this.cipher.getAlgorithmName()) + "/SIC";
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.processBytes(in, inOff, this.blockSize, out, outOff);
        return this.blockSize;
    }

    protected byte calculateByte(byte in) throws DataLengthException, IllegalStateException {
        if (this.byteCount == 0) {
            this.cipher.processBlock(this.counter, 0, this.counterOut, 0);
            return (byte)(this.counterOut[this.byteCount++] ^ in);
        }
        byte rv = (byte)(this.counterOut[this.byteCount++] ^ in);
        if (this.byteCount == this.counter.length) {
            this.byteCount = 0;
            this.incrementCounter();
        }
        return rv;
    }

    private void incrementCounterPow2(int pow2Div8) {
        int i = this.counter.length - (1 + pow2Div8);
        while (i >= 0) {
            int n = i--;
            this.counter[n] = (byte)(this.counter[n] + 1);
            if (this.counter[n] == 0) continue;
        }
    }

    private void incrementCounter(int offSet) {
        byte old = this.counter[this.counter.length - 1];
        int n = this.counter.length - 1;
        this.counter[n] = (byte)(this.counter[n] + offSet);
        if (old != 0 && this.counter[this.counter.length - 1] < old) {
            this.incrementCounterPow2(1);
        }
    }

    private void incrementCounter() {
        int i = this.counter.length - 1;
        while (i >= 0) {
            int n = i--;
            this.counter[n] = (byte)(this.counter[n] + 1);
            if (this.counter[n] == 0) continue;
        }
    }

    private void decrementCounterPow2(int pow2Div8) {
        if (this.counter[pow2Div8] == 0) {
            boolean nonZero = false;
            int i = this.counter.length - (1 + pow2Div8);
            while (i > 0) {
                if (this.counter[i] != 0) {
                    nonZero = true;
                }
                --i;
            }
            if (!nonZero) {
                throw new IllegalStateException("attempt to reduce counter past zero.");
            }
        }
        int i = this.counter.length - (1 + pow2Div8);
        while (i >= 0) {
            int n = i--;
            this.counter[n] = (byte)(this.counter[n] - 1);
            if (this.counter[n] == -1) continue;
        }
    }

    private void decrementCounter() {
        if (this.counter[0] == 0) {
            boolean nonZero = false;
            int i = this.counter.length - 1;
            while (i > 0) {
                if (this.counter[i] != 0) {
                    nonZero = true;
                }
                --i;
            }
            if (!nonZero) {
                throw new IllegalStateException("attempt to reduce counter past zero.");
            }
        }
        int i = this.counter.length - 1;
        while (i >= 0) {
            int n = i--;
            this.counter[n] = (byte)(this.counter[n] - 1);
            if (this.counter[n] == -1) continue;
        }
    }

    private void adjustCounter(long n) {
        if (n >= 0L) {
            long numBlocks = (n + (long)this.byteCount) / (long)this.blockSize;
            if (numBlocks > 255L) {
                long gap = numBlocks;
                int i = 5;
                while (i >= 1) {
                    long diff = 1L << 8 * i;
                    while (gap >= diff) {
                        this.incrementCounterPow2(i);
                        gap -= diff;
                    }
                    --i;
                }
                this.incrementCounter((int)gap);
            } else {
                this.incrementCounter((int)numBlocks);
            }
            this.byteCount = (int)(n + (long)this.byteCount - (long)this.blockSize * numBlocks);
        } else {
            long numBlocks = (-n - (long)this.byteCount) / (long)this.blockSize;
            if (numBlocks > 255L) {
                long gap = numBlocks;
                int i = 5;
                while (i >= 1) {
                    long diff = 1L << 8 * i;
                    while (gap > diff) {
                        this.decrementCounterPow2(i);
                        gap -= diff;
                    }
                    --i;
                }
                long i2 = 0L;
                while (i2 != gap) {
                    this.decrementCounter();
                    ++i2;
                }
            } else {
                long i = 0L;
                while (i != numBlocks) {
                    this.decrementCounter();
                    ++i;
                }
            }
            int gap = (int)((long)this.byteCount + n + (long)this.blockSize * numBlocks);
            if (gap >= 0) {
                this.byteCount = 0;
            } else {
                this.decrementCounter();
                this.byteCount = this.blockSize + gap;
            }
        }
    }

    public void reset() {
        System.arraycopy(this.IV, 0, this.counter, 0, this.counter.length);
        this.cipher.reset();
        this.byteCount = 0;
    }

    public long skip(long numberOfBytes) {
        this.adjustCounter(numberOfBytes);
        this.cipher.processBlock(this.counter, 0, this.counterOut, 0);
        return numberOfBytes;
    }

    public long seekTo(long position) {
        this.reset();
        return this.skip(position);
    }

    public long getPosition() {
        byte[] res = new byte[this.IV.length];
        System.arraycopy(this.counter, 0, res, 0, res.length);
        int i = res.length - 1;
        while (i >= 1) {
            int v = (res[i] & 0xFF) - (this.IV[i] & 0xFF);
            if (v < 0) {
                int n = i - 1;
                res[n] = (byte)(res[n] - 1);
                v += 256;
            }
            res[i] = (byte)v;
            --i;
        }
        return Pack.bigEndianToLong(res, res.length - 8) * (long)this.blockSize + (long)this.byteCount;
    }
}

