/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import org.bouncycastle.crypto.CipherKeyGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;

public class Poly1305KeyGenerator
extends CipherKeyGenerator {
    private static final byte R_MASK_LOW_2 = -4;
    private static final byte R_MASK_HIGH_4 = 15;

    public void init(KeyGenerationParameters param) {
        super.init(new KeyGenerationParameters(param.getRandom(), 256));
    }

    public byte[] generateKey() {
        byte[] key = super.generateKey();
        Poly1305KeyGenerator.clamp(key);
        return key;
    }

    public static void clamp(byte[] key) {
        if (key.length != 32) {
            throw new IllegalArgumentException("Poly1305 key must be 256 bits.");
        }
        key[19] = (byte)(key[19] & 0xF);
        key[23] = (byte)(key[23] & 0xF);
        key[27] = (byte)(key[27] & 0xF);
        key[31] = (byte)(key[31] & 0xF);
        key[20] = (byte)(key[20] & 0xFFFFFFFC);
        key[24] = (byte)(key[24] & 0xFFFFFFFC);
        key[28] = (byte)(key[28] & 0xFFFFFFFC);
    }

    public static void checkKey(byte[] key) {
        if (key.length != 32) {
            throw new IllegalArgumentException("Poly1305 key must be 256 bits.");
        }
        Poly1305KeyGenerator.checkMask(key[19], (byte)15);
        Poly1305KeyGenerator.checkMask(key[23], (byte)15);
        Poly1305KeyGenerator.checkMask(key[27], (byte)15);
        Poly1305KeyGenerator.checkMask(key[31], (byte)15);
        Poly1305KeyGenerator.checkMask(key[20], (byte)-4);
        Poly1305KeyGenerator.checkMask(key[24], (byte)-4);
        Poly1305KeyGenerator.checkMask(key[28], (byte)-4);
    }

    private static void checkMask(byte b, byte mask) {
        if ((b & ~mask) != 0) {
            throw new IllegalArgumentException("Invalid format for r portion of Poly1305 key.");
        }
    }
}

