/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.renderer;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindowElement;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.renderers.swt.CSSEngineHelper;
import org.eclipse.e4.ui.workbench.renderers.swt.TrimmedPartLayout;
import org.eclipse.e4.ui.workbench.renderers.swt.WBWRenderer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.xmind.cathy.internal.renderer.XTrimmedPartLayout;

public class XWBWRenderer
extends WBWRenderer {
    @Inject
    private Display display;
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    private boolean showingContents = false;

    public Object createWidget(MUIElement element, Object parent) {
        Object widget = super.createWidget(element, parent);
        if (widget != null && widget instanceof Shell) {
            this.recreateLayout(element, (Shell)widget);
        }
        if (widget instanceof Shell && !((Shell)widget).isDisposed()) {
            Shell shell = (Shell)widget;
            Object theManager = shell.getData("DnDManager");
            if (theManager == null) {
                theManager = this.createDnDManager((MWindow)element);
            }
            if (theManager != null) {
                this.trimDndManager(theManager);
                shell.setData("DnDManager", theManager);
            }
        }
        return widget;
    }

    private Object createDnDManager(MWindow window) {
        try {
            Class<?> managerClass = Class.forName("org.eclipse.e4.ui.workbench.addons.dndaddon.DnDManager");
            Constructor<?> constructor = managerClass.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            Object dndManager = constructor.newInstance(window);
            return dndManager;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void trimDndManager(Object theManager) {
        try {
            Class<?> managerClass = theManager.getClass();
            Field dropField = managerClass.getDeclaredField("dropAgents");
            dropField.setAccessible(true);
            List dropAgents = (List)dropField.get(theManager);
            if (dropAgents.size() == 4) {
                dropAgents.remove(1);
                dropAgents.remove(1);
                dropAgents.remove(1);
            }
            dropField.set(theManager, dropAgents);
            Field dragField = managerClass.getDeclaredField("dragAgents");
            dragField.setAccessible(true);
            List dragAgents = (List)dragField.get(theManager);
            if (dragAgents.size() == 2) {
                dragAgents.remove(1);
            }
            dragField.set(theManager, dragAgents);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void recreateLayout(MUIElement element, Shell shell) {
        Layout oldLayout = shell.getLayout();
        if (oldLayout != null && oldLayout instanceof TrimmedPartLayout) {
            TrimmedPartLayout trimmedLayout = (TrimmedPartLayout)oldLayout;
            if (trimmedLayout.clientArea != null) {
                trimmedLayout.clientArea.dispose();
            }
            if (trimmedLayout.top != null) {
                trimmedLayout.top.dispose();
            }
            if (trimmedLayout.bottom != null) {
                trimmedLayout.bottom.dispose();
            }
            if (trimmedLayout.left != null) {
                trimmedLayout.left.dispose();
            }
            if (trimmedLayout.right != null) {
                trimmedLayout.right.dispose();
            }
        }
        XTrimmedPartLayout layout = new XTrimmedPartLayout((Composite)shell);
        IEclipseContext localContext = this.getContext(element);
        CSSEngineHelper helper = new CSSEngineHelper(localContext, (Control)shell);
        layout.gutterTop = helper.getMarginTop(0);
        layout.gutterBottom = helper.getMarginBottom(0);
        layout.gutterLeft = helper.getMarginLeft(0);
        layout.gutterRight = helper.getMarginRight(0);
        shell.setLayout((Layout)layout);
    }

    public Object getUIContainer(MUIElement element) {
        Layout layout;
        Object parentWidget;
        MElementContainer parent;
        if (element instanceof MPart && (parent = element.getParent()) != null && (parentWidget = parent.getWidget()) instanceof Composite && (layout = ((Composite)parentWidget).getLayout()) instanceof XTrimmedPartLayout) {
            return ((XTrimmedPartLayout)layout).getContainer((Composite)parentWidget, element);
        }
        return super.getUIContainer(element);
    }

    public void postProcess(MUIElement shellME) {
        super.postProcess(shellME);
        MWindow window = (MWindow)shellME;
        MWindowElement selectedElement = (MWindowElement)window.getSelectedElement();
        if (selectedElement != null) {
            this.showChild(window, selectedElement);
        } else if (!window.getChildren().isEmpty()) {
            for (MWindowElement child : window.getChildren()) {
                if (!child.isToBeRendered() || !child.isVisible()) continue;
                window.setSelectedElement((MUIElement)child);
                break;
            }
        }
    }

    private void showChild(MWindow window, MWindowElement selectedChild) {
        Shell shell = (Shell)window.getWidget();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        if (window.getChildren().isEmpty()) {
            return;
        }
        for (MWindowElement child : window.getChildren()) {
            Object container = this.getUIContainer((MUIElement)child);
            if (!(container instanceof Control)) continue;
            ((Control)container).setVisible(this.showingContents && child == selectedChild);
        }
        Layout layout = shell.getLayout();
        if (layout instanceof TrimmedPartLayout) {
            boolean primaryClientAreaVisible;
            TrimmedPartLayout tpl = (TrimmedPartLayout)layout;
            boolean bl = primaryClientAreaVisible = tpl.clientArea != null && tpl.clientArea.isVisible();
            if (tpl.top != null) {
                tpl.top.setVisible(primaryClientAreaVisible);
            }
            if (tpl.bottom != null) {
                tpl.bottom.setVisible(primaryClientAreaVisible);
            }
            if (tpl.left != null) {
                tpl.left.setVisible(primaryClientAreaVisible);
            }
            if (tpl.right != null) {
                tpl.right.setVisible(primaryClientAreaVisible);
            }
        }
        shell.layout(true);
    }

    @Inject
    @Optional
    public void subscribeTopicPartActivate(@EventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*") Event event) {
        Object element = event.getProperty("ChangedElement");
        if (element == null || !(element instanceof MWindow)) {
            return;
        }
        MWindow window = (MWindow)element;
        if (window.getRenderer() != this) {
            return;
        }
        this.showChild(window, (MWindowElement)window.getSelectedElement());
    }

    @Inject
    @Optional
    public void subscribeTopicChildrenRemoved(@EventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/children/*") Event event) {
        if (!UIEvents.isREMOVE((Event)event)) {
            return;
        }
        Object element = event.getProperty("ChangedElement");
        if (element == null || !(element instanceof MWindow)) {
            return;
        }
        MWindow window = (MWindow)element;
        if (window.getRenderer() != this || !(window.getWidget() instanceof Shell) || !(((Shell)window.getWidget()).getLayout() instanceof XTrimmedPartLayout)) {
            return;
        }
        XTrimmedPartLayout layout = (XTrimmedPartLayout)((Shell)window.getWidget()).getLayout();
        for (Object removed : UIEvents.asIterable((Event)event, (String)"OldValue")) {
            layout.removeContainer(removed);
        }
    }

    @Inject
    @Optional
    public void applicationStarted(@EventTopic(value="org/eclipse/e4/ui/LifeCycle/appStartupComplete") Event event) {
        this.showingContents = true;
        if (this.display == null) {
            return;
        }
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                List windows = XWBWRenderer.this.modelService.findElements((MUIElement)XWBWRenderer.this.application, null, MWindow.class, null);
                for (MWindow window : windows) {
                    if (window.getRenderer() != XWBWRenderer.this) continue;
                    XWBWRenderer.this.showChild(window, (MWindowElement)window.getSelectedElement());
                }
            }
        });
    }
}

