/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.jobs;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.core.Core;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IStorage;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.imports.freemind.FreeMindImporter;
import org.xmind.ui.internal.imports.mm.MindManagerImporter;
import org.xmind.ui.io.DownloadJob;
import org.xmind.ui.mindmap.MindMapUI;

public class DownloadAndOpenFileJob
extends Job {
    private IWorkbench workbench;
    private String url;
    private String targetName;
    private File tempFile;

    public DownloadAndOpenFileJob(IWorkbench workbench, String url, String targetName) {
        super(WorkbenchMessages.DownloadAndOpenFileJob_jobName);
        Assert.isNotNull((Object)workbench);
        Assert.isNotNull((Object)url);
        this.workbench = workbench;
        this.url = url;
        this.targetName = targetName;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.beginTask(null, 2);
        IStatus downloaded = this.download(monitor);
        if (!downloaded.isOK()) {
            return downloaded;
        }
        monitor.worked(1);
        IStatus opened = this.open(monitor);
        if (!opened.isOK()) {
            return opened;
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    private IStatus download(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.subTask(NLS.bind((String)WorkbenchMessages.DownloadAndOpenFileJob_Task_Download_with_url, (Object)this.url));
        this.tempFile = DownloadAndOpenFileJob.createTempPath(this.url);
        if (this.tempFile.getParentFile() == null || !this.tempFile.getParentFile().isDirectory()) {
            return new Status(4, "org.xmind.ui", WorkbenchMessages.DownloadAndOpenFileJob_Error_FailedToCreateTempFile);
        }
        DownloadJob downloadJob = new DownloadJob(WorkbenchMessages.DownloadAndOpenFileJob_DownloadJob_jobName, this.url, this.tempFile.getAbsolutePath(), "org.xmind.ui");
        downloadJob.setUser(true);
        downloadJob.schedule();
        try {
            downloadJob.join();
        }
        catch (InterruptedException interruptedException) {}
        if (monitor.isCanceled()) {
            downloadJob.cancel();
            return Status.CANCEL_STATUS;
        }
        IStatus downloaded = downloadJob.getResult();
        if (downloaded == null) {
            return new Status(4, "org.xmind.ui", "No result retrieved from download job.");
        }
        return downloaded;
    }

    private IStatus open(IProgressMonitor monitor) {
        monitor.subTask(NLS.bind((String)WorkbenchMessages.DownloadAndOpenFileJob_Task_OpenDownloadedFile_with_url, (Object)this.url));
        try {
            IStorage tempStorage = DownloadAndOpenFileJob.createTempStorage();
            IWorkbook workbook = this.loadWorkbook(monitor, tempStorage);
            if (workbook != null) {
                return this.openMindMapEditor(monitor, workbook);
            }
        }
        catch (Throwable e) {
            return new Status(4, "org.xmind.ui", NLS.bind((String)WorkbenchMessages.DownloadAndOpenFileJob_Error_FailedToLoadWorkbook_with_url, (Object)this.url), e);
        }
        return Status.CANCEL_STATUS;
    }

    private IWorkbook loadWorkbook(IProgressMonitor monitor, IStorage tempStorage) throws Exception {
        String ext = FileUtils.getExtension((String)this.tempFile.getAbsolutePath());
        if (".xmind".equalsIgnoreCase(ext)) {
            return this.loadWorkbookFromXMindFile(monitor, tempStorage);
        }
        if (".xmt".equalsIgnoreCase(ext)) {
            return this.loadWorkbookFromTemplate(monitor, tempStorage);
        }
        if (".mmap".equalsIgnoreCase(ext)) {
            return this.loadWorkbookFromMindManagerFile(monitor, tempStorage);
        }
        if (".mm".equalsIgnoreCase(ext)) {
            return this.loadWorkbookFromFreeMindFile(monitor, tempStorage);
        }
        return null;
    }

    private IWorkbook loadWorkbookFromXMindFile(IProgressMonitor monitor, IStorage tempStorage) throws Exception {
        return Core.getWorkbookBuilder().loadFromFile(this.tempFile, tempStorage, null);
    }

    private IWorkbook loadWorkbookFromTemplate(IProgressMonitor monitor, IStorage tempStorage) throws Exception {
        return Core.getWorkbookBuilder().loadFromFile(this.tempFile, tempStorage, null);
    }

    private IWorkbook loadWorkbookFromMindManagerFile(IProgressMonitor monitor, IStorage tempStorage) throws Exception {
        MindManagerImporter importer = new MindManagerImporter(this.tempFile.getAbsolutePath());
        importer.build();
        return importer.getTargetWorkbook();
    }

    private IWorkbook loadWorkbookFromFreeMindFile(IProgressMonitor monitor, IStorage tempStorage) throws Exception {
        FreeMindImporter importer = new FreeMindImporter(this.tempFile.getAbsolutePath());
        importer.build();
        return importer.getTargetWorkbook();
    }

    private IStatus openMindMapEditor(IProgressMonitor monitor, final IWorkbook workbook) {
        final IStatus[] result = new IStatus[]{null};
        Display display = this.workbench.getDisplay();
        if (display == null || display.isDisposed()) {
            monitor.setCanceled(true);
            return Status.CANCEL_STATUS;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = DownloadAndOpenFileJob.this.workbench.getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                IWorkbenchPage page = window.getActivePage();
                if (page == null) {
                    return;
                }
                String name = DownloadAndOpenFileJob.this.targetName == null ? DownloadAndOpenFileJob.getFileName(DownloadAndOpenFileJob.this.url) : DownloadAndOpenFileJob.this.targetName;
                IEditorInput input = MindMapUI.getEditorInputFactory().createEditorInputForPreLoadedWorkbook(workbook, name);
                try {
                    page.openEditor(input, "org.xmind.ui.MindMapEditor", true);
                }
                catch (PartInitException e) {
                    result[0] = e.getStatus();
                    return;
                }
                if (workbook instanceof ICoreEventSource2) {
                    ((ICoreEventSource2)workbook).registerOnceCoreEventListener("workbookPreSaveOnce", ICoreEventListener.NULL);
                }
                result[0] = Status.OK_STATUS;
            }
        });
        if (result[0] == null) {
            return Status.CANCEL_STATUS;
        }
        return result[0];
    }

    protected void canceling() {
        super.canceling();
        Thread thread = this.getThread();
        if (thread != null) {
            thread.interrupt();
        }
    }

    private static File createTempPath(String url) {
        String fileName = DownloadAndOpenFileJob.getFileName(url);
        String ext = FileUtils.getExtension((String)fileName);
        String prefix = fileName.substring(0, fileName.length() - ext.length());
        return Core.getWorkspace().createTempFile("download", String.valueOf(prefix) + "_", ext);
    }

    private static IStorage createTempStorage() {
        File tempDir = Core.getWorkspace().createTempFile("openFromDownloadedFile", "", ".temp");
        tempDir.mkdirs();
        return new DirectoryStorage(tempDir);
    }

    private static String getFileName(String url) {
        String path;
        try {
            path = new URI(url).getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            int j = url.lastIndexOf(63);
            path = j < 0 ? url : url.substring(0, j);
        }
        int i = path.lastIndexOf(47);
        if (i < 0) {
            return path;
        }
        return path.substring(i + 1);
    }
}

