/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xmind.core.Core;
import org.xmind.core.IFileEntry;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.internal.dom.WorkbookMarkerResource;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerResource;
import org.xmind.core.marker.IMarkerResourceAllocator;
import org.xmind.core.marker.IMarkerResourceProvider;
import org.xmind.core.util.FileUtils;

public class WorkbookMarkerResourceProvider
implements IMarkerResourceProvider,
IMarkerResourceAllocator {
    private WorkbookImpl workbook;

    public WorkbookMarkerResourceProvider(WorkbookImpl workbook) {
        this.workbook = workbook;
    }

    public IMarkerResource getMarkerResource(IMarker marker) {
        if ("".equals(marker.getResourcePath())) {
            return null;
        }
        return new WorkbookMarkerResource(this.workbook, marker);
    }

    public boolean isPermanent() {
        return false;
    }

    public String allocateMarkerResource(InputStream source, String suggestedPath) throws IOException {
        String ext = suggestedPath == null ? ".png" : FileUtils.getExtension(suggestedPath);
        String path = String.valueOf(Core.getIdFactory().createId()) + ext;
        IFileEntry entry = this.workbook.getManifest().createFileEntry("markers/" + path);
        OutputStream target = entry.openOutputStream();
        try {
            FileUtils.transfer(source, target, false);
        }
        finally {
            target.close();
        }
        return path;
    }
}

