/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.beans.PropertyChangeSupport;
import java.util.Calendar;
import org.xmind.ui.internal.taskinfo.DateInfo;

public class TimelineModel {
    public static final double MONTHS_VIEW = 64800.0;
    public static final double WEEKS_VIEW = 15120.0;
    public static final double DAYS_VIEW = 3456.0;
    public static final double DAYS_OF_WEEK_VIEW = 3323.0;
    public static final double HOURS_VIEW = 144.0;
    public static final double MINUTES_VIEW = 5.0;
    public static final double SECONDS_VIEW = 0.08333333333333333;
    public static final double DEFAULT_VIEW = 3456.0;
    public static final double MAX_VIEW = 64800.0;
    public static final double MIN_VIEW = 0.08333333333333333;
    public static final String PROP_PRECISION = "precision";
    public static final String PROP_PREVIEW_PRECISION = "preview-precision";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private double precision = 3456.0;
    private Calendar originDate = null;
    private boolean isExportMode = false;
    private int exportStart;
    private int exportEnd;

    public boolean isExportMode() {
        return this.isExportMode;
    }

    public void setExportMode(boolean isExportMode) {
        this.isExportMode = isExportMode;
    }

    public int getExportStart() {
        return this.exportStart;
    }

    public void setExportStart(int exportStart) {
        this.exportStart = exportStart;
    }

    public int getExportEnd() {
        return this.exportEnd;
    }

    public void setExportEnd(int exportEnd) {
        this.exportEnd = exportEnd;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public double getPrecision() {
        return this.precision;
    }

    public void setPrecision(double precision) {
        double oldPrecision = this.getPrecision();
        if (precision == oldPrecision) {
            return;
        }
        this.precision = precision;
        this.propertyChangeSupport.firePropertyChange(PROP_PRECISION, oldPrecision, this.getPrecision());
    }

    public Calendar getOriginDate() {
        if (this.originDate == null) {
            Calendar date = DateInfo.today();
            date.set(date.get(1), date.get(2), 1, 0, 0, 0);
            this.originDate = date;
        }
        return this.originDate;
    }

    public void zoomIn() {
        double s = this.getPrecision();
        s = s > 15120.0 ? 64800.0 : (s > 3456.0 ? 15120.0 : (s > 144.0 ? 3456.0 : (s > 5.0 ? 144.0 : 5.0)));
        this.setPrecision(s);
    }

    public void zoomOut() {
        double s = this.getPrecision();
        s = s < 5.0 ? 0.08333333333333333 : (s < 144.0 ? 5.0 : (s < 3456.0 ? 144.0 : (s < 15120.0 ? 3456.0 : 15120.0)));
        this.setPrecision(s);
    }

    public int getPixelsFromMillis(long millis) {
        return TimelineModel.calculatePixelsFromMillis(millis, this.getPrecision());
    }

    public long getMillisFromPixels(int pixels) {
        return TimelineModel.calculateMillisFromPixels(pixels, this.getPrecision());
    }

    public static int calculatePixelsFromMillis(long millis, double precision) {
        return (int)Math.round((double)millis / precision / 1000.0);
    }

    public static long calculateMillisFromPixels(int pixels, double precision) {
        return Math.round((double)(1000 * pixels) * precision);
    }
}

