/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt.export;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.GEF;
import org.xmind.gef.GraphicalViewer;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gantt.export.ExportConstants;
import org.xmind.ui.gantt2.viewer.Colors;
import org.xmind.ui.gantt2.viewer.GanttViewer;
import org.xmind.ui.gantt2.viewer.TaskBarViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeHeaderViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeWidthsSupport;
import org.xmind.ui.gantt2.viewer.TimelineModel;
import org.xmind.ui.gantt2.viewer.TimelineViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GanttFigureRenderer2 {
    private static int MISSING_WIDTH = 0;
    private GanttViewer ganttViewer;

    public GanttFigureRenderer2(GanttViewer ganttViewer) {
        this.ganttViewer = ganttViewer;
    }

    public void render(Graphics graphics, long startTime, long endTime, Point origin, Rectangle contentClip) {
        TaskTreeHeaderViewer headerViewer = this.ganttViewer.getTaskTreeHeaderViewer();
        RangeModel rangeModel = headerViewer.getViewport().getHorizontalRangeModel();
        int value = rangeModel.getValue() + rangeModel.getExtent();
        int width0 = ExportConstants.round(value, this.ganttViewer.getWidthsSupport());
        TimelineModel timelineModel = this.ganttViewer.getEditDomain().getTimelineModel();
        int start = timelineModel.getPixelsFromMillis(startTime - timelineModel.getOriginDate().getTimeInMillis()) - 50;
        int width1 = startTime != endTime ? timelineModel.getPixelsFromMillis(endTime - startTime) + 100 : 0;
        int end = start + width1;
        this.render(graphics, origin, 0, width0, start, end, contentClip);
    }

    private void render(Graphics graphics, Point origin, int leftStart, int leftEnd, int rightStart, int rightEnd, Rectangle contentClip) {
        TaskTreeHeaderViewer headerViewer = this.ganttViewer.getTaskTreeHeaderViewer();
        int width0 = leftEnd - leftStart;
        int height0 = headerViewer.getCanvas().getSize().y;
        this.renderTaskTreeHeaderViewer(graphics, new Point(origin.x, 0), leftStart, leftEnd);
        this.renderTimelineViewer(graphics, new Point(origin.x + width0 + 1, 0), rightStart, rightEnd);
        this.renderTaskTreeViewer(graphics, new Point(origin.x, origin.y + height0), leftStart, leftEnd, contentClip);
        this.renderTaskBarViewer(graphics, new Point(origin.x + width0 + 1, origin.y + height0), rightStart, rightEnd, contentClip);
    }

    private void renderTaskTreeHeaderViewer(Graphics graphics, Point origin, int start, int end) {
        try {
            graphics.pushState();
            graphics.translate(origin.x, origin.y);
            TaskTreeHeaderViewer headerViewer = this.ganttViewer.getTaskTreeHeaderViewer();
            int height = headerViewer.getCanvas().getSize().y;
            graphics.clipRect(new Rectangle(0, 0, end - start + 1, height));
            graphics.setBackgroundColor(headerViewer.getCanvas().getBackground());
            graphics.fillRectangle(new Rectangle(0, 0, end - start + 1, height));
            graphics.translate(-start, 0);
            headerViewer.getViewport().paint(graphics);
            graphics.setLineWidth(1);
            graphics.setForegroundColor(Colors.split());
            TaskTreeWidthsSupport widthSupport = this.ganttViewer.getWidthsSupport();
            int i = 0;
            while (i < widthSupport.getSize()) {
                int x = widthSupport.sum(i);
                graphics.drawLine(x, 0, x, height);
                ++i;
            }
            graphics.setForegroundColor(Colors.header());
            graphics.drawLine(end - 2, 0, end - 2, height);
            graphics.setForegroundColor(Colors.splitBar());
            graphics.drawLine(end - 1, 0, end - 1, height);
        }
        finally {
            graphics.popState();
        }
    }

    private void renderTimelineViewer(Graphics graphics, Point origin, int start, int end) {
        TimelineModel timelineModel = this.ganttViewer.getEditDomain().getTimelineModel();
        timelineModel.setExportMode(true);
        timelineModel.setExportStart(start);
        timelineModel.setExportEnd(end);
        TimelineViewer timelineViewer = this.ganttViewer.getTimelineViewer();
        TaskBarViewer taskBarViewer = this.ganttViewer.getTaskBarViewer();
        RangeModel rangeModel = taskBarViewer.getCanvas().getViewport().getHorizontalRangeModel();
        int value = rangeModel.getValue();
        try {
            int start0 = start;
            rangeModel.setValue(start);
            timelineViewer.getCanvas().getViewport().getUpdateManager().performUpdate();
            if (rangeModel.getValue() != start) {
                this.doRenderTimelineViewer(graphics, origin, start, end, rangeModel.getValue() - start0);
            } else {
                while (start0 + rangeModel.getExtent() - MISSING_WIDTH < end) {
                    this.doRenderTimelineViewer(graphics, new Point(origin.x + start0 - start, origin.y), start0, start0 + rangeModel.getExtent(), 0);
                    rangeModel.setValue(start0 += rangeModel.getExtent() - MISSING_WIDTH);
                    timelineViewer.getCanvas().getViewport().getUpdateManager().performUpdate();
                }
                if (rangeModel.getValue() == start0) {
                    this.doRenderTimelineViewer(graphics, new Point(origin.x + start0 - start, origin.y), start0, end, 0);
                } else {
                    this.doRenderTimelineViewer(graphics, new Point(origin.x + start0 - start, origin.y), rangeModel.getValue() - start, end, rangeModel.getValue() - start0);
                }
            }
        }
        finally {
            timelineModel.setExportMode(false);
            rangeModel.setValue(value);
        }
    }

    private void doRenderTimelineViewer(Graphics graphics, Point origin, int start, int end, int translateX) {
        TimelineViewer timelineViewer = this.ganttViewer.getTimelineViewer();
        try {
            boolean useAdvancedRenderer = this.getProperties().getBoolean("renderTextAsPath", false);
            timelineViewer.getProperties().set("renderTextAsPath", useAdvancedRenderer);
            graphics.pushState();
            graphics.translate(origin.x, origin.y);
            int height = timelineViewer.getCanvas().getSize().y;
            graphics.clipRect(new Rectangle(0, 0, end - start, height));
            graphics.setBackgroundColor(Colors.timeline());
            graphics.fillRectangle(new Rectangle(0, 0, end - start, height));
            graphics.translate(translateX, 0);
            List<IFigure> contents = this.getUsefulLayers(timelineViewer);
            for (IFigure content : contents) {
                content.paint(graphics);
            }
        }
        finally {
            graphics.popState();
            timelineViewer.getProperties().set("renderTextAsPath", false);
        }
    }

    private void renderTaskTreeViewer(Graphics graphics, Point origin, int start, int end, Rectangle contentClip) {
        try {
            graphics.pushState();
            if (contentClip != null) {
                graphics.clipRect(contentClip);
            }
            graphics.translate(origin.x, origin.y);
            TaskTreeViewer taskTreeViewer = this.ganttViewer.getTaskTreeViewer();
            int height = ((FreeformLayer)taskTreeViewer.getLayer((Object)GEF.LAYER_CONTENTS)).getFreeformExtent().height;
            graphics.clipRect(new Rectangle(0, 0, end - start, height));
            graphics.translate(-start, 0);
            List<IFigure> contents = this.getUsefulLayers(taskTreeViewer);
            for (IFigure content : contents) {
                content.paint(graphics);
            }
            graphics.setForegroundColor(Colors.split());
            TaskTreeWidthsSupport widthSupport = this.ganttViewer.getWidthsSupport();
            int i = 0;
            while (i < widthSupport.getSize()) {
                int x = widthSupport.sum(i);
                graphics.drawLine(x, 0, x, height);
                ++i;
            }
            graphics.setForegroundColor(Colors.header());
            graphics.drawLine(end - 2, 0, end - 2, height);
            graphics.setForegroundColor(Colors.splitBar());
            graphics.drawLine(end - 1, 0, end - 1, height);
        }
        finally {
            graphics.popState();
        }
    }

    private void renderTaskBarViewer(Graphics graphics, Point origin, int start, int end, Rectangle contentClip) {
        try {
            graphics.pushState();
            if (contentClip != null) {
                graphics.clipRect(new Rectangle(contentClip.x, contentClip.y + 1, contentClip.width, contentClip.height - 1));
            }
            graphics.translate(origin.x, origin.y);
            TaskBarViewer taskBarViewer = this.ganttViewer.getTaskBarViewer();
            TaskTreeViewer taskTreeViewer = this.ganttViewer.getTaskTreeViewer();
            int height = ((FreeformLayer)taskTreeViewer.getLayer((Object)GEF.LAYER_CONTENTS)).getFreeformExtent().height;
            graphics.clipRect(new Rectangle(0, 0, end - start, height));
            graphics.translate(-start, 0);
            List<IFigure> contents = this.getUsefulLayers(taskBarViewer);
            for (IFigure content : contents) {
                content.paint(graphics);
            }
        }
        finally {
            graphics.popState();
        }
    }

    private List<IFigure> getUsefulLayers(GraphicalViewer viewer) {
        ArrayList<IFigure> figures = new ArrayList<IFigure>();
        if (viewer instanceof TimelineViewer) {
            figures.add((IFigure)viewer.getLayer(GEF.LAYER_CONTENTS));
        } else if (viewer instanceof TaskTreeViewer) {
            figures.add((IFigure)viewer.getLayer(TaskTreeViewer.LAYER_BACKGROUND_LINE));
            figures.add((IFigure)viewer.getLayer(GEF.LAYER_CONTENTS));
        } else if (viewer instanceof TaskBarViewer) {
            figures.add((IFigure)viewer.getLayer(TaskBarViewer.LAYER_BACKGROUND_SHADOW));
            figures.add((IFigure)viewer.getLayer(GEF.LAYER_CONTENTS));
            figures.add((IFigure)viewer.getLayer(TaskBarViewer.LAYER_DEPENDENCIES));
            figures.add((IFigure)viewer.getLayer(TaskBarViewer.LAYER_TIMELINE));
        }
        return figures;
    }

    protected GanttViewer getGanttViewer() {
        return this.ganttViewer;
    }

    private Properties getProperties() {
        if (this.ganttViewer != null) {
            return this.ganttViewer.getProperties();
        }
        return null;
    }
}

