/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.streams.Predicates;
import net.sf.saxon.s9api.streams.Steps;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageBean;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaClass;
import org.dita.dost.util.DitaUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.KeyDef;
import org.dita.dost.util.KeyScope;
import org.dita.dost.util.MergeUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class KeyrefPaser
extends AbstractXMLFilter {
    private static final Set<String> no_copy = Set.of("id", "class", "xtrc", "xtrf", "href", "keys", "toc", "processing-role");
    private static final Set<String> no_copy_topic;
    private static final List<KeyrefInfo> keyrefInfos;
    private static final List<String> KEYREF_ATTRIBUTES;
    private final Deque<KeyScope> definitionMaps = new ArrayDeque<KeyScope>();
    private final Deque<Integer> keyrefLevalStack = new ArrayDeque<Integer>();
    private int keyrefLevel = 0;
    private final Deque<Boolean> validKeyref = new ArrayDeque<Boolean>();
    private boolean empty = true;
    private final Deque<String> elemName = new ArrayDeque<String>();
    private KeyrefInfo currentElement;
    private boolean hasChecked;
    private final Deque<Boolean> hasSubElem = new ArrayDeque<Boolean>();
    private KeyDef keyDef;
    private Set<URI> normalProcessingRoleTargets;
    private MergeUtils mergeUtils = new MergeUtils();
    private boolean compatibilityMode = Boolean.parseBoolean(Configuration.configuration.get("compatibility.keyref.treat-blank-as-empty"));

    @Override
    public void setLogger(DITAOTLogger logger) {
        super.setLogger(logger);
        this.mergeUtils.setLogger(logger);
    }

    @Override
    public void setJob(Job job) {
        super.setJob(job);
        this.mergeUtils.setJob(job);
    }

    public void setCompatibilityMode(boolean compatibilityMode) {
        this.compatibilityMode = compatibilityMode;
    }

    public void setKeyDefinition(KeyScope definitionMap) {
        this.definitionMaps.push(definitionMap);
    }

    public Set<URI> getNormalProcessingRoleTargets() {
        if (this.normalProcessingRoleTargets == null) {
            return Set.of();
        }
        return Collections.unmodifiableSet(this.normalProcessingRoleTargets);
    }

    @Override
    public void write(File filename) throws DITAOTException {
        assert (filename.isAbsolute());
        super.write(new File(this.currentFile));
    }

    @Override
    public void startDocument() throws SAXException {
        this.normalProcessingRoleTargets = new HashSet<URI>();
        this.getContentHandler().startDocument();
    }

    private boolean isEmpty(char[] ch, int start, int length) {
        if (length == 0) {
            return true;
        }
        if (this.compatibilityMode) {
            return new String(ch, start, length).isBlank();
        }
        return false;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.keyrefLevel != 0 && this.isEmpty(ch, start, length)) {
            if (!this.hasChecked) {
                this.empty = true;
            }
        } else {
            this.hasChecked = true;
            this.empty = false;
        }
        this.getContentHandler().characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.keyrefLevel != 0 && this.empty && !this.validKeyref.isEmpty() && this.validKeyref.peek().booleanValue()) {
            XdmNode elem = this.keyDef.element;
            if (this.elemName.peek().equals(Constants.MAP_TOPICREF.localName)) {
                Optional topicmetaNode = elem.select(Steps.child().where(Constants.MAP_TOPICMETA::matches).first()).findFirst();
                if (topicmetaNode.isPresent()) {
                    this.domToSax((XdmNode)topicmetaNode.get(), true, false);
                }
            } else if (!name.equals(this.elemName.peek())) {
                for (XdmNode node : elem.select(Steps.descendant().where(Predicates.hasLocalName((String)name))).asList()) {
                    Iterator iterator = node.select(Steps.child().where(Predicates.isText())).toList().iterator();
                    if (!iterator.hasNext()) continue;
                    XdmNode n = (XdmNode)iterator.next();
                    char[] ch = n.getStringValue().toCharArray();
                    this.getContentHandler().characters(ch, 0, ch.length);
                }
            } else if (!this.hasSubElem.peek().booleanValue() && this.currentElement != null) {
                List keywords = elem.select(Steps.descendant().where(Predicates.hasLocalName((String)Constants.TOPIC_KEYWORD.localName))).asList();
                List<XdmNode> keywordsInKeywords = keywords.stream().filter(item -> Constants.TOPIC_KEYWORDS.matches(item.getParent())).toList();
                if (!keywordsInKeywords.isEmpty()) {
                    if (!this.currentElement.hasNestedElements) {
                        if (!this.currentElement.isEmpty) {
                            this.domToSax(keywordsInKeywords.get(0), false);
                        }
                    } else {
                        if (Constants.TOPIC_LINK.matches(this.currentElement.type)) {
                            atts = new AttributesImpl();
                            XMLUtils.addOrSetAttribute((AttributesImpl)atts, "class", Constants.TOPIC_LINKTEXT.toString());
                            this.getContentHandler().startElement("", Constants.TOPIC_LINKTEXT.localName, Constants.TOPIC_LINKTEXT.localName, (Attributes)atts);
                        } else if (Constants.TOPIC_IMAGE.matches(this.currentElement.type)) {
                            atts = new AttributesImpl();
                            XMLUtils.addOrSetAttribute((AttributesImpl)atts, "class", Constants.TOPIC_ALT.toString());
                            this.getContentHandler().startElement("", Constants.TOPIC_ALT.localName, Constants.TOPIC_ALT.localName, (Attributes)atts);
                        }
                        if (!this.currentElement.isEmpty) {
                            for (XdmNode onekeyword : keywordsInKeywords) {
                                this.domToSax(onekeyword, true);
                            }
                        }
                        if (Constants.TOPIC_LINK.matches(this.currentElement.type)) {
                            this.getContentHandler().endElement("", Constants.TOPIC_LINKTEXT.localName, Constants.TOPIC_LINKTEXT.localName);
                        } else if (Constants.TOPIC_IMAGE.matches(this.currentElement.type)) {
                            this.getContentHandler().endElement("", Constants.TOPIC_ALT.localName, Constants.TOPIC_ALT.localName);
                        }
                    }
                } else if (Constants.TOPIC_LINK.matches(this.currentElement.type)) {
                    List linktext = elem.select(Steps.descendant().where(Predicates.hasLocalName((String)Constants.TOPIC_LINKTEXT.localName)).first()).asList();
                    if (!linktext.isEmpty()) {
                        this.domToSax((XdmNode)linktext.get(0), true);
                    } else if (this.fallbackToNavtitleOrHref(elem)) {
                        List navtitleElement = elem.select(Steps.descendant().where(Predicates.hasLocalName((String)Constants.TOPIC_NAVTITLE.localName)).first()).asList();
                        if (!navtitleElement.isEmpty()) {
                            this.writeLinktext((XdmNode)navtitleElement.get(0));
                        } else {
                            String navtitle = elem.attribute("navtitle");
                            if (navtitle != null && !navtitle.trim().isEmpty()) {
                                this.writeLinktext(navtitle);
                            } else {
                                String hrefAtt = elem.attribute("href");
                                if (hrefAtt != null && !hrefAtt.trim().isEmpty()) {
                                    this.writeLinktext(hrefAtt);
                                }
                            }
                        }
                    }
                } else if (Constants.TOPIC_IMAGE.matches(this.currentElement.type)) {
                    List linktext = elem.select(Steps.descendant().where(Predicates.hasLocalName((String)Constants.TOPIC_LINKTEXT.localName)).first()).asList();
                    if (!linktext.isEmpty()) {
                        this.writeAlt((XdmNode)linktext.get(0));
                    } else if (this.fallbackToNavtitleOrHref(elem)) {
                        List navtitleElement = elem.select(Steps.descendant().where(Predicates.hasLocalName((String)Constants.TOPIC_NAVTITLE.localName)).first()).asList();
                        if (!navtitleElement.isEmpty()) {
                            this.writeAlt((XdmNode)navtitleElement.get(0));
                        } else {
                            String navtitle = elem.attribute("navtitle");
                            if (navtitle != null && !navtitle.trim().isEmpty()) {
                                this.writeAlt(navtitle);
                            }
                        }
                    }
                } else if (!this.currentElement.isEmpty && this.fallbackToNavtitleOrHref(elem)) {
                    List linktext = elem.select(Steps.descendant().where(Predicates.hasLocalName((String)Constants.TOPIC_LINKTEXT.localName)).first()).asList();
                    if (!linktext.isEmpty()) {
                        this.domToSax((XdmNode)linktext.get(0), false);
                    } else {
                        List navtitleElement = elem.select(Steps.descendant().where(Predicates.hasLocalName((String)Constants.TOPIC_NAVTITLE.localName)).first()).asList();
                        if (!navtitleElement.isEmpty()) {
                            this.domToSax((XdmNode)navtitleElement.get(0), false);
                        } else {
                            String navtitle = elem.attribute("navtitle");
                            if (navtitle != null && !navtitle.trim().isEmpty()) {
                                char[] ch = navtitle.toCharArray();
                                this.getContentHandler().characters(ch, 0, ch.length);
                            } else {
                                String hrefAtt = elem.attribute("href");
                                if (hrefAtt != null && !hrefAtt.trim().isEmpty()) {
                                    char[] ch = hrefAtt.toCharArray();
                                    this.getContentHandler().characters(ch, 0, ch.length);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (this.keyrefLevel != 0) {
            --this.keyrefLevel;
            this.empty = false;
        }
        if (this.keyrefLevel == 0 && !this.keyrefLevalStack.isEmpty()) {
            this.keyrefLevel = this.keyrefLevalStack.pop();
            this.validKeyref.pop();
            this.elemName.pop();
            this.hasSubElem.pop();
        }
        this.definitionMaps.pop();
        this.getContentHandler().endElement(uri, localName, name);
    }

    private void writeLinktext(XdmNode srcElem) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        XMLUtils.addOrSetAttribute(atts, "class", Constants.TOPIC_LINKTEXT.toString());
        this.getContentHandler().startElement("", Constants.TOPIC_LINKTEXT.localName, Constants.TOPIC_LINKTEXT.localName, atts);
        this.domToSax(srcElem, false);
        this.getContentHandler().endElement("", Constants.TOPIC_LINKTEXT.localName, Constants.TOPIC_LINKTEXT.localName);
    }

    private void writeLinktext(String navtitle) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        XMLUtils.addOrSetAttribute(atts, "class", Constants.TOPIC_LINKTEXT.toString());
        this.getContentHandler().startElement("", Constants.TOPIC_LINKTEXT.localName, Constants.TOPIC_LINKTEXT.localName, atts);
        char[] ch = navtitle.toCharArray();
        this.getContentHandler().characters(ch, 0, ch.length);
        this.getContentHandler().endElement("", Constants.TOPIC_LINKTEXT.localName, Constants.TOPIC_LINKTEXT.localName);
    }

    private void writeAlt(XdmNode srcElem) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        XMLUtils.addOrSetAttribute(atts, "class", Constants.TOPIC_ALT.toString());
        this.getContentHandler().startElement("", Constants.TOPIC_ALT.localName, Constants.TOPIC_ALT.localName, atts);
        this.domToSax(srcElem, false);
        this.getContentHandler().endElement("", Constants.TOPIC_ALT.localName, Constants.TOPIC_ALT.localName);
    }

    private void writeAlt(String navtitle) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        XMLUtils.addOrSetAttribute(atts, "class", Constants.TOPIC_ALT.toString());
        this.getContentHandler().startElement("", Constants.TOPIC_ALT.localName, Constants.TOPIC_ALT.localName, atts);
        char[] ch = navtitle.toCharArray();
        this.getContentHandler().characters(ch, 0, ch.length);
        this.getContentHandler().endElement("", Constants.TOPIC_ALT.localName, Constants.TOPIC_ALT.localName);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        KeyScope childScope = Optional.ofNullable(atts.getValue("keyscope")).flatMap(n -> Optional.ofNullable(this.definitionMaps.peek().getChildScope((String)n))).orElse(this.definitionMaps.peek());
        this.definitionMaps.push(childScope);
        this.currentElement = null;
        String cls = atts.getValue("class");
        for (KeyrefInfo k : keyrefInfos) {
            if (!k.type.matches(cls)) continue;
            this.currentElement = k;
            break;
        }
        Attributes resAtts = atts;
        this.hasChecked = false;
        this.empty = true;
        if (!this.hasKeyref(atts) || this.currentElement == null) {
            if (this.keyrefLevel != 0) {
                ++this.keyrefLevel;
                this.hasSubElem.pop();
                this.hasSubElem.push(true);
            }
        } else {
            this.elemName.push(name);
            if (this.keyrefLevel != 0) {
                this.keyrefLevalStack.push(this.keyrefLevel);
                this.hasSubElem.pop();
                this.hasSubElem.push(true);
            }
            this.hasSubElem.push(false);
            this.keyrefLevel = 1;
            resAtts = this.processElement(atts);
        }
        this.getContentHandler().startElement(uri, localName, name, resAtts);
    }

    private Attributes processElement(Attributes atts) {
        AttributesImpl resAtts = new AttributesImpl(atts);
        boolean valid = false;
        for (Map.Entry<String, String> attrPair : this.currentElement.attrs.entrySet()) {
            XdmNode elem;
            String keyrefAttr = attrPair.getKey();
            String refAttr = attrPair.getValue();
            String keyrefValue = atts.getValue(keyrefAttr);
            if (keyrefValue == null) continue;
            int slashIndex = keyrefValue.indexOf("/");
            String keyName = keyrefValue;
            String elementId = "";
            if (slashIndex != -1) {
                keyName = keyrefValue.substring(0, slashIndex);
                elementId = keyrefValue.substring(slashIndex);
            }
            this.keyDef = this.definitionMaps.peek().get(keyName);
            XdmNode xdmNode = elem = this.keyDef != null ? this.keyDef.element : null;
            if (this.keyDef != null) {
                if (this.currentElement != null) {
                    List attrs = elem.select(Steps.attribute()).asList();
                    URI href = this.keyDef.href;
                    if (href != null && !href.toString().isEmpty()) {
                        if (Constants.TOPIC_IMAGE.matches(this.currentElement.type)) {
                            valid = true;
                            target = this.keyDef.source.resolve(href);
                            relativeTarget = URLUtils.getRelativePath(this.currentFile, target);
                            targetOutput = KeyrefPaser.normalizeHrefValue(relativeTarget, elementId);
                            XMLUtils.addOrSetAttribute(resAtts, refAttr, targetOutput.toString());
                        } else if (this.isLocalDita(elem) && this.keyDef.source != null) {
                            String directHref;
                            valid = true;
                            target = this.keyDef.source.resolve(href);
                            URI topicFile = this.currentFile.resolve(URLUtils.stripFragment(target));
                            URI relativeTarget = URLUtils.setFragment(URLUtils.getRelativePath(this.currentFile, topicFile), target.getFragment());
                            String topicId = null;
                            if (relativeTarget.getFragment() == null && !"".equals(elementId) && (topicId = this.getFirstTopicId(topicFile)) == null && (directHref = this.keyDef.element.attribute("href")) != null && !directHref.equals(href.toString())) {
                                try {
                                    URI directTarget = this.keyDef.source.resolve(new URI(directHref));
                                    URI directTopicFile = this.currentFile.resolve(URLUtils.stripFragment(directTarget));
                                    topicId = this.getFirstTopicId(directTopicFile);
                                }
                                catch (URISyntaxException directTarget) {
                                    // empty catch block
                                }
                            }
                            URI targetOutput = KeyrefPaser.normalizeHrefValue(relativeTarget, elementId, topicId);
                            XMLUtils.addOrSetAttribute(resAtts, refAttr, targetOutput.toString());
                            if (this.keyDef.scope != null && !this.keyDef.scope.equals("local")) {
                                XMLUtils.addOrSetAttribute(resAtts, "scope", this.keyDef.scope);
                            } else {
                                XMLUtils.removeAttribute(resAtts, "scope");
                            }
                            if (this.keyDef.format != null && !this.keyDef.format.equals("dita")) {
                                XMLUtils.addOrSetAttribute(resAtts, "format", this.keyDef.format);
                            } else {
                                XMLUtils.removeAttribute(resAtts, "format");
                            }
                            if (!"resource-only".equals(atts.getValue("processing-role"))) {
                                URI f = this.currentFile.resolve(targetOutput);
                                this.normalProcessingRoleTargets.add(f);
                            }
                        } else {
                            valid = true;
                            if (href.isAbsolute() || this.keyDef.scope != null && this.keyDef.scope.equals("external")) {
                                URI targetOutput = KeyrefPaser.normalizeHrefValue(href, elementId);
                                XMLUtils.addOrSetAttribute(resAtts, refAttr, targetOutput.toString());
                            } else {
                                target = this.keyDef.source.resolve(href);
                                relativeTarget = URLUtils.getRelativePath(this.currentFile, target);
                                targetOutput = KeyrefPaser.normalizeHrefValue(relativeTarget, elementId);
                                XMLUtils.addOrSetAttribute(resAtts, refAttr, targetOutput.toString());
                            }
                            if (this.keyDef.scope != null && !this.keyDef.scope.equals("local")) {
                                XMLUtils.addOrSetAttribute(resAtts, "scope", this.keyDef.scope);
                            } else {
                                XMLUtils.removeAttribute(resAtts, "scope");
                            }
                            if (this.keyDef.format != null && !this.keyDef.format.equals("dita")) {
                                XMLUtils.addOrSetAttribute(resAtts, "format", this.keyDef.format);
                            } else {
                                XMLUtils.removeAttribute(resAtts, "format");
                            }
                        }
                    } else if (href == null || href.toString().isEmpty()) {
                        valid = true;
                        XMLUtils.removeAttribute(resAtts, "scope");
                        XMLUtils.removeAttribute(resAtts, "href");
                        XMLUtils.removeAttribute(resAtts, "type");
                        XMLUtils.removeAttribute(resAtts, "format");
                    } else {
                        MessageBean m = this.definitionMaps.peek().name() == null ? MessageUtils.getMessage("DOTJ047I", atts.getValue("keyref")) : MessageUtils.getMessage("DOTJ048I", atts.getValue("keyref"), this.definitionMaps.peek().name());
                        this.logger.info(m.setLocation(atts).toString());
                    }
                    if (valid) {
                        if (Constants.MAP_TOPICREF.matches(this.currentElement.type)) {
                            for (XdmNode attr : attrs) {
                                if (no_copy.contains(attr.getNodeName().getLocalName())) continue;
                                XMLUtils.removeAttribute(resAtts, this.getQName(attr.getNodeName()));
                                XMLUtils.addOrSetAttribute(resAtts, attr);
                            }
                        } else {
                            for (XdmNode attr : attrs) {
                                if (no_copy_topic.contains(attr.getNodeName().getLocalName()) || !attr.getNodeName().getLocalName().equals(refAttr) && resAtts.getIndex(this.getQName(attr.getNodeName())) != -1) continue;
                                XMLUtils.removeAttribute(resAtts, this.getQName(attr.getNodeName()));
                                XMLUtils.addOrSetAttribute(resAtts, attr);
                            }
                        }
                    }
                }
            } else {
                MessageBean m = this.definitionMaps.peek().name() == null ? MessageUtils.getMessage("DOTJ047I", atts.getValue("keyref")) : MessageUtils.getMessage("DOTJ048I", atts.getValue("keyref"), this.definitionMaps.peek().name());
                this.logger.info(m.setLocation(atts).toString());
            }
            this.validKeyref.push(valid);
        }
        return resAtts;
    }

    private boolean hasKeyref(Attributes atts) {
        if (Constants.TOPIC_PARAM.matches(atts) && atts.getValue("valuetype") != null && !atts.getValue("valuetype").equals("ref")) {
            return false;
        }
        for (String attr : KEYREF_ATTRIBUTES) {
            if (atts.getIndex(attr) == -1) continue;
            return true;
        }
        return false;
    }

    private boolean isLocalDita(XdmNode elem) {
        String scopeValue = elem.attribute("scope");
        String formatValue = elem.attribute("format");
        return DitaUtils.isLocalScope(scopeValue) && (formatValue == null || "dita".equals(formatValue) || "ditamap".equals(formatValue));
    }

    private boolean fallbackToNavtitleOrHref(XdmNode elem) {
        String hrefValue = elem.attribute("href");
        String locktitleValue = elem.attribute("locktitle");
        return Objects.equals("yes", locktitleValue) || hrefValue == null || !this.isLocalDita(elem);
    }

    @VisibleForTesting
    void domToSax(XdmNode elem, boolean retainElements) throws SAXException {
        this.domToSax(elem, retainElements, true);
    }

    private String getQName(QName qName) {
        return qName.getPrefix().length() != 0 ? qName.getPrefix() + ":" + qName.getLocalName() : qName.getLocalName();
    }

    private void domToSax(XdmNode elem, boolean retainElements, boolean swapMapClass) throws SAXException {
        assert (elem.getNodeKind() == XdmNodeKind.ELEMENT);
        QName qName = elem.getNodeName();
        String qNameString = this.getQName(qName);
        if (retainElements) {
            AttributesImpl atts = new AttributesImpl();
            elem.select(Steps.attribute()).forEach(a -> {
                if (Objects.equals(a.getNodeName(), new QName("class")) && swapMapClass) {
                    XMLUtils.addOrSetAttribute(atts, "class", this.changeclassValue(a.getStringValue()));
                } else {
                    XMLUtils.addOrSetAttribute(atts, a);
                }
            });
            this.getContentHandler().startElement(qName.getNamespaceURI(), qName.getLocalName(), qNameString, atts);
        }
        for (XdmNode node : elem.children()) {
            switch (node.getNodeKind()) {
                case ELEMENT: {
                    if (Constants.TOPIC_TM.matches(node) || Constants.TOPIC_TEXT.matches(node)) {
                        this.domToSax(node, true, swapMapClass);
                        break;
                    }
                    this.domToSax(node, retainElements, swapMapClass);
                    break;
                }
                case TEXT: {
                    char[] ch = node.getStringValue().toCharArray();
                    this.getContentHandler().characters(ch, 0, ch.length);
                }
            }
        }
        if (retainElements) {
            this.getContentHandler().endElement(qName.getNamespaceURI(), qName.getLocalName(), qNameString);
        }
    }

    private String changeclassValue(String classValue) {
        DitaClass cls = DitaClass.getInstance(classValue);
        if (cls.equals(Constants.MAP_LINKTEXT)) {
            return Constants.TOPIC_LINKTEXT.toString();
        }
        if (cls.equals(Constants.MAP_SEARCHTITLE)) {
            return Constants.TOPIC_SEARCHTITLE.toString();
        }
        if (cls.equals(Constants.MAP_SHORTDESC)) {
            return Constants.TOPIC_SHORTDESC.toString();
        }
        return cls.toString();
    }

    private static URI normalizeHrefValue(URI keyName, String tail) {
        if (keyName.getFragment() == null) {
            return URLUtils.toURI(String.valueOf(keyName) + tail.replaceAll("/", "#"));
        }
        return URLUtils.toURI(String.valueOf(keyName) + tail);
    }

    private String getFirstTopicId(URI topicFile) {
        return this.mergeUtils.getFirstTopicId(topicFile, false);
    }

    private static URI normalizeHrefValue(URI fileName, String tail, String topicId) {
        if (fileName.getFragment() == null && !"".equals(tail)) {
            return URLUtils.setFragment(fileName, topicId + tail);
        }
        return URLUtils.toURI(String.valueOf(fileName) + tail);
    }

    static {
        HashSet<String> nct = new HashSet<String>(no_copy);
        nct.add("query");
        nct.add("search");
        nct.add("toc");
        nct.add("print");
        nct.add("copy-to");
        nct.add("chunk");
        nct.add("navtitle");
        no_copy_topic = Collections.unmodifiableSet(nct);
        ArrayList<KeyrefInfo> ki = new ArrayList<KeyrefInfo>();
        ki.add(new KeyrefInfo(Constants.TOPIC_AUTHOR, "href", false, true));
        ki.add(new KeyrefInfo(Constants.TOPIC_DATA, "href", false, true));
        ki.add(new KeyrefInfo(Constants.TOPIC_DATA_ABOUT, "href", false, true));
        ki.add(new KeyrefInfo(Constants.TOPIC_IMAGE, "href", false, true));
        ki.add(new KeyrefInfo(Constants.SVG_D_SVGREF, "href", true, false));
        ki.add(new KeyrefInfo(Constants.TOPIC_LINK, "href", false, true));
        ki.add(new KeyrefInfo(Constants.TOPIC_LQ, "href", false, true));
        ki.add(new KeyrefInfo(Constants.MAP_NAVREF, "mapref", true, false));
        ki.add(new KeyrefInfo(Constants.TOPIC_PUBLISHER, "href", false, true));
        ki.add(new KeyrefInfo(Constants.TOPIC_SOURCE, "href", false, true));
        ki.add(new KeyrefInfo(Constants.MAP_TOPICREF, "href", false, false));
        ki.add(new KeyrefInfo(Constants.PR_D_CODEREF, "href", true, false));
        ki.add(new KeyrefInfo(Constants.TOPIC_XREF, "href", false, true));
        ki.add(new KeyrefInfo(Constants.TOPIC_INCLUDE, "href", true, true));
        ki.add(new KeyrefInfo(Constants.TOPIC_CITE, "href", false, false));
        ki.add(new KeyrefInfo(Constants.TOPIC_DT, "href", false, false));
        ki.add(new KeyrefInfo(Constants.TOPIC_KEYWORD, "href", false, false));
        ki.add(new KeyrefInfo(Constants.TOPIC_TERM, "href", false, false));
        ki.add(new KeyrefInfo(Constants.TOPIC_PH, "href", false, false));
        ki.add(new KeyrefInfo(Constants.TOPIC_INDEXTERM, "href", false, false));
        ki.add(new KeyrefInfo(Constants.TOPIC_INDEX_BASE, "href", false, false));
        ki.add(new KeyrefInfo(Constants.TOPIC_INDEXTERMREF, "href", false, false));
        ki.add(new KeyrefInfo(Constants.TOPIC_LONGQUOTEREF, "href", false, false));
        ki.add(new KeyrefInfo(Constants.TOPIC_LONGDESCREF, "href", false, false));
        HashMap<String, String> objectAttrs = new HashMap<String, String>();
        objectAttrs.put("archivekeyrefs", "archive");
        objectAttrs.put("classidkeyref", "classid");
        objectAttrs.put("codebasekeyref", "codebase");
        objectAttrs.put("datakeyref", "data");
        ki.add(new KeyrefInfo(Constants.TOPIC_OBJECT, objectAttrs, true, false));
        HashMap<String, String> paramAttrs = new HashMap<String, String>();
        paramAttrs.put("keyref", "value");
        ki.add(new KeyrefInfo(Constants.TOPIC_PARAM, paramAttrs, true, false));
        keyrefInfos = Collections.unmodifiableList(ki);
        KEYREF_ATTRIBUTES = List.of("keyref", "archivekeyrefs", "classidkeyref", "codebasekeyref", "datakeyref");
    }

    private static final class KeyrefInfo {
        final DitaClass type;
        final Map<String, String> attrs;
        final boolean hasNestedElements;
        final boolean isEmpty;

        KeyrefInfo(DitaClass type, Map<String, String> attrs, boolean isEmpty, boolean hasNestedElements) {
            this.type = type;
            this.attrs = attrs;
            this.isEmpty = isEmpty;
            this.hasNestedElements = hasNestedElements;
        }

        KeyrefInfo(DitaClass type, String refAttr, boolean isEmpty, boolean hasNestedElements) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("keyref", refAttr);
            this.type = type;
            this.attrs = attrs;
            this.isEmpty = isEmpty;
            this.hasNestedElements = hasNestedElements;
        }
    }
}

