/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.MessageBean;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModule;

public final class ModuleFactory {
    private static ModuleFactory moduleFactory = null;

    private ModuleFactory() {
    }

    public static synchronized ModuleFactory instance() {
        if (moduleFactory == null) {
            moduleFactory = new ModuleFactory();
        }
        return moduleFactory;
    }

    public AbstractPipelineModule createModule(Class<? extends AbstractPipelineModule> moduleClass) throws DITAOTException {
        try {
            return moduleClass.newInstance();
        }
        catch (Exception e) {
            MessageBean msgBean = MessageUtils.getMessage("DOTJ005F", moduleClass.getName());
            String msg = msgBean.toString();
            throw new DITAOTException(msgBean, e, msg);
        }
    }
}

