/* ensInfo.c was originally generated by the autoSql program, which also 
 * generated ensInfo.h and ensInfo.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "ensInfo.h"


void ensInfoStaticLoad(char **row, struct ensInfo *ret)
/* Load a row from ensInfo table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->name = row[0];
ret->otherId = row[1];
ret->geneId = row[2];
ret->class = row[3];
ret->geneDesc = row[4];
ret->status = row[5];
}

struct ensInfo *ensInfoLoad(char **row)
/* Load a ensInfo from row fetched with select * from ensInfo
 * from database.  Dispose of this with ensInfoFree(). */
{
struct ensInfo *ret;

AllocVar(ret);
ret->name = cloneString(row[0]);
ret->otherId = cloneString(row[1]);
ret->geneId = cloneString(row[2]);
ret->class = cloneString(row[3]);
ret->geneDesc = cloneString(row[4]);
ret->status = cloneString(row[5]);
return ret;
}

struct ensInfo *ensInfoLoadAll(char *fileName) 
/* Load all ensInfo from a whitespace-separated file.
 * Dispose of this with ensInfoFreeList(). */
{
struct ensInfo *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = ensInfoLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct ensInfo *ensInfoLoadAllByChar(char *fileName, char chopper) 
/* Load all ensInfo from a chopper separated file.
 * Dispose of this with ensInfoFreeList(). */
{
struct ensInfo *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = ensInfoLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct ensInfo *ensInfoCommaIn(char **pS, struct ensInfo *ret)
/* Create a ensInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new ensInfo */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
ret->otherId = sqlStringComma(&s);
ret->geneId = sqlStringComma(&s);
ret->class = sqlStringComma(&s);
ret->geneDesc = sqlStringComma(&s);
ret->status = sqlStringComma(&s);
*pS = s;
return ret;
}

void ensInfoFree(struct ensInfo **pEl)
/* Free a single dynamically allocated ensInfo such as created
 * with ensInfoLoad(). */
{
struct ensInfo *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->otherId);
freeMem(el->geneId);
freeMem(el->class);
freeMem(el->geneDesc);
freeMem(el->status);
freez(pEl);
}

void ensInfoFreeList(struct ensInfo **pList)
/* Free a list of dynamically allocated ensInfo's */
{
struct ensInfo *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    ensInfoFree(&el);
    }
*pList = NULL;
}

void ensInfoOutput(struct ensInfo *el, FILE *f, char sep, char lastSep) 
/* Print out ensInfo.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->otherId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->geneId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->class);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->geneDesc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->status);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

