/* bed8Attrs.c was originally generated by the autoSql program, which also 
 * generated bed8Attrs.h and bed8Attrs.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "bed8Attrs.h"


struct bed8Attrs *bed8AttrsLoad(char **row)
/* Load a bed8Attrs from row fetched with select * from bed8Attrs
 * from database.  Dispose of this with bed8AttrsFree(). */
{
struct bed8Attrs *ret;

AllocVar(ret);
ret->attrCount = sqlSigned(row[8]);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
{
int sizeOne;
sqlStringDynamicArray(row[9], &ret->attrTags, &sizeOne);
assert(sizeOne == ret->attrCount);
}
{
int sizeOne;
sqlStringDynamicArray(row[10], &ret->attrVals, &sizeOne);
assert(sizeOne == ret->attrCount);
}
return ret;
}

struct bed8Attrs *bed8AttrsLoadAll(char *fileName) 
/* Load all bed8Attrs from a whitespace-separated file.
 * Dispose of this with bed8AttrsFreeList(). */
{
struct bed8Attrs *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[11];

while (lineFileRow(lf, row))
    {
    el = bed8AttrsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bed8Attrs *bed8AttrsLoadAllByChar(char *fileName, char chopper) 
/* Load all bed8Attrs from a chopper separated file.
 * Dispose of this with bed8AttrsFreeList(). */
{
struct bed8Attrs *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[11];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = bed8AttrsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bed8Attrs *bed8AttrsCommaIn(char **pS, struct bed8Attrs *ret)
/* Create a bed8Attrs out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bed8Attrs */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->thickStart = sqlUnsignedComma(&s);
ret->thickEnd = sqlUnsignedComma(&s);
ret->attrCount = sqlSignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->attrTags, ret->attrCount);
for (i=0; i<ret->attrCount; ++i)
    {
    ret->attrTags[i] = sqlStringComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->attrVals, ret->attrCount);
for (i=0; i<ret->attrCount; ++i)
    {
    ret->attrVals[i] = sqlStringComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
*pS = s;
return ret;
}

void bed8AttrsFree(struct bed8Attrs **pEl)
/* Free a single dynamically allocated bed8Attrs such as created
 * with bed8AttrsLoad(). */
{
struct bed8Attrs *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
/* All strings in attrTags are allocated at once, so only need to free first. */
if (el->attrTags != NULL)
    freeMem(el->attrTags[0]);
freeMem(el->attrTags);
/* All strings in attrVals are allocated at once, so only need to free first. */
if (el->attrVals != NULL)
    freeMem(el->attrVals[0]);
freeMem(el->attrVals);
freez(pEl);
}

void bed8AttrsFreeList(struct bed8Attrs **pList)
/* Free a list of dynamically allocated bed8Attrs's */
{
struct bed8Attrs *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    bed8AttrsFree(&el);
    }
*pList = NULL;
}

void bed8AttrsOutput(struct bed8Attrs *el, FILE *f, char sep, char lastSep) 
/* Print out bed8Attrs.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->thickStart);
fputc(sep,f);
fprintf(f, "%u", el->thickEnd);
fputc(sep,f);
fprintf(f, "%d", el->attrCount);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->attrCount; ++i)
    {
    if (sep == ',') fputc('"',f);
    fprintf(f, "%s", el->attrTags[i]);
    if (sep == ',') fputc('"',f);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->attrCount; ++i)
    {
    if (sep == ',') fputc('"',f);
    fprintf(f, "%s", el->attrVals[i]);
    if (sep == ',') fputc('"',f);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

