/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.testng.ClassMethodMap;
import org.testng.GuiceHelper;
import org.testng.IAttributes;
import org.testng.IClass;
import org.testng.IClassListener;
import org.testng.IConfigurable;
import org.testng.IConfigurationListener;
import org.testng.IConfigurationListener2;
import org.testng.IDataProviderListener;
import org.testng.IExecutionListener;
import org.testng.IHookable;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.IMethodSelector;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestNGListenerFactory;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.InstanceOrderingMethodInterceptor;
import org.testng.PreserveOrderMethodInterceptor;
import org.testng.TestClass;
import org.testng.TestNGException;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.AbstractParallelWorker;
import org.testng.internal.Attributes;
import org.testng.internal.ClassHelper;
import org.testng.internal.ClassInfoMap;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.DefaultListenerFactory;
import org.testng.internal.DynamicGraph;
import org.testng.internal.DynamicGraphHelper;
import org.testng.internal.GroupsHelper;
import org.testng.internal.IConfiguration;
import org.testng.internal.IInvoker;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InvokedMethod;
import org.testng.internal.Invoker;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.ResultMap;
import org.testng.internal.RunInfo;
import org.testng.internal.Systematiser;
import org.testng.internal.TestListenerHelper;
import org.testng.internal.TestNGClassFinder;
import org.testng.internal.TestNGMethodFinder;
import org.testng.internal.Utils;
import org.testng.internal.XmlMethodSelector;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.thread.graph.GraphThreadPoolExecutor;
import org.testng.internal.thread.graph.IThreadWorkerFactory;
import org.testng.internal.thread.graph.IWorker;
import org.testng.junit.IJUnitTestRunner;
import org.testng.util.Strings;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlTest;

public class TestRunner
implements ITestContext,
ITestResultNotifier,
IThreadWorkerFactory<ITestNGMethod> {
    private static final String DEFAULT_PROP_OUTPUT_DIR = "test-output";
    private final Comparator<ITestNGMethod> comparator;
    private ISuite m_suite;
    private XmlTest m_xmlTest;
    private String m_testName;
    private final GuiceHelper guiceHelper = new GuiceHelper(this);
    private List<XmlClass> m_testClassesFromXml = null;
    private IInvoker m_invoker = null;
    private IAnnotationFinder m_annotationFinder = null;
    private List<ITestListener> m_testListeners = Lists.newArrayList();
    private Set<IConfigurationListener> m_configurationListeners = Sets.newHashSet();
    private IConfigurationListener m_confListener = new ConfigurationListener();
    private Collection<IInvokedMethodListener> m_invokedMethodListeners = Lists.newArrayList();
    private final Map<Class<? extends IClassListener>, IClassListener> m_classListeners = Maps.newHashMap();
    private final Map<Class<? extends IDataProviderListener>, IDataProviderListener> m_dataProviderListeners;
    private ITestNGMethod[] m_allTestMethods = new ITestNGMethod[0];
    private Date m_startDate = null;
    private Date m_endDate = null;
    private Map<Class<?>, ITestClass> m_classMap = Maps.newLinkedHashMap();
    private String m_outputDirectory = "test-output";
    private XmlMethodSelector m_xmlMethodSelector = new XmlMethodSelector();
    private static int m_verbose = 1;
    private ITestNGMethod[] m_beforeSuiteMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_afterSuiteMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_beforeXmlTestMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_afterXmlTestMethods = new ITestNGMethod[0];
    private List<ITestNGMethod> m_excludedMethods = Lists.newArrayList();
    private ConfigurationGroupMethods m_groupMethods = null;
    private Map<String, List<String>> m_metaGroups = Maps.newHashMap();
    private IResultMap m_passedTests = new ResultMap();
    private IResultMap m_failedTests = new ResultMap();
    private IResultMap m_failedButWithinSuccessPercentageTests = new ResultMap();
    private IResultMap m_skippedTests = new ResultMap();
    private RunInfo m_runInfo = new RunInfo();
    private String m_host;
    private List<IMethodInterceptor> m_methodInterceptors;
    private ClassMethodMap m_classMethodMap;
    private TestNGClassFinder m_testClassFinder;
    private IConfiguration m_configuration;
    private IMethodInterceptor builtinInterceptor;
    private final Collection<IInvokedMethod> m_invokedMethods = new ConcurrentLinkedQueue<IInvokedMethod>();
    private IResultMap m_passedConfigurations = new ResultMap();
    private IResultMap m_skippedConfigurations = new ResultMap();
    private IResultMap m_failedConfigurations = new ResultMap();
    private IAttributes m_attributes = new Attributes();
    private ListMultiMap<Class<? extends Module>, Module> m_guiceModules = Maps.newListMultiMap();
    private Map<List<Module>, Injector> m_injectors = Maps.newHashMap();

    protected TestRunner(IConfiguration iConfiguration, ISuite iSuite, XmlTest xmlTest, String string, IAnnotationFinder iAnnotationFinder, boolean bl, Collection<IInvokedMethodListener> collection, List<IClassListener> list, Comparator<ITestNGMethod> comparator, Map<Class<? extends IDataProviderListener>, IDataProviderListener> map) {
        this.comparator = comparator;
        this.m_dataProviderListeners = Maps.newHashMap(map);
        this.init(iConfiguration, iSuite, xmlTest, string, iAnnotationFinder, bl, collection, list);
    }

    public TestRunner(IConfiguration iConfiguration, ISuite iSuite, XmlTest xmlTest, boolean bl, Collection<IInvokedMethodListener> collection, List<IClassListener> list, Comparator<ITestNGMethod> comparator) {
        this.comparator = comparator;
        this.m_dataProviderListeners = Collections.emptyMap();
        this.init(iConfiguration, iSuite, xmlTest, iSuite.getOutputDirectory(), iSuite.getAnnotationFinder(), bl, collection, list);
    }

    public TestRunner(IConfiguration iConfiguration, ISuite iSuite, XmlTest xmlTest, boolean bl, Collection<IInvokedMethodListener> collection, List<IClassListener> list) {
        this.comparator = Systematiser.getComparator();
        this.m_dataProviderListeners = Collections.emptyMap();
        this.init(iConfiguration, iSuite, xmlTest, iSuite.getOutputDirectory(), iSuite.getAnnotationFinder(), bl, collection, list);
    }

    private void init(IConfiguration iConfiguration, ISuite iSuite, XmlTest xmlTest, String string, IAnnotationFinder iAnnotationFinder, boolean bl, Collection<IInvokedMethodListener> collection, List<IClassListener> list) {
        this.m_configuration = iConfiguration;
        this.m_xmlTest = xmlTest;
        this.m_suite = iSuite;
        this.m_testName = xmlTest.getName();
        this.m_host = iSuite.getHost();
        this.m_testClassesFromXml = xmlTest.getXmlClasses();
        this.setVerbose(xmlTest.getVerbose());
        boolean bl2 = xmlTest.getPreserveOrder();
        this.m_methodInterceptors = new ArrayList<IMethodInterceptor>();
        this.builtinInterceptor = bl2 ? new PreserveOrderMethodInterceptor() : new InstanceOrderingMethodInterceptor();
        List<XmlPackage> list2 = xmlTest.getXmlPackages();
        if (null != list2) {
            for (XmlPackage object : list2) {
                this.m_testClassesFromXml.addAll(object.getXmlClasses());
            }
        }
        this.m_annotationFinder = iAnnotationFinder;
        this.m_invokedMethodListeners = collection;
        this.m_classListeners.clear();
        for (IClassListener iClassListener : list) {
            this.m_classListeners.put(iClassListener.getClass(), iClassListener);
        }
        this.m_invoker = new Invoker(this.m_configuration, this, this, this.m_suite.getSuiteState(), bl, collection, list, this.m_dataProviderListeners.values());
        if (xmlTest.getParallel() != null) {
            TestRunner.log(3, "Running the tests in '" + xmlTest.getName() + "' with parallel mode:" + (Object)((Object)xmlTest.getParallel()));
        }
        this.setOutputDirectory(string);
        this.init();
    }

    public IInvoker getInvoker() {
        return this.m_invoker;
    }

    public ITestNGMethod[] getBeforeSuiteMethods() {
        return this.m_beforeSuiteMethods;
    }

    public ITestNGMethod[] getAfterSuiteMethods() {
        return this.m_afterSuiteMethods;
    }

    public ITestNGMethod[] getBeforeTestConfigurationMethods() {
        return this.m_beforeXmlTestMethods;
    }

    public ITestNGMethod[] getAfterTestConfigurationMethods() {
        return this.m_afterXmlTestMethods;
    }

    private void init() {
        this.initMetaGroups(this.m_xmlTest);
        this.initRunInfo(this.m_xmlTest);
        if (!this.m_xmlTest.isJUnit()) {
            this.initMethods();
        }
        this.initListeners();
        this.addConfigurationListener(this.m_confListener);
        for (IConfigurationListener iConfigurationListener : this.m_configuration.getConfigurationListeners()) {
            this.addConfigurationListener(iConfigurationListener);
        }
    }

    private void initListeners() {
        Object object;
        Set<Class> set = Sets.newHashSet();
        Class clazz = null;
        for (IClass object2 : this.getTestClasses()) {
            Class clazz2 = object2.getRealClass();
            object = TestListenerHelper.findAllListeners(clazz2, this.m_annotationFinder);
            if (clazz == null) {
                clazz = ((TestListenerHelper.ListenerHolder)object).getListenerFactoryClass();
            }
            set.addAll(((TestListenerHelper.ListenerHolder)object).getListenerClasses());
        }
        if (clazz == null) {
            clazz = DefaultListenerFactory.class;
        }
        ITestNGListenerFactory iTestNGListenerFactory = TestListenerHelper.createListenerFactory(this.m_testClassFinder, clazz);
        for (Class clazz2 : set) {
            if (IClassListener.class.isAssignableFrom(clazz2) && this.m_classListeners.containsKey(clazz2)) continue;
            object = iTestNGListenerFactory.createListener(clazz2);
            this.addListener((ITestNGListener)object);
        }
    }

    private void initMetaGroups(XmlTest xmlTest) {
        Map<String, List<String>> map = xmlTest.getMetaGroups();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            this.addMetaGroup(entry.getKey(), entry.getValue());
        }
    }

    private void initRunInfo(XmlTest xmlTest) {
        this.m_xmlMethodSelector.setIncludedGroups(this.createGroups(this.m_xmlTest.getIncludedGroups()));
        this.m_xmlMethodSelector.setExcludedGroups(this.createGroups(this.m_xmlTest.getExcludedGroups()));
        this.m_xmlMethodSelector.setExpression(this.m_xmlTest.getExpression());
        this.m_xmlMethodSelector.setXmlClasses(this.m_xmlTest.getXmlClasses());
        this.m_runInfo.addMethodSelector(this.m_xmlMethodSelector, 10);
        if (null != xmlTest.getMethodSelectors()) {
            for (org.testng.xml.XmlMethodSelector xmlMethodSelector : xmlTest.getMethodSelectors()) {
                if (xmlMethodSelector.getClassName() == null) continue;
                IMethodSelector iMethodSelector = ClassHelper.createSelector(xmlMethodSelector);
                this.m_runInfo.addMethodSelector(iMethodSelector, xmlMethodSelector.getPriority());
            }
        }
    }

    private void initMethods() {
        List<ITestNGMethod> list = Lists.newArrayList();
        List<ITestNGMethod> list2 = Lists.newArrayList();
        List<ITestNGMethod> list3 = Lists.newArrayList();
        List<ITestNGMethod> list4 = Lists.newArrayList();
        List<ITestNGMethod> list5 = Lists.newArrayList();
        List<ITestNGMethod> list6 = Lists.newArrayList();
        List<ITestNGMethod> list7 = Lists.newArrayList();
        ClassInfoMap classInfoMap = new ClassInfoMap(this.m_testClassesFromXml);
        this.m_testClassFinder = new TestNGClassFinder(classInfoMap, Maps.newHashMap(), this.m_configuration, (ITestContext)this, this.m_dataProviderListeners);
        TestNGMethodFinder testNGMethodFinder = new TestNGMethodFinder(this.m_runInfo, this.m_annotationFinder, this.comparator);
        this.m_runInfo.setTestMethods(list2);
        IClass[] iClassArray = this.m_testClassFinder.findTestClasses();
        for (IClass iClass : iClassArray) {
            TestClass testClass = new TestClass(iClass, testNGMethodFinder, this.m_annotationFinder, this.m_runInfo, this.m_xmlTest, classInfoMap.getXmlClass(iClass.getRealClass()));
            this.m_classMap.put(iClass.getRealClass(), testClass);
        }
        Map<String, List<ITestNGMethod>> map = MethodGroupsHelper.findGroupsMethods(this.m_classMap.values(), true);
        Map<String, List<ITestNGMethod>> map2 = MethodGroupsHelper.findGroupsMethods(this.m_classMap.values(), false);
        for (ITestClass iTestClass : this.m_classMap.values()) {
            MethodHelper.fixMethodsWithClass(iTestClass.getTestMethods(), iTestClass, list2);
            MethodHelper.fixMethodsWithClass(iTestClass.getBeforeClassMethods(), iTestClass, list);
            MethodHelper.fixMethodsWithClass(iTestClass.getBeforeTestMethods(), iTestClass, null);
            MethodHelper.fixMethodsWithClass(iTestClass.getAfterTestMethods(), iTestClass, null);
            MethodHelper.fixMethodsWithClass(iTestClass.getAfterClassMethods(), iTestClass, list3);
            MethodHelper.fixMethodsWithClass(iTestClass.getBeforeSuiteMethods(), iTestClass, list4);
            MethodHelper.fixMethodsWithClass(iTestClass.getAfterSuiteMethods(), iTestClass, list5);
            MethodHelper.fixMethodsWithClass(iTestClass.getBeforeTestConfigurationMethods(), iTestClass, list6);
            MethodHelper.fixMethodsWithClass(iTestClass.getAfterTestConfigurationMethods(), iTestClass, list7);
            MethodHelper.fixMethodsWithClass(iTestClass.getBeforeGroupsMethods(), iTestClass, MethodHelper.uniqueMethodList(map.values()));
            MethodHelper.fixMethodsWithClass(iTestClass.getAfterGroupsMethods(), iTestClass, MethodHelper.uniqueMethodList(map2.values()));
        }
        this.m_beforeSuiteMethods = MethodHelper.collectAndOrderMethods(list4, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods, this.comparator);
        this.m_beforeXmlTestMethods = MethodHelper.collectAndOrderMethods(list6, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods, this.comparator);
        this.m_allTestMethods = MethodHelper.collectAndOrderMethods(list2, true, this.m_runInfo, this.m_annotationFinder, false, this.m_excludedMethods, this.comparator);
        this.m_classMethodMap = new ClassMethodMap(list2, this.m_xmlMethodSelector);
        this.m_afterXmlTestMethods = MethodHelper.collectAndOrderMethods(list7, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods, this.comparator);
        this.m_afterSuiteMethods = MethodHelper.collectAndOrderMethods(list5, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods, this.comparator);
        this.m_groupMethods = new ConfigurationGroupMethods(this.m_allTestMethods, map, map2);
    }

    public Collection<ITestClass> getTestClasses() {
        return this.m_classMap.values();
    }

    public void setTestName(String string) {
        this.m_testName = string;
    }

    public void setOutputDirectory(String string) {
        this.m_outputDirectory = string;
    }

    private void addMetaGroup(String string, List<String> list) {
        this.m_metaGroups.put(string, list);
    }

    private Map<String, String> createGroups(List<String> list) {
        return GroupsHelper.createGroups(this.m_metaGroups, list);
    }

    public void run() {
        this.beforeRun();
        try {
            XmlTest xmlTest = this.getTest();
            if (xmlTest.isJUnit()) {
                this.privateRunJUnit();
            } else {
                this.privateRun(xmlTest);
            }
        }
        finally {
            this.afterRun();
        }
    }

    private void beforeRun() {
        this.m_startDate = new Date(System.currentTimeMillis());
        this.logStart();
        this.fireEvent(true);
        ITestNGMethod[] iTestNGMethodArray = this.getBeforeTestConfigurationMethods();
        if (null != iTestNGMethodArray && iTestNGMethodArray.length > 0) {
            this.m_invoker.invokeConfigurations(null, iTestNGMethodArray, this.m_xmlTest.getSuite(), this.m_xmlTest.getAllParameters(), null, null);
        }
    }

    private void privateRunJUnit() {
        final ClassInfoMap classInfoMap = new ClassInfoMap(this.m_testClassesFromXml, false);
        final Set<Class<?>> set = classInfoMap.getClasses();
        final List list = Lists.newArrayList();
        List list2 = Lists.newArrayList();
        list2.add(new IWorker<ITestNGMethod>(){

            @Override
            public long getTimeOut() {
                return 0L;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (Class clazz : set) {
                    List<XmlInclude> list3 = classInfoMap.getXmlClass(clazz).getIncludedMethods();
                    List list2 = Lists.newArrayList();
                    for (XmlInclude xmlInclude : list3) {
                        list2.add(xmlInclude.getName());
                    }
                    IJUnitTestRunner iJUnitTestRunner = ClassHelper.createTestRunner(TestRunner.this);
                    iJUnitTestRunner.setInvokedMethodListeners(TestRunner.this.m_invokedMethodListeners);
                    try {
                        iJUnitTestRunner.run(clazz, list2.toArray(new String[list2.size()]));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        list.addAll(iJUnitTestRunner.getTestMethods());
                    }
                }
            }

            @Override
            public List<ITestNGMethod> getTasks() {
                throw new TestNGException("JUnit not supported");
            }

            @Override
            public int getPriority() {
                if (TestRunner.this.m_allTestMethods.length == 1) {
                    return TestRunner.this.m_allTestMethods[0].getPriority();
                }
                return 0;
            }

            @Override
            public int compareTo(IWorker<ITestNGMethod> iWorker) {
                return this.getPriority() - iWorker.getPriority();
            }
        });
        this.runJUnitWorkers(list2);
        this.m_allTestMethods = list.toArray(new ITestNGMethod[list.size()]);
    }

    private void privateRun(XmlTest xmlTest) {
        boolean bl = xmlTest.getParallel().isParallel();
        int n = bl ? xmlTest.getThreadCount() : 1;
        DynamicGraph<ITestNGMethod> dynamicGraph = DynamicGraphHelper.createDynamicGraph(this.intercept(this.m_allTestMethods), this.getCurrentXmlTest());
        if (bl) {
            if (dynamicGraph.getNodeCount() > 0) {
                GraphThreadPoolExecutor<ITestNGMethod> graphThreadPoolExecutor = new GraphThreadPoolExecutor<ITestNGMethod>("test=" + xmlTest.getName(), dynamicGraph, this, n, n, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
                graphThreadPoolExecutor.run();
                try {
                    long l = this.m_xmlTest.getTimeOut(Integer.MAX_VALUE);
                    Utils.log("TestRunner", 2, "Starting executor for test " + this.m_xmlTest.getName() + " with time out:" + l + " milliseconds.");
                    graphThreadPoolExecutor.awaitTermination(l, TimeUnit.MILLISECONDS);
                    graphThreadPoolExecutor.shutdownNow();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
        } else {
            List<ITestNGMethod> list = dynamicGraph.getFreeNodes();
            if (dynamicGraph.getNodeCount() > 0 && list.isEmpty()) {
                throw new TestNGException("No free nodes found in:" + dynamicGraph);
            }
            while (!list.isEmpty()) {
                List<IWorker<ITestNGMethod>> list2 = this.createWorkers(list);
                for (IWorker<ITestNGMethod> iWorker : list2) {
                    iWorker.run();
                }
                dynamicGraph.setStatus((ITestNGMethod)((Object)list), DynamicGraph.Status.FINISHED);
                list = dynamicGraph.getFreeNodes();
            }
        }
    }

    private ITestNGMethod[] intercept(ITestNGMethod[] iTestNGMethodArray) {
        List<IMethodInstance> list = MethodHelper.methodsToMethodInstances(Arrays.asList(iTestNGMethodArray));
        this.m_methodInterceptors.add(this.builtinInterceptor);
        for (IMethodInterceptor iTestNGMethodArray22 : this.m_methodInterceptors) {
            list = iTestNGMethodArray22.intercept(list, this);
        }
        List<ITestNGMethod> list2 = MethodHelper.methodInstancesToMethods(list);
        this.m_classMethodMap = new ClassMethodMap(list2, null);
        ITestNGMethod[] iTestNGMethodArray2 = list2.toArray(new ITestNGMethod[list2.size()]);
        if (iTestNGMethodArray2.length != this.m_groupMethods.getAllTestMethods().length) {
            this.m_groupMethods = new ConfigurationGroupMethods(iTestNGMethodArray2, this.m_groupMethods.getBeforeGroupsMethods(), this.m_groupMethods.getAfterGroupsMethods());
        }
        return iTestNGMethodArray2;
    }

    @Override
    public List<IWorker<ITestNGMethod>> createWorkers(List<ITestNGMethod> list) {
        AbstractParallelWorker.Arguments arguments = new AbstractParallelWorker.Arguments.Builder().classMethodMap(this.m_classMethodMap).configMethods(this.m_groupMethods).finder(this.m_annotationFinder).invoker(this.m_invoker).methods(list).testContext(this).listeners(this.m_classListeners.values()).build();
        return AbstractParallelWorker.newWorker(this.m_xmlTest.getParallel()).createWorkers(arguments);
    }

    private void runJUnitWorkers(List<? extends IWorker<ITestNGMethod>> list) {
        for (IWorker<ITestNGMethod> iWorker : list) {
            iWorker.run();
        }
    }

    private void afterRun() {
        ITestNGMethod[] iTestNGMethodArray = this.getAfterTestConfigurationMethods();
        if (null != iTestNGMethodArray && iTestNGMethodArray.length > 0) {
            this.m_invoker.invokeConfigurations(null, iTestNGMethodArray, this.m_xmlTest.getSuite(), this.m_xmlTest.getAllParameters(), null, null);
        }
        this.m_endDate = new Date(System.currentTimeMillis());
        this.dumpInvokedMethods();
        this.fireEvent(false);
    }

    private void logStart() {
        TestRunner.log(3, "Running test " + this.m_testName + " on " + this.m_classMap.size() + "  classes,  included groups:[" + Strings.valueOf(this.m_xmlMethodSelector.getIncludedGroups()) + "] excluded groups:[" + Strings.valueOf(this.m_xmlMethodSelector.getExcludedGroups()) + "]");
        if (TestRunner.getVerbose() >= 3) {
            for (ITestClass iTestClass : this.m_classMap.values()) {
                ((TestClass)iTestClass).dump();
            }
        }
    }

    private void fireEvent(boolean bl) {
        for (ITestListener iTestListener : this.m_testListeners) {
            if (bl) {
                iTestListener.onStart(this);
                continue;
            }
            iTestListener.onFinish(this);
        }
    }

    @Override
    public String getName() {
        return this.m_testName;
    }

    @Override
    public Date getStartDate() {
        return this.m_startDate;
    }

    @Override
    public Date getEndDate() {
        return this.m_endDate;
    }

    @Override
    public IResultMap getPassedTests() {
        return this.m_passedTests;
    }

    @Override
    public IResultMap getSkippedTests() {
        return this.m_skippedTests;
    }

    @Override
    public IResultMap getFailedTests() {
        return this.m_failedTests;
    }

    @Override
    public IResultMap getFailedButWithinSuccessPercentageTests() {
        return this.m_failedButWithinSuccessPercentageTests;
    }

    @Override
    public String[] getIncludedGroups() {
        Map<String, String> map = this.m_xmlMethodSelector.getIncludedGroups();
        return map.values().toArray(new String[map.size()]);
    }

    @Override
    public String[] getExcludedGroups() {
        Map<String, String> map = this.m_xmlMethodSelector.getExcludedGroups();
        return map.values().toArray(new String[map.size()]);
    }

    @Override
    public String getOutputDirectory() {
        return this.m_outputDirectory;
    }

    @Override
    public ISuite getSuite() {
        return this.m_suite;
    }

    @Override
    public ITestNGMethod[] getAllTestMethods() {
        return this.m_allTestMethods;
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    @Override
    public Collection<ITestNGMethod> getExcludedMethods() {
        Map<ITestNGMethod, ITestNGMethod> map = Maps.newHashMap();
        for (ITestNGMethod iTestNGMethod : this.m_excludedMethods) {
            map.put(iTestNGMethod, iTestNGMethod);
        }
        return map.keySet();
    }

    @Override
    public IResultMap getFailedConfigurations() {
        return this.m_failedConfigurations;
    }

    @Override
    public IResultMap getPassedConfigurations() {
        return this.m_passedConfigurations;
    }

    @Override
    public IResultMap getSkippedConfigurations() {
        return this.m_skippedConfigurations;
    }

    @Override
    public void addPassedTest(ITestNGMethod iTestNGMethod, ITestResult iTestResult) {
        this.m_passedTests.addResult(iTestResult, iTestNGMethod);
    }

    @Override
    public Set<ITestResult> getPassedTests(ITestNGMethod iTestNGMethod) {
        return this.m_passedTests.getResults(iTestNGMethod);
    }

    @Override
    public Set<ITestResult> getFailedTests(ITestNGMethod iTestNGMethod) {
        return this.m_failedTests.getResults(iTestNGMethod);
    }

    @Override
    public Set<ITestResult> getSkippedTests(ITestNGMethod iTestNGMethod) {
        return this.m_skippedTests.getResults(iTestNGMethod);
    }

    @Override
    public void addSkippedTest(ITestNGMethod iTestNGMethod, ITestResult iTestResult) {
        this.m_skippedTests.addResult(iTestResult, iTestNGMethod);
    }

    @Override
    public void addInvokedMethod(InvokedMethod invokedMethod) {
        this.m_invokedMethods.add(invokedMethod);
    }

    @Override
    public void addFailedTest(ITestNGMethod iTestNGMethod, ITestResult iTestResult) {
        this.logFailedTest(iTestNGMethod, iTestResult, false);
    }

    @Override
    public void addFailedButWithinSuccessPercentageTest(ITestNGMethod iTestNGMethod, ITestResult iTestResult) {
        this.logFailedTest(iTestNGMethod, iTestResult, true);
    }

    @Override
    public XmlTest getTest() {
        return this.m_xmlTest;
    }

    @Override
    public List<ITestListener> getTestListeners() {
        return this.m_testListeners;
    }

    @Override
    public List<IConfigurationListener> getConfigurationListeners() {
        return Lists.newArrayList(this.m_configurationListeners);
    }

    private void logFailedTest(ITestNGMethod iTestNGMethod, ITestResult iTestResult, boolean bl) {
        if (bl) {
            this.m_failedButWithinSuccessPercentageTests.addResult(iTestResult, iTestNGMethod);
        } else {
            this.m_failedTests.addResult(iTestResult, iTestNGMethod);
        }
    }

    private static void log(int n, String string) {
        Utils.log("TestRunner", n, string);
    }

    public static int getVerbose() {
        return m_verbose;
    }

    public void setVerbose(int n) {
        m_verbose = n;
    }

    void addTestListener(ITestListener iTestListener) {
        this.m_testListeners.add(iTestListener);
    }

    public void addListener(ITestNGListener iTestNGListener) {
        ITestNGListener iTestNGListener2;
        if (iTestNGListener instanceof IMethodInterceptor) {
            this.m_methodInterceptors.add((IMethodInterceptor)iTestNGListener);
        }
        if (iTestNGListener instanceof ITestListener) {
            this.addTestListener((ITestListener)iTestNGListener);
        }
        if (iTestNGListener instanceof IClassListener && !this.m_classListeners.containsKey((iTestNGListener2 = (IClassListener)iTestNGListener).getClass())) {
            this.m_classListeners.put(iTestNGListener2.getClass(), (IClassListener)iTestNGListener2);
        }
        if (iTestNGListener instanceof IConfigurationListener) {
            this.addConfigurationListener((IConfigurationListener)iTestNGListener);
        }
        if (iTestNGListener instanceof IConfigurable) {
            this.m_configuration.setConfigurable((IConfigurable)iTestNGListener);
        }
        if (iTestNGListener instanceof IHookable) {
            this.m_configuration.setHookable((IHookable)iTestNGListener);
        }
        if (iTestNGListener instanceof IExecutionListener) {
            iTestNGListener2 = (IExecutionListener)iTestNGListener;
            iTestNGListener2.onExecutionStart();
            this.m_configuration.addExecutionListener((IExecutionListener)iTestNGListener2);
        }
        if (iTestNGListener instanceof IDataProviderListener) {
            iTestNGListener2 = (IDataProviderListener)iTestNGListener;
            this.m_dataProviderListeners.put(iTestNGListener2.getClass(), (IDataProviderListener)iTestNGListener2);
        }
        this.m_suite.addListener(iTestNGListener);
    }

    void addConfigurationListener(IConfigurationListener iConfigurationListener) {
        this.m_configurationListeners.add(iConfigurationListener);
    }

    private void dumpInvokedMethods() {
        MethodHelper.dumpInvokedMethodsInfoToConsole(this.m_invokedMethods, TestRunner.getVerbose());
    }

    public List<ITestNGMethod> getInvokedMethods() {
        return MethodHelper.invokedMethodsToMethods(this.m_invokedMethods);
    }

    void addMethodInterceptor(IMethodInterceptor iMethodInterceptor) {
        this.m_methodInterceptors.add(iMethodInterceptor);
    }

    @Override
    public XmlTest getCurrentXmlTest() {
        return this.m_xmlTest;
    }

    @Override
    public Object getAttribute(String string) {
        return this.m_attributes.getAttribute(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.m_attributes.setAttribute(string, object);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.m_attributes.getAttributeNames();
    }

    @Override
    public Object removeAttribute(String string) {
        return this.m_attributes.removeAttribute(string);
    }

    @Override
    public List<Module> getGuiceModules(Class<? extends Module> clazz) {
        return (List)this.m_guiceModules.get(clazz);
    }

    @Override
    public Injector getInjector(List<Module> list) {
        return this.m_injectors.get(list);
    }

    @Override
    public Injector getInjector(IClass iClass) {
        return this.guiceHelper.getInjector(iClass);
    }

    @Override
    public void addInjector(List<Module> list, Injector injector) {
        this.m_injectors.put(list, injector);
    }

    private class ConfigurationListener
    implements IConfigurationListener2 {
        private ConfigurationListener() {
        }

        @Override
        public void beforeConfiguration(ITestResult iTestResult) {
        }

        @Override
        public void onConfigurationFailure(ITestResult iTestResult) {
            TestRunner.this.m_failedConfigurations.addResult(iTestResult, iTestResult.getMethod());
        }

        @Override
        public void onConfigurationSkip(ITestResult iTestResult) {
            TestRunner.this.m_skippedConfigurations.addResult(iTestResult, iTestResult.getMethod());
        }

        @Override
        public void onConfigurationSuccess(ITestResult iTestResult) {
            TestRunner.this.m_passedConfigurations.addResult(iTestResult, iTestResult.getMethod());
        }
    }

    public static enum PriorityWeight {
        groupByInstance,
        preserveOrder,
        priority,
        dependsOnGroups,
        dependsOnMethods;

    }
}

