/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ResourceTable;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.modules.visual.laf.DefaultLookFeel;
import org.netbeans.modules.visual.util.GeomUtil;
import org.netbeans.modules.visual.widget.WidgetAccessibleContext;
import org.openide.util.Lookup;

public class Widget
implements Accessible,
Lookup.Provider {
    static final String MESSAGE_NULL_BOUNDS = "Scene.validate was not called after last change. Widget is not validated. See first Q/A at http://graph.netbeans.org/faq.html page.";
    private static final HashMap<String, WidgetAction.Chain> EMPTY_HASH_MAP = new HashMap(0);
    private Scene scene;
    private Widget parentWidget;
    private List<Widget> children;
    private List<Widget> childrenUm;
    private HashMap<Widget, Object> constraints;
    private WidgetAction.Chain actionsChain;
    private HashMap<String, WidgetAction.Chain> toolsActions = EMPTY_HASH_MAP;
    private ArrayList<Dependency> dependencies;
    private boolean visible = true;
    private boolean opaque;
    private Paint background;
    private Color foreground;
    private Font font;
    private org.netbeans.api.visual.border.Border border;
    private Layout layout;
    private Point preferredLocation;
    private Dimension minimumSize;
    private Dimension maximumSize;
    private Dimension preferredSize;
    private Rectangle preferredBounds;
    private boolean checkClipping;
    private boolean enabled;
    private String foregroundProperty = null;
    private String backgroundProperty = null;
    private String fontProperties = null;
    private PropertyChangeListener foregroundListener = null;
    private PropertyChangeListener backgroundListener = null;
    private PropertyChangeListener fontListener = null;
    private ObjectState state = ObjectState.createNormal();
    private Cursor cursor;
    private String toolTipText;
    private AccessibleContext accessibleContext;
    private Point location;
    private Rectangle bounds;
    private Rectangle calculatedPreferredBounds;
    private boolean requiresFullValidation;
    private boolean requiresPartValidation;
    private boolean requiresFullJustification;
    private boolean requiresPartJustification;
    private ResourceTable resourceTable = null;

    public Widget(Scene scene) {
        if (scene == null) {
            scene = (Scene)this;
        }
        this.scene = scene;
        this.children = new ArrayList<Widget>();
        this.childrenUm = Collections.unmodifiableList(this.children);
        this.actionsChain = new WidgetAction.Chain();
        this.opaque = false;
        this.font = null;
        this.background = new DefaultLookFeel().getBackground();
        this.foreground = new DefaultLookFeel().getForeground();
        this.border = BorderFactory.createEmptyBorder();
        this.layout = LayoutFactory.createAbsoluteLayout();
        this.preferredLocation = null;
        this.preferredBounds = null;
        this.checkClipping = false;
        this.enabled = true;
        this.location = new Point();
        this.bounds = null;
        this.calculatedPreferredBounds = null;
        this.requiresFullValidation = true;
        this.requiresPartValidation = true;
    }

    public final Scene getScene() {
        return this.scene;
    }

    protected Graphics2D getGraphics() {
        return this.scene.getGraphics();
    }

    public final Widget getParentWidget() {
        return this.parentWidget;
    }

    public final List<Widget> getChildren() {
        return this.childrenUm;
    }

    public final void addChild(Widget widget) {
        this.addChild(widget, null);
    }

    public final void addChild(Widget widget, Object object) {
        assert (widget.parentWidget == null);
        assert (SwingUtilities.isEventDispatchThread());
        Widget widget2 = this;
        while (widget2 != null) {
            assert (widget2 != widget);
            widget2 = widget2.parentWidget;
        }
        this.children.add(widget);
        widget.parentWidget = this;
        this.setChildConstraint(widget, object);
        widget.updateResources(this, true);
        widget.revalidate();
        this.revalidate();
        this.scene.dispatchNotifyAdded(widget);
    }

    public final void addChild(int n, Widget widget) {
        this.addChild(n, widget, null);
    }

    public final void addChild(int n, Widget widget, Object object) {
        assert (widget.parentWidget == null);
        assert (SwingUtilities.isEventDispatchThread());
        this.children.add(n, widget);
        widget.parentWidget = this;
        this.setChildConstraint(widget, object);
        widget.updateResources(this, true);
        widget.revalidate();
        this.revalidate();
        if (this.accessibleContext instanceof WidgetAccessibleContext) {
            ((WidgetAccessibleContext)this.accessibleContext).notifyChildAdded(this, widget);
        }
        this.scene.dispatchNotifyAdded(widget);
    }

    public final void removeChild(Widget widget) {
        assert (widget.parentWidget == this);
        assert (SwingUtilities.isEventDispatchThread());
        this.setChildConstraint(widget, null);
        widget.parentWidget = null;
        this.children.remove(widget);
        widget.updateResources(this, false);
        widget.revalidate();
        this.revalidate();
        if (this.accessibleContext instanceof WidgetAccessibleContext) {
            ((WidgetAccessibleContext)this.accessibleContext).notifyChildRemoved(this, widget);
        }
        this.scene.dispatchNotifyRemoved(widget);
    }

    public final void removeFromParent() {
        if (this.parentWidget != null) {
            this.parentWidget.removeChild(this);
        }
    }

    public final void removeChildren() {
        while (!this.children.isEmpty()) {
            this.removeChild(this.children.get(0));
        }
    }

    public final void addChildren(List<? extends Widget> list) {
        for (Widget widget : list) {
            this.addChild(widget);
        }
    }

    public final void removeChildren(List<Widget> list) {
        for (Widget widget : list) {
            this.removeChild(widget);
        }
    }

    void dispatchNotifyAddedCore() {
        this.notifyAdded();
        for (Widget widget : this.children) {
            widget.dispatchNotifyAddedCore();
        }
    }

    void dispatchNotifyRemovedCore() {
        this.notifyRemoved();
        for (Widget widget : this.children) {
            widget.dispatchNotifyRemovedCore();
        }
    }

    protected void notifyAdded() {
    }

    protected void notifyRemoved() {
    }

    public final void bringToFront() {
        if (this.parentWidget == null) {
            return;
        }
        List<Widget> list = this.parentWidget.children;
        int n = list.indexOf(this);
        if (n < 0) {
            return;
        }
        list.remove(n);
        list.add(list.size(), this);
        this.revalidate();
        this.parentWidget.revalidate();
    }

    public final void bringToBack() {
        if (this.parentWidget == null) {
            return;
        }
        List<Widget> list = this.parentWidget.children;
        int n = list.indexOf(this);
        if (n <= 0) {
            return;
        }
        list.remove(n);
        list.add(0, this);
        this.revalidate();
        this.parentWidget.revalidate();
    }

    public final Object getChildConstraint(Widget widget) {
        return this.constraints != null ? this.constraints.get(widget) : null;
    }

    public final void setChildConstraint(Widget widget, Object object) {
        assert (this.children.contains(widget));
        if (object == null) {
            if (this.constraints != null) {
                this.constraints.remove(widget);
            }
            return;
        }
        if (this.constraints == null) {
            this.constraints = new HashMap();
        }
        this.constraints.put(widget, object);
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void setVisible(boolean bl) {
        this.visible = bl;
        this.revalidate();
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final WidgetAction.Chain getActions() {
        return this.actionsChain;
    }

    public final WidgetAction.Chain getActions(String string) {
        return this.toolsActions.get(string);
    }

    public final WidgetAction.Chain createActions(String string) {
        WidgetAction.Chain chain;
        if (string == null) {
            return this.actionsChain;
        }
        if (this.toolsActions == EMPTY_HASH_MAP) {
            this.toolsActions = new HashMap();
            this.toolsActions.put(null, this.actionsChain);
        }
        if ((chain = this.toolsActions.get(string)) == null) {
            chain = new WidgetAction.Chain();
            this.toolsActions.put(string, chain);
        }
        return chain;
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    public final void addDependency(Dependency dependency) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        this.dependencies.add(dependency);
    }

    public final void removeDependency(Dependency dependency) {
        if (this.dependencies == null) {
            return;
        }
        this.dependencies.remove(dependency);
    }

    public final Collection<Dependency> getDependencies() {
        return this.dependencies != null ? Collections.unmodifiableCollection(this.dependencies) : Collections.emptyList();
    }

    public final boolean isOpaque() {
        return this.opaque;
    }

    public final void setOpaque(boolean bl) {
        this.opaque = bl;
        this.repaint();
    }

    public final Paint getBackground() {
        return this.background != null ? this.background : (this.parentWidget != null ? this.parentWidget.getBackground() : null);
    }

    public final void setBackground(Paint paint) {
        this.background = paint;
        if (this.backgroundListener != null) {
            ResourceTable resourceTable = this.getResourceTable();
            if (resourceTable != null) {
                resourceTable.removePropertyChangeListener(this.backgroundProperty, this.backgroundListener);
            }
            this.backgroundListener = null;
        }
        this.repaint();
    }

    public final void setBackgroundFromResource(String string) {
        ResourceTable resourceTable = this.getResourceTable();
        String string2 = this.backgroundProperty;
        this.backgroundProperty = string;
        if (resourceTable != null) {
            Object object;
            if (string2 != null && string2.length() > 0) {
                resourceTable.removePropertyChangeListener(string2, this.backgroundListener);
            }
            if ((object = resourceTable.getProperty(string)) instanceof Paint) {
                this.background = (Paint)object;
            }
            this.backgroundListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() instanceof Paint) {
                        Widget.this.background = (Paint)propertyChangeEvent.getNewValue();
                        Widget.this.notifyBackgroundChanged(Widget.this.background);
                    }
                }
            };
            resourceTable.addPropertyChangeListener(string, this.backgroundListener);
        }
        this.repaint();
    }

    protected void notifyBackgroundChanged(Paint paint) {
    }

    public final Color getForeground() {
        return this.foreground != null ? this.foreground : (this.parentWidget != null ? this.parentWidget.getForeground() : null);
    }

    public final void setForeground(Color color) {
        this.foreground = color;
        if (this.foregroundListener != null) {
            ResourceTable resourceTable = this.getResourceTable();
            if (resourceTable != null) {
                resourceTable.removePropertyChangeListener(this.foregroundProperty, this.foregroundListener);
            }
            this.foregroundListener = null;
        }
        this.repaint();
    }

    public final void setForegroundFromResource(String string) {
        String string2 = this.foregroundProperty;
        this.foregroundProperty = string;
        ResourceTable resourceTable = this.getResourceTable();
        if (resourceTable != null) {
            Object object;
            if (string2 != null && string2.length() > 0) {
                resourceTable.removePropertyChangeListener(string2, this.foregroundListener);
            }
            if ((object = resourceTable.getProperty(string)) instanceof Color) {
                this.foreground = (Color)object;
            }
            if (this.foregroundListener == null) {
                this.foregroundListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getNewValue() instanceof Color) {
                            Widget.this.foreground = (Color)propertyChangeEvent.getNewValue();
                            Widget.this.notifyForegroundChanged(Widget.this.foreground);
                        }
                    }
                };
            }
            resourceTable.addPropertyChangeListener(string, this.foregroundListener);
        }
        this.repaint();
    }

    protected void notifyForegroundChanged(Color color) {
    }

    public final Font getFont() {
        Font font = this.font;
        if (this.font == null && this.parentWidget != null) {
            font = this.parentWidget.getFont();
        }
        return font;
    }

    public final void setFont(Font font) {
        this.font = font;
        if (this.fontListener != null) {
            ResourceTable resourceTable = this.getResourceTable();
            if (resourceTable != null) {
                resourceTable.removePropertyChangeListener(this.fontProperties, this.fontListener);
            }
            this.fontListener = null;
        }
        this.notifyFontChanged(font);
        this.revalidate();
    }

    public final void setFontFromResource(String string) {
        String string2 = this.fontProperties;
        this.fontProperties = string;
        ResourceTable resourceTable = this.getResourceTable();
        if (resourceTable != null) {
            Object object;
            if (string2 != null && string2.length() > 0) {
                resourceTable.removePropertyChangeListener(string2, this.fontListener);
            }
            if ((object = resourceTable.getProperty(string)) instanceof Font) {
                this.font = (Font)object;
            }
            this.fontListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Object object = propertyChangeEvent.getNewValue();
                    if (object instanceof Font && Widget.this.parentWidget != null) {
                        Widget.this.font = (Font)object;
                        Widget.this.notifyFontChanged(Widget.this.font);
                    }
                }
            };
            resourceTable.addPropertyChangeListener(string, this.fontListener);
        }
        this.repaint();
    }

    protected final void updateResources(Widget widget, boolean bl) {
        Object object;
        if (bl) {
            object = this.connectResourceTable();
            if (object != null) {
                if (this.foregroundProperty != null && this.foregroundProperty.length() > 0) {
                    this.setForegroundFromResource(this.foregroundProperty);
                }
                if (this.fontProperties != null && this.fontProperties.length() > 0) {
                    this.setFontFromResource(this.fontProperties);
                }
                if (this.backgroundProperty != null && this.backgroundProperty.length() > 0) {
                    this.setBackgroundFromResource(this.backgroundProperty);
                }
            }
        } else {
            object = this.resourceTable;
            if (object == null) {
                object = widget.getResourceTable();
            }
            if (object != null) {
                if (this.foregroundListener != null) {
                    ((ResourceTable)object).removePropertyChangeListener(this.foregroundListener);
                }
                if (this.fontListener != null) {
                    ((ResourceTable)object).removePropertyChangeListener(this.fontListener);
                }
                if (this.backgroundListener != null) {
                    ((ResourceTable)object).removePropertyChangeListener(this.backgroundListener);
                }
            }
            this.disconnectResourceTable();
        }
        for (Widget widget2 : this.getChildren()) {
            widget2.updateResources(widget, bl);
        }
        this.revalidate();
    }

    protected void notifyFontChanged(Font font) {
    }

    public final org.netbeans.api.visual.border.Border getBorder() {
        return this.border;
    }

    public final void setBorder(org.netbeans.api.visual.border.Border border) {
        assert (border != null);
        boolean bl = this.border.getInsets().equals(border.getInsets());
        this.border = border;
        this.revalidate(bl);
    }

    public final void setBorder(Border border) {
        assert (border != null);
        this.setBorder(BorderFactory.createSwingBorder(this.scene, border));
    }

    public final Layout getLayout() {
        return this.layout;
    }

    public final void setLayout(Layout layout) {
        this.layout = layout;
        this.revalidate();
    }

    public final Dimension getMinimumSize() {
        return this.minimumSize != null ? new Dimension(this.minimumSize) : null;
    }

    public final void setMinimumSize(Dimension dimension) {
        if (GeomUtil.equals(this.minimumSize, dimension)) {
            return;
        }
        this.minimumSize = dimension;
        this.revalidate();
    }

    public final Dimension getMaximumSize() {
        return this.maximumSize != null ? new Dimension(this.maximumSize) : null;
    }

    public final void setMaximumSize(Dimension dimension) {
        if (GeomUtil.equals(this.maximumSize, dimension)) {
            return;
        }
        this.maximumSize = dimension;
        this.revalidate();
    }

    public final Dimension getPreferredSize() {
        return this.preferredSize != null ? new Dimension(this.preferredSize) : null;
    }

    public final void setPreferredSize(Dimension dimension) {
        if (GeomUtil.equals(this.preferredSize, dimension)) {
            return;
        }
        this.preferredSize = dimension;
        this.revalidate();
    }

    public final Point getPreferredLocation() {
        return this.preferredLocation != null ? new Point(this.preferredLocation) : null;
    }

    public final void setPreferredLocation(Point point) {
        if (GeomUtil.equals(this.preferredLocation, point)) {
            return;
        }
        this.preferredLocation = point;
        this.revalidate();
    }

    public final boolean isPreferredBoundsSet() {
        return this.preferredBounds != null;
    }

    public final Rectangle getPreferredBounds() {
        Rectangle rectangle;
        if (this.isPreferredBoundsSet()) {
            rectangle = new Rectangle(this.preferredBounds);
        } else {
            if (this.calculatedPreferredBounds == null) {
                this.calculatedPreferredBounds = this.calculatePreferredBounds();
            }
            rectangle = new Rectangle(this.calculatedPreferredBounds);
            if (this.preferredSize != null) {
                rectangle.width = this.preferredSize.width;
                rectangle.height = this.preferredSize.height;
            }
        }
        if (this.minimumSize != null) {
            if (rectangle.width < this.minimumSize.width) {
                rectangle.width = this.minimumSize.width;
            }
            if (rectangle.height < this.minimumSize.height) {
                rectangle.height = this.minimumSize.height;
            }
        }
        if (this.maximumSize != null) {
            if (rectangle.width > this.maximumSize.width) {
                rectangle.width = this.maximumSize.width;
            }
            if (rectangle.height > this.maximumSize.height) {
                rectangle.height = this.maximumSize.height;
            }
        }
        return rectangle;
    }

    private Rectangle calculatePreferredBounds() {
        Insets insets = this.border.getInsets();
        Rectangle rectangle = this.calculateClientArea();
        for (Widget widget : this.children) {
            if (!widget.isVisible()) continue;
            Point point = widget.getLocation();
            Rectangle rectangle2 = widget.getBounds();
            rectangle2.translate(point.x, point.y);
            rectangle.add(rectangle2);
        }
        rectangle.x -= insets.left;
        rectangle.y -= insets.top;
        rectangle.width += insets.left + insets.right;
        rectangle.height += insets.top + insets.bottom;
        return rectangle;
    }

    protected Rectangle calculateClientArea() {
        return new Rectangle();
    }

    public final void setPreferredBounds(Rectangle rectangle) {
        if (GeomUtil.equals(this.preferredBounds, rectangle)) {
            return;
        }
        this.preferredBounds = rectangle;
        this.revalidate();
    }

    public final boolean isCheckClipping() {
        return this.checkClipping;
    }

    public final void setCheckClipping(boolean bl) {
        this.checkClipping = bl;
        this.repaint();
    }

    protected Cursor getCursorAt(Point point) {
        return this.getCursor();
    }

    public final Cursor getCursor() {
        return this.cursor;
    }

    public final void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public final String getToolTipText() {
        return this.toolTipText;
    }

    public final void setToolTipText(String string) {
        this.toolTipText = string;
    }

    @Override
    public final AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new WidgetAccessibleContext(this);
        }
        return this.accessibleContext;
    }

    public final void setAccessibleContext(AccessibleContext accessibleContext) {
        this.accessibleContext = accessibleContext;
    }

    public final ObjectState getState() {
        return this.state;
    }

    public final void setState(ObjectState objectState) {
        ObjectState objectState2 = this.state;
        this.state = objectState;
        this.notifyStateChanged(objectState2, objectState);
    }

    protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
    }

    public final Point convertLocalToScene(Point point) {
        Point point2 = new Point(point);
        for (Widget widget = this; widget != null && widget != this.scene; widget = widget.getParentWidget()) {
            Point point3 = widget.getLocation();
            point2.x += point3.x;
            point2.y += point3.y;
        }
        return point2;
    }

    @NonNull
    public final Rectangle convertLocalToScene(@NonNull Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        for (Widget widget = this; widget != null && widget != this.scene; widget = widget.getParentWidget()) {
            Point point = widget.getLocation();
            rectangle2.x += point.x;
            rectangle2.y += point.y;
        }
        return rectangle2;
    }

    public final Point convertSceneToLocal(Point point) {
        Point point2 = new Point(point);
        for (Widget widget = this; widget != null && widget != this.scene; widget = widget.getParentWidget()) {
            Point point3 = widget.getLocation();
            point2.x -= point3.x;
            point2.y -= point3.y;
        }
        return point2;
    }

    public final Rectangle convertSceneToLocal(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        for (Widget widget = this; widget != null && widget != this.scene; widget = widget.getParentWidget()) {
            Point point = widget.getLocation();
            rectangle2.x -= point.x;
            rectangle2.y -= point.y;
        }
        return rectangle2;
    }

    public final Point getLocation() {
        return this.location != null ? new Point(this.location) : null;
    }

    @CheckForNull
    public final Rectangle getBounds() {
        return this.bounds != null ? new Rectangle(this.bounds) : null;
    }

    public final void resolveBounds(Point point, Rectangle rectangle) {
        this.location = point != null ? point : new Point();
        this.bounds = rectangle != null ? new Rectangle(rectangle) : new Rectangle(this.getPreferredBounds());
    }

    public final Rectangle getClientArea() {
        Rectangle rectangle = this.getBounds();
        if (rectangle == null) {
            return null;
        }
        Insets insets = this.getBorder().getInsets();
        return new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
    }

    public boolean isHitAt(Point point) {
        return this.visible && this.getBounds().contains(point);
    }

    public final void repaint() {
        this.scene.revalidateWidget(this);
    }

    public boolean isValidated() {
        return !this.requiresPartValidation;
    }

    public final void revalidate(boolean bl) {
        if (bl) {
            this.repaint();
        } else {
            this.revalidate();
        }
    }

    public final void revalidate() {
        this.requiresFullValidation = true;
        this.revalidateUptoRoot();
    }

    protected boolean isRepaintRequiredForRevalidating() {
        return true;
    }

    private void revalidateUptoRoot() {
        if (this.requiresPartValidation) {
            return;
        }
        if (this.isRepaintRequiredForRevalidating()) {
            this.repaint();
        }
        this.calculatedPreferredBounds = null;
        this.requiresPartValidation = true;
        if (this.parentWidget != null) {
            this.parentWidget.revalidateUptoRoot();
        }
        if (this.dependencies != null) {
            for (Dependency dependency : this.dependencies) {
                dependency.revalidateDependency();
            }
        }
    }

    void layout(boolean bl) {
        boolean bl2 = bl || this.requiresFullValidation;
        for (Widget object : this.children) {
            object.layout(bl2);
        }
        if (bl && this.dependencies != null) {
            for (Dependency dependency : this.dependencies) {
                dependency.revalidateDependency();
            }
        }
        if (bl2 || this.requiresPartValidation) {
            this.layout.layout(this);
            if (this.layout.requiresJustification(this)) {
                this.rejustify();
            }
        }
        this.requiresFullValidation = false;
        this.requiresPartValidation = false;
    }

    private void rejustify() {
        this.requiresFullJustification = true;
        this.rejustifyUptoRoot();
    }

    private void rejustifyUptoRoot() {
        if (this.requiresPartJustification) {
            return;
        }
        this.requiresPartJustification = true;
        if (this.parentWidget != null) {
            this.parentWidget.rejustifyUptoRoot();
        }
    }

    final void justify() {
        if (this.requiresFullJustification) {
            this.layout.justify(this);
            if (this.layout.requiresJustification(this)) {
                for (Widget widget : this.children) {
                    widget.rejustify();
                }
            }
        }
        for (Widget widget : this.children) {
            if (!widget.requiresPartJustification) continue;
            widget.justify();
        }
        this.requiresFullJustification = false;
        this.requiresPartJustification = false;
    }

    public final void paint() {
        Rectangle rectangle;
        if (!this.visible) {
            return;
        }
        assert (this.bounds != null) : "Scene.validate was not called after last change. Widget is not validated. See first Q/A at http://graph.netbeans.org/faq.html page.";
        Graphics2D graphics2D = this.scene.getGraphics();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(this.location.x, this.location.y);
        Shape shape = null;
        if (this.checkClipping) {
            shape = graphics2D.getClip();
            graphics2D.clip(this.bounds);
        }
        if (!this.checkClipping || (rectangle = graphics2D.getClipBounds()) == null || this.bounds.intersects(rectangle)) {
            if (this.opaque) {
                this.paintBackground();
            }
            this.paintBorder();
            if (this.checkClipping) {
                Insets insets = this.border.getInsets();
                graphics2D.clipRect(this.bounds.x + insets.left, this.bounds.y + insets.top, this.bounds.width - insets.left - insets.right, this.bounds.height - insets.top - insets.bottom);
            }
            this.paintWidget();
            this.paintChildren();
        }
        if (this.checkClipping) {
            graphics2D.setClip(shape);
        }
        graphics2D.setTransform(affineTransform);
    }

    protected void paintBackground() {
        Graphics2D graphics2D = this.scene.getGraphics();
        Insets insets = this.border.getInsets();
        graphics2D.setPaint(this.background);
        if (this.border.isOpaque()) {
            graphics2D.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        } else {
            graphics2D.fillRect(this.bounds.x + insets.left, this.bounds.y + insets.top, this.bounds.width - insets.left - insets.right, this.bounds.height - insets.top - insets.bottom);
        }
    }

    protected void paintBorder() {
        this.border.paint(this.getGraphics(), new Rectangle(this.bounds));
    }

    protected void paintWidget() {
    }

    protected void paintChildren() {
        if (this.checkClipping) {
            Rectangle rectangle = this.scene.getGraphics().getClipBounds();
            for (Widget widget : this.children) {
                Point point = widget.getLocation();
                Rectangle rectangle2 = widget.getBounds();
                rectangle2.translate(point.x, point.y);
                if (rectangle != null && !rectangle2.intersects(rectangle)) continue;
                widget.paint();
            }
        } else {
            for (Widget widget : this.children) {
                widget.paint();
            }
        }
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public ResourceTable getResourceTable() {
        ResourceTable resourceTable = this.resourceTable;
        if (resourceTable == null && this.getParentWidget() != null) {
            resourceTable = this.getParentWidget().getResourceTable();
        }
        return resourceTable;
    }

    private ResourceTable connectResourceTable() {
        if (this.resourceTable != null && this.getParentWidget() != null) {
            ResourceTable resourceTable = this.getParentWidget().getResourceTable();
            this.resourceTable.setParentTable(resourceTable);
        }
        return this.getResourceTable();
    }

    private void disconnectResourceTable() {
        if (this.resourceTable != null) {
            this.resourceTable.removeParent();
        }
    }

    public void setResourceTable(ResourceTable resourceTable) {
        this.resourceTable = resourceTable;
    }

    public static interface Dependency {
        public void revalidateDependency();
    }
}

