/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.impl;

import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.ProblemReportCreator;
import org.gradle.api.problems.internal.ProblemSummaryData;
import org.gradle.internal.buildoption.InternalOptions;
import org.gradle.internal.cc.impl.problems.BuildNameProvider;
import org.gradle.internal.cc.impl.problems.JsonSource;
import org.gradle.internal.cc.impl.problems.JsonWriter;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.configuration.problems.CommonReport;
import org.gradle.internal.configuration.problems.FailureDecorator;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.problems.failure.FailureFactory;
import org.gradle.problems.internal.impl.DefaultProblemsReportCreator;
import org.gradle.problems.internal.impl.DefaultProblemsReportCreatorKt;
import org.gradle.problems.internal.impl.JsonProblemWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0016H\u0016J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u001e\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u0015 \u0017*\r\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u00150\u00160\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/gradle/problems/internal/impl/DefaultProblemsReportCreator;", "Lorg/gradle/api/problems/internal/ProblemReportCreator;", "executorFactory", "Lorg/gradle/internal/concurrent/ExecutorFactory;", "temporaryFileProvider", "Lorg/gradle/api/internal/file/temp/TemporaryFileProvider;", "internalOptions", "Lorg/gradle/internal/buildoption/InternalOptions;", "startParameter", "Lorg/gradle/api/internal/StartParameterInternal;", "failureFactory", "Lorg/gradle/internal/problems/failure/FailureFactory;", "buildNameProvider", "Lorg/gradle/internal/cc/impl/problems/BuildNameProvider;", "<init>", "(Lorg/gradle/internal/concurrent/ExecutorFactory;Lorg/gradle/api/internal/file/temp/TemporaryFileProvider;Lorg/gradle/internal/buildoption/InternalOptions;Lorg/gradle/api/internal/StartParameterInternal;Lorg/gradle/internal/problems/failure/FailureFactory;Lorg/gradle/internal/cc/impl/problems/BuildNameProvider;)V", "report", "Lorg/gradle/internal/configuration/problems/CommonReport;", "taskNames", "", "", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "problemCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "failureDecorator", "Lorg/gradle/internal/configuration/problems/FailureDecorator;", "createReportFile", "", "reportDir", "Ljava/io/File;", "problemSummaries", "Lorg/gradle/api/problems/internal/ProblemSummaryData;", "addProblem", "problem", "Lorg/gradle/api/problems/internal/InternalProblem;", "problems"})
public final class DefaultProblemsReportCreator
implements ProblemReportCreator {
    @NotNull
    private final FailureFactory failureFactory;
    @NotNull
    private final BuildNameProvider buildNameProvider;
    @NotNull
    private final CommonReport report;
    @NotNull
    private final List<String> taskNames;
    @NotNull
    private final AtomicInteger problemCount;
    @NotNull
    private final FailureDecorator failureDecorator;

    public DefaultProblemsReportCreator(@NotNull ExecutorFactory executorFactory, @NotNull TemporaryFileProvider temporaryFileProvider, @NotNull InternalOptions internalOptions, @NotNull StartParameterInternal startParameter, @NotNull FailureFactory failureFactory, @NotNull BuildNameProvider buildNameProvider) {
        Intrinsics.checkNotNullParameter((Object)executorFactory, (String)"executorFactory");
        Intrinsics.checkNotNullParameter((Object)temporaryFileProvider, (String)"temporaryFileProvider");
        Intrinsics.checkNotNullParameter((Object)internalOptions, (String)"internalOptions");
        Intrinsics.checkNotNullParameter((Object)startParameter, (String)"startParameter");
        Intrinsics.checkNotNullParameter((Object)failureFactory, (String)"failureFactory");
        Intrinsics.checkNotNullParameter((Object)buildNameProvider, (String)"buildNameProvider");
        this.failureFactory = failureFactory;
        this.buildNameProvider = buildNameProvider;
        this.report = new CommonReport(executorFactory, temporaryFileProvider, internalOptions, "problems report", "problems-report", false);
        List list = startParameter.getTaskNames();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTaskNames(...)");
        this.taskNames = list;
        this.problemCount = new AtomicInteger(0);
        this.failureDecorator = new FailureDecorator();
    }

    public void createReportFile(@NotNull File reportDir, @NotNull List<? extends ProblemSummaryData> problemSummaries) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)reportDir, (String)"reportDir");
            Intrinsics.checkNotNullParameter(problemSummaries, (String)"problemSummaries");
            File file = this.report.writeReportFileTo(FilesKt.resolve((File)reportDir, (String)"reports/problems"), new JsonSource(this, problemSummaries){
                final /* synthetic */ DefaultProblemsReportCreator this$0;
                final /* synthetic */ List<ProblemSummaryData> $problemSummaries;
                {
                    this.this$0 = $receiver;
                    this.$problemSummaries = $problemSummaries;
                }

                public void writeToJson(JsonWriter jsonWriter) {
                    Intrinsics.checkNotNullParameter((Object)jsonWriter, (String)"jsonWriter");
                    DefaultProblemsReportCreator defaultProblemsReportCreator = this.this$0;
                    List<ProblemSummaryData> list = this.$problemSummaries;
                    JsonWriter $this$writeToJson_u24lambda_u246 = jsonWriter;
                    boolean bl = false;
                    $this$writeToJson_u24lambda_u246.property("problemsReport", () -> createReportFile.1.writeToJson$lambda$6$lambda$5($this$writeToJson_u24lambda_u246, defaultProblemsReportCreator, list));
                }

                private static final Unit writeToJson$lambda$6$lambda$5$lambda$4$lambda$3$lambda$2$lambda$1(JsonWriter $this_with, ProblemSummaryData $it) {
                    ProblemId problemId = $it.getProblemId();
                    Intrinsics.checkNotNullExpressionValue((Object)problemId, (String)"getProblemId(...)");
                    DefaultProblemsReportCreatorKt.problemId($this_with, problemId);
                    $this_with.property("count", $it.getCount());
                    return Unit.INSTANCE;
                }

                private static final Unit writeToJson$lambda$6$lambda$5$lambda$4$lambda$3$lambda$2(JsonWriter $this_with, ProblemSummaryData it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    $this_with.jsonObject(() -> createReportFile.1.writeToJson$lambda$6$lambda$5$lambda$4$lambda$3$lambda$2$lambda$1($this_with, it));
                    return Unit.INSTANCE;
                }

                private static final Unit writeToJson$lambda$6$lambda$5$lambda$4$lambda$3(JsonWriter $this_with, List $problemSummaries) {
                    $this_with.jsonList((Iterable)$problemSummaries, arg_0 -> createReportFile.1.writeToJson$lambda$6$lambda$5$lambda$4$lambda$3$lambda$2($this_with, arg_0));
                    return Unit.INSTANCE;
                }

                private static final Unit writeToJson$lambda$6$lambda$5$lambda$4(JsonWriter $this_with, DefaultProblemsReportCreator this$0, List $problemSummaries) {
                    $this_with.property("totalProblemCount", DefaultProblemsReportCreator.access$getProblemCount$p(this$0).get());
                    String string = DefaultProblemsReportCreator.access$getBuildNameProvider$p(this$0).buildName();
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        $this_with.property("buildName", it);
                    }
                    $this_with.property("requestedTasks", CollectionsKt.joinToString$default((Iterable)DefaultProblemsReportCreator.access$getTaskNames$p(this$0), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                    String string2 = new DocumentationRegistry().getDocumentationFor("reporting_problems");
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDocumentationFor(...)");
                    $this_with.property("documentationLink", string2);
                    $this_with.property("documentationLinkCaption", "Problem report");
                    $this_with.property("summaries", () -> createReportFile.1.writeToJson$lambda$6$lambda$5$lambda$4$lambda$3($this_with, $problemSummaries));
                    return Unit.INSTANCE;
                }

                private static final Unit writeToJson$lambda$6$lambda$5(JsonWriter $this_with, DefaultProblemsReportCreator this$0, List $problemSummaries) {
                    $this_with.jsonObject(() -> createReportFile.1.writeToJson$lambda$6$lambda$5$lambda$4($this_with, this$0, $problemSummaries));
                    return Unit.INSTANCE;
                }
            });
            if (file == null) break block0;
            File it = file;
            boolean bl = false;
            String url = new ConsoleRenderer().asClickableFileUrl(it);
            DefaultProblemsReportCreatorKt.getLogger().warn(System.lineSeparator() + "[Incubating] Problems report is available at: " + url);
        }
    }

    public void addProblem(@NotNull InternalProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        this.problemCount.incrementAndGet();
        this.report.onProblem((JsonSource)new JsonProblemWriter(problem, this.failureDecorator, this.failureFactory));
    }

    public static final /* synthetic */ AtomicInteger access$getProblemCount$p(DefaultProblemsReportCreator $this) {
        return $this.problemCount;
    }

    public static final /* synthetic */ BuildNameProvider access$getBuildNameProvider$p(DefaultProblemsReportCreator $this) {
        return $this.buildNameProvider;
    }

    public static final /* synthetic */ List access$getTaskNames$p(DefaultProblemsReportCreator $this) {
        return $this.taskNames;
    }
}

