/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirCatch;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.types.model.RigidTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCatchParameterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirTryExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTryExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirTryExpression;)V", "isProhibitedNothing", "", "coneType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkers"})
public final class FirCatchParameterChecker
extends FirExpressionChecker<FirTryExpression> {
    @NotNull
    public static final FirCatchParameterChecker INSTANCE = new FirCatchParameterChecker();

    private FirCatchParameterChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirTryExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        for (FirCatch catchEntry : expression2.getCatches()) {
            FirSession session2;
            KtSourceElement source;
            FirProperty catchParameter = catchEntry.getParameter();
            if (catchParameter.getSource() == null) continue;
            KtSourceElement ktSourceElement = catchParameter.getSource();
            if ((ktSourceElement != null ? FirHelpersKt.getDefaultValueForParameter(ktSourceElement) : null) != null) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCATCH_PARAMETER_WITH_DEFAULT_VALUE(), null, 8, null);
            }
            if (FirKeywordUtilsKt.getValOrVarKeyword(source) != null) {
                KtKeywordToken it;
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getVAL_OR_VAR_ON_CATCH_PARAMETER(), (Object)it, null, 16, null);
            }
            ConeKotlinType coneType = FirTypeUtilsKt.getConeType(catchParameter.getReturnTypeRef());
            if (coneType instanceof ConeTypeParameterType || coneType instanceof ConeDefinitelyNotNullType) {
                ConeInferenceContext $this$check_u24lambda_u241 = TypeComponentsKt.getTypeContext(context2.getSession());
                boolean bl = false;
                SimpleTypeMarker simpleTypeMarker = $this$check_u24lambda_u241.originalIfDefinitelyNotNullable((RigidTypeMarker)((Object)coneType));
                Object object = simpleTypeMarker instanceof ConeTypeParameterType ? (ConeTypeParameterType)simpleTypeMarker : null;
                boolean bl2 = object != null && (object = ((ConeTypeParameterType)object).getLookupTag()) != null && (object = ((ConeTypeParameterLookupTag)object).getTypeParameterSymbol()) != null ? ((FirTypeParameterSymbol)object).isReified() : false;
                boolean isReified = bl2;
                if (isReified) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getREIFIED_TYPE_IN_CATCH_CLAUSE(), null, 8, null);
                } else {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getTYPE_PARAMETER_IN_CATCH_CLAUSE(), null, 8, null);
                }
            }
            if (FirHelpersKt.isSubtypeOfThrowable(coneType, session2 = context2.getSession()) && !this.isProhibitedNothing(context2, coneType)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getTHROWABLE_TYPE_MISMATCH(), (Object)coneType, (Object)InferenceUtilsKt.isTypeMismatchDueToNullability(TypeComponentsKt.getTypeContext(context2.getSession()), coneType, session2.getBuiltinTypes().getThrowableType().getConeType()), null, 32, null);
        }
    }

    private final boolean isProhibitedNothing(CheckerContext context2, ConeKotlinType coneType) {
        return context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitNothingAsCatchParameter) && ConeBuiltinTypeUtilsKt.isNothing(coneType);
    }
}

