/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.BuildMetaInfo;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/build/CommonBuildMetaInfo;", "Lorg/jetbrains/kotlin/build/BuildMetaInfo;", "<init>", "()V", "checkIfPlatformSpecificCompilerArgumentWasChanged", "", "key", "", "currentValue", "previousValue", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "createPropertiesMapFromCompilerArguments", "", "args", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nCommonBuildMetaInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonBuildMetaInfo.kt\norg/jetbrains/kotlin/build/CommonBuildMetaInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n1#2:39\n*E\n"})
public final class CommonBuildMetaInfo
extends BuildMetaInfo {
    @Override
    @Nullable
    public Boolean checkIfPlatformSpecificCompilerArgumentWasChanged(@NotNull String key, @NotNull String currentValue, @NotNull String previousValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)currentValue, (String)"currentValue");
        Intrinsics.checkNotNullParameter((Object)previousValue, (String)"previousValue");
        if (Intrinsics.areEqual((Object)key, (Object)"METADATA_VERSION_STRING")) {
            int[] previousVersionIntArray;
            int[] currentVersionIntArray;
            if (!(currentVersionIntArray != null ? (currentVersionIntArray = BinaryVersion.Companion.parseVersionArray(currentValue)).length == 3 : false)) {
                return null;
            }
            int[] nArray = new int[]{currentVersionIntArray[0], currentVersionIntArray[1], currentVersionIntArray[2]};
            MetadataVersion currentVersion = new MetadataVersion(nArray);
            if (!(previousVersionIntArray != null ? (previousVersionIntArray = BinaryVersion.Companion.parseVersionArray(previousValue)).length == 3 : false)) {
                return null;
            }
            int[] nArray2 = new int[]{previousVersionIntArray[0], previousVersionIntArray[1], previousVersionIntArray[2]};
            MetadataVersion previousVersion = new MetadataVersion(nArray2);
            return Intrinsics.areEqual((Object)currentVersion, (Object)previousVersion);
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, String> createPropertiesMapFromCompilerArguments(@NotNull CommonCompilerArguments args) {
        MetadataVersion metadataVersion;
        int[] metadataVersionArray;
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Map resultMap = new LinkedHashMap();
        String string = args.getMetadataVersion();
        if (string != null) {
            String it = string;
            boolean bl = false;
            nArray = BinaryVersion.Companion.parseVersionArray(it);
        } else {
            nArray = null;
        }
        if (metadataVersionArray != null) {
            int[] p0 = metadataVersionArray = nArray;
            boolean bl = false;
            metadataVersion = new MetadataVersion(p0);
        } else {
            metadataVersion = MetadataVersion.INSTANCE;
        }
        MetadataVersion metadataVersion2 = metadataVersion;
        String metadataVersionString = metadataVersion2.toString();
        resultMap.put("METADATA_VERSION_STRING", metadataVersionString);
        return MapsKt.plus(super.createPropertiesMapFromCompilerArguments(args), (Map)resultMap);
    }
}

