/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactfx.EventStream;
import org.reactfx.EventStreamBase;
import org.reactfx.Subscription;

class AccumulateUntilLaterStream<T, A>
extends EventStreamBase<T> {
    private final EventStream<T> source;
    private final Function<? super T, ? extends A> initialTransformation;
    private final BiFunction<? super A, ? super T, ? extends A> accumulation;
    private final Function<? super A, List<T>> deconstruction;
    private final Executor eventThreadExecutor;
    private boolean hasValue = false;
    private A accum = null;

    public AccumulateUntilLaterStream(EventStream<T> source, Function<? super T, ? extends A> initialTransformation, BiFunction<? super A, ? super T, ? extends A> accumulation, Function<? super A, List<T>> deconstruction, Executor eventThreadExecutor) {
        this.source = source;
        this.initialTransformation = initialTransformation;
        this.accumulation = accumulation;
        this.deconstruction = deconstruction;
        this.eventThreadExecutor = eventThreadExecutor;
    }

    @Override
    protected Subscription observeInputs() {
        return this.source.subscribe(this::handleEvent);
    }

    private void handleEvent(T event) {
        if (this.hasValue) {
            this.accum = this.accumulation.apply(this.accum, event);
        } else {
            this.accum = this.initialTransformation.apply(event);
            this.hasValue = true;
            this.eventThreadExecutor.execute(this::emitAccum);
        }
    }

    private void emitAccum() {
        assert (this.hasValue);
        this.hasValue = false;
        List<T> toEmit = this.deconstruction.apply(this.accum);
        this.accum = null;
        for (T t : toEmit) {
            this.emit(t);
        }
    }
}

