/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.util;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jabref.model.TreeNode;

public class TreeCollector<T>
implements Collector<T, ObservableList<T>, ObservableList<T>> {
    private Function<T, List<T>> getChildren;
    private BiConsumer<T, T> addChild;
    private BiPredicate<T, T> equivalence;

    private TreeCollector(Function<T, List<T>> getChildren, BiConsumer<T, T> addChild, BiPredicate<T, T> equivalence) {
        this.getChildren = getChildren;
        this.addChild = addChild;
        this.equivalence = equivalence;
    }

    public static <T extends TreeNode<T>> TreeCollector<T> mergeIntoTree(BiPredicate<T, T> equivalence) {
        return new TreeCollector<TreeNode>(TreeNode::getChildren, (parent, child) -> child.moveTo(parent), equivalence);
    }

    @Override
    public Supplier<ObservableList<T>> supplier() {
        return FXCollections::observableArrayList;
    }

    @Override
    public BiConsumer<ObservableList<T>, T> accumulator() {
        return (alreadyProcessed, newItem) -> {
            Optional<Object> sameItemInTree = alreadyProcessed.stream().filter(item -> this.equivalence.test(item, newItem)).findFirst();
            if (sameItemInTree.isPresent()) {
                for (Object child : new ArrayList(this.getChildren.apply(newItem))) {
                    this.merge(sameItemInTree.get(), child);
                }
            } else {
                alreadyProcessed.add(newItem);
            }
        };
    }

    private void merge(T target, T node) {
        Optional<Object> sameItemInTree = this.getChildren.apply(target).stream().filter(item -> this.equivalence.test(item, node)).findFirst();
        if (sameItemInTree.isPresent()) {
            for (Object child : new ArrayList(this.getChildren.apply(node))) {
                this.merge(sameItemInTree.get(), child);
            }
        } else {
            this.addChild.accept(target, node);
        }
    }

    @Override
    public BinaryOperator<ObservableList<T>> combiner() {
        return (list1, list2) -> {
            for (Object item : list2) {
                this.accumulator().accept((ObservableList<ObservableList>)list1, (ObservableList)item);
            }
            return list1;
        };
    }

    @Override
    public Function<ObservableList<T>, ObservableList<T>> finisher() {
        return i -> i;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
    }
}

