/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.metadata.FileDirectoryPreferences;

public class FileHelper {
    public static Optional<String> getFileExtension(Path file) {
        return FileHelper.getFileExtension(file.toString());
    }

    public static Optional<String> getFileExtension(String fileName) {
        int dotPosition = fileName.lastIndexOf(46);
        if (dotPosition > 0 && dotPosition < fileName.length() - 1) {
            return Optional.of(fileName.substring(dotPosition + 1).trim().toLowerCase(Locale.ROOT));
        }
        return Optional.empty();
    }

    public static Optional<Path> expandFilename(BibDatabaseContext databaseContext, String name, FileDirectoryPreferences fileDirectoryPreferences) {
        Optional<String> extension = FileHelper.getFileExtension(name);
        List<String> directories = databaseContext.getFileDirectories(extension.orElse(null), fileDirectoryPreferences);
        List<String> fileDir = databaseContext.getFileDirectories(fileDirectoryPreferences);
        ArrayList<String> searchDirectories = new ArrayList<String>();
        for (String dir : directories) {
            if (searchDirectories.contains(dir)) continue;
            searchDirectories.add(dir);
        }
        for (String aFileDir : fileDir) {
            if (searchDirectories.contains(aFileDir)) continue;
            searchDirectories.add(aFileDir);
        }
        return FileHelper.expandFilename(name, searchDirectories);
    }

    @Deprecated
    public static Optional<Path> expandFilename(String name, List<String> directories) {
        for (String dir : directories) {
            Optional<Path> result = FileHelper.expandFilename(name, Paths.get(dir, new String[0]));
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public static Optional<Path> expandFilenameAsPath(String name, List<Path> directories) {
        for (Path directory : directories) {
            Optional<Path> result = FileHelper.expandFilename(name, directory);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    private static Optional<Path> expandFilename(String filename, Path directory) {
        Objects.requireNonNull(filename);
        Objects.requireNonNull(directory);
        Path file = Paths.get(filename, new String[0]);
        if (filename.isEmpty()) {
            return Optional.of(directory);
        }
        Path resolvedFile = directory.resolve(file);
        if (Files.exists(resolvedFile, new LinkOption[0])) {
            return Optional.of(resolvedFile);
        }
        return Optional.empty();
    }
}

