/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.metadata;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;

public class FileDirectoryPreferences {
    public static final String DIR_SUFFIX = "Directory";
    private final String user;
    private final Map<String, String> fieldFileDirectories;
    private final boolean bibLocationAsPrimary;

    public FileDirectoryPreferences(String user, Map<String, String> fieldFileDirectories, boolean bibLocationAsPrimary) {
        this.user = user;
        this.fieldFileDirectories = fieldFileDirectories;
        this.bibLocationAsPrimary = bibLocationAsPrimary;
    }

    public String getUser() {
        return this.user;
    }

    public Optional<Path> getFileDirectory(String field2) {
        try {
            String value = this.fieldFileDirectories.get(field2);
            if (value != null && !value.isEmpty()) {
                Path path = Paths.get(value, new String[0]);
                return Optional.of(path);
            }
            return Optional.empty();
        }
        catch (InvalidPathException ex) {
            return Optional.empty();
        }
    }

    public Optional<Path> getFileDirectory() {
        return this.getFileDirectory("file");
    }

    public boolean isBibLocationAsPrimary() {
        return this.bibLocationAsPrimary;
    }
}

