/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jabref.model.entry.BibtexEntryType;
import org.jabref.model.entry.EntryType;
import org.jabref.model.entry.FieldName;

public class IEEETranEntryTypes {
    public static final EntryType ELECTRONIC = new BibtexEntryType(){
        {
            this.addAllOptional("author", "month", "year", "title", "language", "howpublished", "organization", "address", "note", "url");
        }

        @Override
        public String getName() {
            return "Electronic";
        }
    };
    public static final EntryType IEEETRANBSTCTL = new BibtexEntryType(){
        {
            this.addAllOptional("ctluse_article_number", "ctluse_paper", "ctluse_forced_etal", "ctluse_url", "ctlmax_names_forced_etal", "ctlnames_show_etal", "ctluse_alt_spacing", "ctlalt_stretch_factor", "ctldash_repeated_names", "ctlname_format_string", "ctlname_latex_cmd", "ctlname_url_prefix");
        }

        @Override
        public String getName() {
            return "IEEEtranBSTCTL";
        }
    };
    public static final EntryType PERIODICAL = new BibtexEntryType(){
        {
            this.addAllRequired("title", "year");
            this.addAllOptional("editor", "language", "series", "volume", "number", "organization", "month", "note", "url");
        }

        @Override
        public String getName() {
            return "Periodical";
        }
    };
    public static final EntryType PATENT = new BibtexEntryType(){
        {
            this.addAllRequired("nationality", "number", FieldName.orFields("year", "yearfiled"));
            this.addAllOptional("author", "title", "language", "assignee", "address", "type", "number", "day", "dayfiled", "month", "monthfiled", "note", "url");
        }

        @Override
        public String getName() {
            return "Patent";
        }
    };
    public static final EntryType STANDARD = new BibtexEntryType(){
        {
            this.addAllRequired("title", FieldName.orFields("organization", "institution"));
            this.addAllOptional("author", "language", "howpublished", "type", "number", "revision", "address", "month", "year", "note", "url");
        }

        @Override
        public String getName() {
            return "Standard";
        }
    };
    public static final List<EntryType> ALL = Arrays.asList(ELECTRONIC, IEEETRANBSTCTL, PERIODICAL, PATENT, STANDARD);

    private IEEETranEntryTypes() {
    }

    public static Optional<EntryType> getType(String name) {
        return ALL.stream().filter(e -> e.getName().equalsIgnoreCase(name)).findFirst();
    }
}

