/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.util.EnumSet;
import java.util.Set;
import org.jabref.model.entry.FieldProperty;

public class BibtexSingleField {
    public static final int DEFAULT_FIELD_LENGTH = 100;
    private String name;
    private final Set<FieldType> fieldTypes = EnumSet.of(FieldType.DISPLAYABLE, FieldType.WRITEABLE);
    private final int length;
    private Set<FieldProperty> properties = EnumSet.noneOf(FieldProperty.class);

    public BibtexSingleField(String fieldName) {
        this(fieldName, true, 100);
    }

    public BibtexSingleField(String fieldName, boolean standardField) {
        this(fieldName, standardField, 100);
    }

    public BibtexSingleField(String fieldName, boolean standardField, int length) {
        this.name = fieldName;
        this.length = length;
        if (standardField) {
            this.fieldTypes.add(FieldType.STANDARD);
        }
    }

    public boolean isStandard() {
        return this.fieldTypes.contains((Object)FieldType.STANDARD);
    }

    public void setPrivate() {
        this.fieldTypes.add(FieldType.PRIVATE);
    }

    public void setPublic() {
        this.fieldTypes.remove((Object)FieldType.PRIVATE);
    }

    public boolean isPrivate() {
        return this.fieldTypes.contains((Object)FieldType.PRIVATE);
    }

    public void setDisplayable(boolean value) {
        if (value) {
            this.fieldTypes.add(FieldType.DISPLAYABLE);
        } else {
            this.fieldTypes.remove((Object)FieldType.DISPLAYABLE);
        }
    }

    public boolean isDisplayable() {
        return this.fieldTypes.contains((Object)FieldType.DISPLAYABLE);
    }

    public void setWriteable(boolean value) {
        if (value) {
            this.fieldTypes.add(FieldType.WRITEABLE);
        } else {
            this.fieldTypes.remove((Object)FieldType.WRITEABLE);
        }
    }

    public boolean isWriteable() {
        return this.fieldTypes.contains((Object)FieldType.WRITEABLE);
    }

    public BibtexSingleField withProperties(FieldProperty first, FieldProperty ... rest) {
        this.properties = EnumSet.of(first, rest);
        return this;
    }

    public Set<FieldProperty> getProperties() {
        return this.properties;
    }

    public int getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public BibtexSingleField setNumeric() {
        this.properties.add(FieldProperty.NUMERIC);
        return this;
    }

    public boolean isNumeric() {
        return this.properties.contains((Object)FieldProperty.NUMERIC);
    }

    public void setName(String fieldName) {
        this.name = fieldName;
    }

    private static enum FieldType {
        STANDARD,
        PRIVATE,
        DISPLAYABLE,
        WRITEABLE;

    }
}

