/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jabref.model.entry.EntryType;

public abstract class BiblatexEntryType
implements EntryType {
    private final Set<String> requiredFields = new LinkedHashSet<String>();
    private final Set<String> optionalFields = new LinkedHashSet<String>();

    @Override
    public Set<String> getOptionalFields() {
        return Collections.unmodifiableSet(this.optionalFields);
    }

    @Override
    public Set<String> getRequiredFields() {
        return Collections.unmodifiableSet(this.requiredFields);
    }

    void addAllOptional(String ... fieldNames) {
        this.optionalFields.addAll(Arrays.asList(fieldNames));
    }

    void addAllRequired(String ... fieldNames) {
        this.requiredFields.addAll(Arrays.asList(fieldNames));
    }

    @Override
    public Set<String> getPrimaryOptionalFields() {
        return this.getOptionalFields();
    }

    @Override
    public Set<String> getSecondaryOptionalFields() {
        return this.getOptionalFields().stream().filter(field2 -> !this.isPrimary((String)field2)).collect(Collectors.toSet());
    }

    private boolean isPrimary(String field2) {
        return this.getPrimaryOptionalFields().contains(field2);
    }

    @Override
    public int compareTo(EntryType o) {
        return this.getName().compareTo(o.getName());
    }
}

