/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.database;

import java.util.Locale;
import java.util.stream.Stream;
import org.jabref.model.EntryTypes;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;

public class BibDatabaseModeDetection {
    private BibDatabaseModeDetection() {
    }

    public static BibDatabaseMode inferMode(BibDatabase database) {
        Stream<String> entryTypes = database.getEntries().stream().map(BibEntry::getType);
        if (entryTypes.anyMatch(type -> EntryTypes.isExclusiveBiblatex(type.toLowerCase(Locale.ENGLISH)))) {
            return BibDatabaseMode.BIBLATEX;
        }
        return BibDatabaseMode.BIBTEX;
    }
}

