/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.migrations;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeReviewIntoCommentMigration {
    public static final Logger LOGGER = LoggerFactory.getLogger(MergeReviewIntoCommentMigration.class);

    public static boolean needsMigration(ParserResult parserResult) {
        return parserResult.getDatabase().getEntries().stream().anyMatch(bibEntry -> bibEntry.getField("review").isPresent());
    }

    public void performMigration(ParserResult parserResult) {
        ObservableList<BibEntry> entries = Objects.requireNonNull(parserResult).getDatabase().getEntries();
        entries.stream().filter(MergeReviewIntoCommentMigration::hasReviewField).filter(entry -> !MergeReviewIntoCommentMigration.hasCommentField(entry)).forEach(entry -> this.migrate((BibEntry)entry, parserResult));
    }

    public static List<BibEntry> collectConflicts(ParserResult parserResult) {
        ObservableList<BibEntry> entries = Objects.requireNonNull(parserResult).getDatabase().getEntries();
        return entries.stream().filter(MergeReviewIntoCommentMigration::hasReviewField).filter(MergeReviewIntoCommentMigration::hasCommentField).collect(Collectors.toList());
    }

    public void performConflictingMigration(ParserResult parserResult) {
        MergeReviewIntoCommentMigration.collectConflicts(parserResult).forEach(entry -> this.migrate((BibEntry)entry, parserResult));
    }

    private String mergeCommentFieldIfPresent(BibEntry entry, String review) {
        if (entry.getField("comment").isPresent()) {
            LOGGER.info(String.format("Both Comment and Review fields are present in %s! Merging them into the comment field.", entry.getAuthorTitleYear(150)));
            return String.format("%s\n%s:\n%s", entry.getField("comment").get().trim(), Localization.lang("Review", new String[0]), review.trim());
        }
        return review;
    }

    private static boolean hasCommentField(BibEntry entry) {
        return entry.getField("comment").isPresent();
    }

    private static boolean hasReviewField(BibEntry entry) {
        return entry.getField("review").isPresent();
    }

    private void migrate(BibEntry entry, ParserResult parserResult) {
        if (MergeReviewIntoCommentMigration.hasReviewField(entry)) {
            this.updateFields(entry, this.mergeCommentFieldIfPresent(entry, entry.getField("review").get()));
            parserResult.wasChangedOnMigration();
        }
    }

    private void updateFields(BibEntry entry, String review) {
        entry.setField("comment", review);
        entry.clearField("review");
    }
}

