/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util.strings;

import difflib.Delta;
import difflib.DiffUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DiffHighlighting {
    public static final String HTML_START = "<html><body>";
    public static final String HTML_END = "</body></html>";
    private static final String ADDITION_START = "<span class=add>";
    private static final String REMOVAL_START = "<span class=del>";
    private static final String CHANGE_START = "<span class=change>";
    private static final String TAG_END = "</span>";

    private DiffHighlighting() {
    }

    public static String generateDiffHighlighting(String baseString, String modifiedString, String separator) {
        Objects.requireNonNull(separator);
        if (baseString != null && modifiedString != null) {
            ArrayList<String> stringList = new ArrayList<String>(Arrays.asList(baseString.split(separator)));
            ArrayList<Delta<String>> deltaList = new ArrayList<Delta<String>>(DiffUtils.diff(stringList, Arrays.asList(modifiedString.split(separator))).getDeltas());
            Collections.reverse(deltaList);
            for (Delta delta : deltaList) {
                int startPos = delta.getOriginal().getPosition();
                List lines = delta.getOriginal().getLines();
                int offset = 0;
                switch (delta.getType()) {
                    case CHANGE: {
                        for (String line : lines) {
                            stringList.set(startPos + offset, (offset == 0 ? REMOVAL_START : "") + line);
                            ++offset;
                        }
                        stringList.set(startPos + offset - 1, (String)stringList.get(startPos + offset - 1) + TAG_END + separator + ADDITION_START + String.join((CharSequence)separator, delta.getRevised().getLines()) + TAG_END);
                        break;
                    }
                    case DELETE: {
                        for (String line : lines) {
                            stringList.set(startPos + offset, (offset == 0 ? REMOVAL_START : "") + line);
                            ++offset;
                        }
                        stringList.set(startPos + offset - 1, (String)stringList.get(startPos + offset - 1) + TAG_END);
                        break;
                    }
                    case INSERT: {
                        stringList.add(delta.getOriginal().getPosition(), ADDITION_START + String.join((CharSequence)separator, delta.getRevised().getLines()) + TAG_END);
                        break;
                    }
                }
            }
            return String.join((CharSequence)separator, stringList);
        }
        return modifiedString;
    }

    public static String generateSymmetricHighlighting(String baseString, String modifiedString, String separator) {
        if (baseString != null && modifiedString != null) {
            ArrayList<String> stringList = new ArrayList<String>(Arrays.asList(baseString.split(separator)));
            ArrayList<Delta<String>> deltaList = new ArrayList<Delta<String>>(DiffUtils.diff(stringList, new ArrayList<String>(Arrays.asList(modifiedString.split(separator)))).getDeltas());
            Collections.reverse(deltaList);
            for (Delta delta : deltaList) {
                int startPos = delta.getOriginal().getPosition();
                List lines = delta.getOriginal().getLines();
                int offset = 0;
                switch (delta.getType()) {
                    case CHANGE: {
                        for (String line : lines) {
                            stringList.set(startPos + offset, (offset == 0 ? CHANGE_START : "") + line);
                            ++offset;
                        }
                        stringList.set(startPos + offset - 1, (String)stringList.get(startPos + offset - 1) + TAG_END);
                        break;
                    }
                    case DELETE: {
                        for (String line : lines) {
                            stringList.set(startPos + offset, (offset == 0 ? ADDITION_START : "") + line);
                            ++offset;
                        }
                        stringList.set(startPos + offset - 1, (String)stringList.get(startPos + offset - 1) + TAG_END);
                        break;
                    }
                    case INSERT: {
                        break;
                    }
                }
            }
            return String.join((CharSequence)separator, stringList);
        }
        return modifiedString;
    }
}

