/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.preferences;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class TimestampPreferences {
    private final boolean useTimestamps;
    private final boolean useModifiedTimestamp;
    private final String timestampField;
    private final String timestampFormat;
    private final boolean overwriteTimestamp;

    public TimestampPreferences(boolean useTimestamps, boolean useModifiedTimestamp, String timestampField, String timestampFormat, boolean overwriteTimestamp) {
        this.useTimestamps = useTimestamps;
        this.useModifiedTimestamp = useModifiedTimestamp;
        this.timestampField = timestampField;
        this.timestampFormat = timestampFormat;
        this.overwriteTimestamp = overwriteTimestamp;
    }

    public boolean includeCreatedTimestamp() {
        return this.useTimestamps;
    }

    public boolean includeModifiedTimestamp() {
        return this.useModifiedTimestamp;
    }

    public String getTimestampField() {
        return this.timestampField;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public boolean overwriteTimestamp() {
        return this.overwriteTimestamp;
    }

    public boolean includeTimestamps() {
        return this.useTimestamps && this.useModifiedTimestamp;
    }

    public String now() {
        String timeStampFormat = this.timestampFormat;
        return DateTimeFormatter.ofPattern(timeStampFormat).format(LocalDateTime.now());
    }
}

