/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.jabref.logic.layout.Layout;
import org.jabref.logic.layout.LayoutFormatter;
import org.jabref.logic.layout.LayoutFormatterPreferences;
import org.jabref.logic.layout.LayoutHelper;
import org.jabref.logic.openoffice.OOPreFormatter;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.FieldName;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OOBibStyle
implements Comparable<OOBibStyle> {
    public static final String ITALIC_ET_AL = "ItalicEtAl";
    public static final String MULTI_CITE_CHRONOLOGICAL = "MultiCiteChronological";
    public static final String MINIMUM_GROUPING_COUNT = "MinimumGroupingCount";
    public static final String ET_AL_STRING = "EtAlString";
    public static final String MAX_AUTHORS_FIRST = "MaxAuthorsFirst";
    public static final String REFERENCE_HEADER_PARAGRAPH_FORMAT = "ReferenceHeaderParagraphFormat";
    public static final String REFERENCE_PARAGRAPH_FORMAT = "ReferenceParagraphFormat";
    public static final String TITLE = "Title";
    public static final String UNDEFINED_CITATION_MARKER = "??";
    private static final Pattern NUM_PATTERN = Pattern.compile("-?\\d+");
    private static final String LAYOUT_MRK = "LAYOUT";
    private static final String PROPERTIES_MARK = "PROPERTIES";
    private static final String CITATION_MARK = "CITATION";
    private static final String NAME_MARK = "NAME";
    private static final String JOURNALS_MARK = "JOURNALS";
    private static final String DEFAULT_MARK = "default";
    private static final String BRACKET_AFTER_IN_LIST = "BracketAfterInList";
    private static final String BRACKET_BEFORE_IN_LIST = "BracketBeforeInList";
    private static final String UNIQUEFIER_SEPARATOR = "UniquefierSeparator";
    private static final String BIBTEX_KEY_CITATIONS = "BibTeXKeyCitations";
    private static final String SUBSCRIPT_CITATIONS = "SubscriptCitations";
    private static final String SUPERSCRIPT_CITATIONS = "SuperscriptCitations";
    private static final String BOLD_CITATIONS = "BoldCitations";
    private static final String ITALIC_CITATIONS = "ItalicCitations";
    private static final String CITATION_CHARACTER_FORMAT = "CitationCharacterFormat";
    private static final String FORMAT_CITATIONS = "FormatCitations";
    private static final String GROUPED_NUMBERS_SEPARATOR = "GroupedNumbersSeparator";
    private static final String PAGE_INFO_SEPARATOR = "PageInfoSeparator";
    private static final String CITATION_SEPARATOR = "CitationSeparator";
    private static final String IN_TEXT_YEAR_SEPARATOR = "InTextYearSeparator";
    private static final String MAX_AUTHORS = "MaxAuthors";
    private static final String YEAR_FIELD = "YearField";
    private static final String AUTHOR_FIELD = "AuthorField";
    private static final String BRACKET_AFTER = "BracketAfter";
    private static final String BRACKET_BEFORE = "BracketBefore";
    private static final String IS_NUMBER_ENTRIES = "IsNumberEntries";
    private static final String IS_SORT_BY_POSITION = "IsSortByPosition";
    private static final String SORT_ALGORITHM = "SortAlgorithm";
    private static final String OXFORD_COMMA = "OxfordComma";
    private static final String YEAR_SEPARATOR = "YearSeparator";
    private static final String AUTHOR_LAST_SEPARATOR_IN_TEXT = "AuthorLastSeparatorInText";
    private static final String AUTHOR_LAST_SEPARATOR = "AuthorLastSeparator";
    private static final String AUTHOR_SEPARATOR = "AuthorSeparator";
    private static final Pattern QUOTED = Pattern.compile("\".*\"");
    private static final Logger LOGGER = LoggerFactory.getLogger(OOBibStyle.class);
    private String name = "";
    private final SortedSet<String> journals = new TreeSet<String>();
    private final LayoutFormatter fieldFormatter = new OOPreFormatter();
    private Layout defaultBibLayout;
    private final Map<String, Layout> bibLayout = new HashMap<String, Layout>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<String, Object> citProperties = new HashMap<String, Object>();
    private boolean valid;
    private final boolean fromResource;
    private final String path;
    private File styleFile;
    private final Charset encoding;
    private long styleFileModificationTime = Long.MIN_VALUE;
    private String localCopy;
    private final LayoutFormatterPreferences prefs;

    public OOBibStyle(File styleFile, LayoutFormatterPreferences prefs, Charset encoding) throws IOException {
        this.prefs = Objects.requireNonNull(prefs);
        this.styleFile = Objects.requireNonNull(styleFile);
        this.encoding = Objects.requireNonNull(encoding);
        this.setDefaultProperties();
        this.reload();
        this.fromResource = false;
        this.path = styleFile.getPath();
    }

    public OOBibStyle(String resourcePath, LayoutFormatterPreferences prefs) throws IOException {
        this.prefs = Objects.requireNonNull(prefs);
        Objects.requireNonNull(resourcePath);
        this.encoding = StandardCharsets.UTF_8;
        this.setDefaultProperties();
        this.initialize(OOBibStyle.class.getResourceAsStream(resourcePath));
        this.fromResource = true;
        this.path = resourcePath;
    }

    private void setDefaultProperties() {
        this.properties.put(TITLE, "Bibliography");
        this.properties.put(SORT_ALGORITHM, "alphanumeric");
        this.properties.put(IS_SORT_BY_POSITION, Boolean.FALSE);
        this.properties.put(IS_NUMBER_ENTRIES, Boolean.FALSE);
        this.properties.put(BRACKET_BEFORE, "[");
        this.properties.put(BRACKET_AFTER, "]");
        this.properties.put(REFERENCE_PARAGRAPH_FORMAT, "Default");
        this.properties.put(REFERENCE_HEADER_PARAGRAPH_FORMAT, "Heading 1");
        this.citProperties.put(AUTHOR_FIELD, FieldName.orFields("author", "editor"));
        this.citProperties.put(YEAR_FIELD, "year");
        this.citProperties.put(MAX_AUTHORS, 3);
        this.citProperties.put(MAX_AUTHORS_FIRST, -1);
        this.citProperties.put(AUTHOR_SEPARATOR, ", ");
        this.citProperties.put(AUTHOR_LAST_SEPARATOR, " & ");
        this.citProperties.put(AUTHOR_LAST_SEPARATOR_IN_TEXT, null);
        this.citProperties.put(ET_AL_STRING, " et al.");
        this.citProperties.put(YEAR_SEPARATOR, ", ");
        this.citProperties.put(IN_TEXT_YEAR_SEPARATOR, " ");
        this.citProperties.put(BRACKET_BEFORE, "(");
        this.citProperties.put(BRACKET_AFTER, ")");
        this.citProperties.put(CITATION_SEPARATOR, "; ");
        this.citProperties.put(PAGE_INFO_SEPARATOR, "; ");
        this.citProperties.put(GROUPED_NUMBERS_SEPARATOR, "-");
        this.citProperties.put(MINIMUM_GROUPING_COUNT, 3);
        this.citProperties.put(FORMAT_CITATIONS, Boolean.FALSE);
        this.citProperties.put(CITATION_CHARACTER_FORMAT, "Default");
        this.citProperties.put(ITALIC_CITATIONS, Boolean.FALSE);
        this.citProperties.put(BOLD_CITATIONS, Boolean.FALSE);
        this.citProperties.put(SUPERSCRIPT_CITATIONS, Boolean.FALSE);
        this.citProperties.put(SUBSCRIPT_CITATIONS, Boolean.FALSE);
        this.citProperties.put(MULTI_CITE_CHRONOLOGICAL, Boolean.TRUE);
        this.citProperties.put(BIBTEX_KEY_CITATIONS, Boolean.FALSE);
        this.citProperties.put(ITALIC_ET_AL, Boolean.FALSE);
        this.citProperties.put(OXFORD_COMMA, "");
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public File getFile() {
        return this.styleFile;
    }

    public Set<String> getJournals() {
        return Collections.unmodifiableSet(this.journals);
    }

    private void initialize(InputStream stream) throws IOException {
        Objects.requireNonNull(stream);
        try (InputStreamReader reader = new InputStreamReader(stream, this.encoding);){
            this.readFormatFile(reader);
        }
    }

    public void ensureUpToDate() throws IOException {
        if (!this.isUpToDate()) {
            this.reload();
        }
    }

    private void reload() throws IOException {
        if (this.styleFile != null) {
            this.styleFileModificationTime = this.styleFile.lastModified();
            try (FileInputStream stream = new FileInputStream(this.styleFile);){
                this.initialize(stream);
            }
        }
    }

    private boolean isUpToDate() {
        if (this.styleFile == null) {
            return true;
        }
        return this.styleFile.lastModified() == this.styleFileModificationTime;
    }

    private void readFormatFile(Reader in) throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = in.read()) != -1) {
            sb.append((char)c);
        }
        this.localCopy = sb.toString();
        String[] lines = sb.toString().split("\n");
        BibStyleMode mode = BibStyleMode.NONE;
        block22: for (String line1 : lines) {
            String line = line1;
            if (!line.isEmpty() && line.charAt(line.length() - 1) == '\r') {
                line = line.substring(0, line.length() - 1);
            }
            if (line.trim().isEmpty() || line.charAt(0) == '#') continue;
            switch (line) {
                case "NAME": {
                    mode = BibStyleMode.NAME;
                    continue block22;
                }
                case "LAYOUT": {
                    mode = BibStyleMode.LAYOUT;
                    continue block22;
                }
                case "PROPERTIES": {
                    mode = BibStyleMode.PROPERTIES;
                    continue block22;
                }
                case "CITATION": {
                    mode = BibStyleMode.CITATION;
                    continue block22;
                }
                case "JOURNALS": {
                    mode = BibStyleMode.JOURNALS;
                    continue block22;
                }
                default: {
                    switch (mode) {
                        case NAME: {
                            if (line.trim().isEmpty()) continue block22;
                            this.name = line.trim();
                            continue block22;
                        }
                        case LAYOUT: {
                            this.handleStructureLine(line);
                            continue block22;
                        }
                        case PROPERTIES: {
                            this.handlePropertiesLine(line, this.properties);
                            continue block22;
                        }
                        case CITATION: {
                            this.handlePropertiesLine(line, this.citProperties);
                            continue block22;
                        }
                        case JOURNALS: {
                            this.handleJournalsLine(line);
                            continue block22;
                        }
                    }
                }
            }
        }
        if (mode != BibStyleMode.NONE) {
            this.valid = true;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    private void handleStructureLine(String line) {
        int index = line.indexOf(61);
        if (index > 0 && index < line.length() - 1) {
            String formatString = line.substring(index + 1);
            boolean setDefault = line.substring(0, index).equals(DEFAULT_MARK);
            String type = line.substring(0, index);
            try {
                Layout layout = new LayoutHelper(new StringReader(formatString), this.prefs).getLayoutFromText();
                if (setDefault) {
                    this.defaultBibLayout = layout;
                } else {
                    this.bibLayout.put(type.toLowerCase(Locale.ENGLISH), layout);
                }
            }
            catch (IOException ex) {
                LOGGER.warn("Cannot parse bibliography structure", ex);
            }
        }
    }

    private void handlePropertiesLine(String line, Map<String, Object> map) {
        int index = line.indexOf(61);
        if (index > 0 && index <= line.length() - 1) {
            String propertyName = line.substring(0, index).trim();
            String value = line.substring(index + 1);
            if (value.trim().length() > 1 && QUOTED.matcher(value.trim()).matches()) {
                value = value.trim().substring(1, value.trim().length() - 1);
            }
            Object toSet = value;
            if (NUM_PATTERN.matcher(value).matches()) {
                toSet = Integer.parseInt(value);
            } else if ("true".equalsIgnoreCase(value.trim())) {
                toSet = Boolean.TRUE;
            } else if ("false".equalsIgnoreCase(value.trim())) {
                toSet = Boolean.FALSE;
            }
            map.put(propertyName, toSet);
        }
    }

    private void handleJournalsLine(String line) {
        if (!line.trim().isEmpty()) {
            this.journals.add(line.trim());
        }
    }

    public Layout getReferenceFormat(String type) {
        Layout l = this.bibLayout.get(type.toLowerCase(Locale.ENGLISH));
        if (l == null) {
            return this.defaultBibLayout;
        }
        return l;
    }

    public String getNumCitationMarker(List<Integer> number, int minGroupingCount, boolean inList) {
        String bracketBefore = this.getStringCitProperty(BRACKET_BEFORE);
        if (inList && this.citProperties.containsKey(BRACKET_BEFORE_IN_LIST)) {
            bracketBefore = this.getStringCitProperty(BRACKET_BEFORE_IN_LIST);
        }
        String bracketAfter = this.getStringCitProperty(BRACKET_AFTER);
        if (inList && this.citProperties.containsKey(BRACKET_AFTER_IN_LIST)) {
            bracketAfter = this.getStringCitProperty(BRACKET_AFTER_IN_LIST);
        }
        ArrayList<Integer> lNum = new ArrayList<Integer>(number);
        Collections.sort(lNum);
        StringBuilder sb = new StringBuilder(bracketBefore);
        int combineFrom = -1;
        int written = 0;
        for (int i = 0; i < lNum.size(); ++i) {
            int i1 = (Integer)lNum.get(i);
            if (combineFrom < 0) {
                if (i < lNum.size() - 1 && (Integer)lNum.get(i + 1) == i1 + 1 && i1 > 0) {
                    combineFrom = i1;
                    continue;
                }
                if (i > 0) {
                    sb.append(this.getStringCitProperty(CITATION_SEPARATOR));
                }
                sb.append((Integer)lNum.get(i) > 0 ? String.valueOf(lNum.get(i)) : UNDEFINED_CITATION_MARKER);
                ++written;
                continue;
            }
            if (i != lNum.size() - 1 && (Integer)lNum.get(i + 1) == i1 + 1) continue;
            if (written > 0) {
                sb.append(this.getStringCitProperty(CITATION_SEPARATOR));
            }
            if (minGroupingCount > 0 && i1 + 1 - combineFrom >= minGroupingCount) {
                sb.append(combineFrom);
                sb.append(this.getStringCitProperty(GROUPED_NUMBERS_SEPARATOR));
                sb.append(i1);
                ++written;
            } else {
                for (int jj = combineFrom; jj <= i1; ++jj) {
                    sb.append(jj);
                    if (jj < i1) {
                        sb.append(this.getStringCitProperty(CITATION_SEPARATOR));
                    }
                    ++written;
                }
            }
            combineFrom = -1;
        }
        sb.append(bracketAfter);
        return sb.toString();
    }

    public String getCitationMarker(List<BibEntry> entries, Map<BibEntry, BibDatabase> database, boolean inParenthesis, String[] uniquefiers, int[] unlimAuthors) {
        int piv = -1;
        String tmpMarker = null;
        if (uniquefiers != null) {
            for (int i = 0; i < uniquefiers.length; ++i) {
                if (uniquefiers[i] == null || uniquefiers[i].isEmpty()) {
                    if (piv > -1 && i > piv + 1) {
                        this.group(entries, uniquefiers, piv, i - 1);
                    }
                    piv = -1;
                    continue;
                }
                BibEntry currentEntry = entries.get(i);
                if (piv == -1) {
                    piv = i;
                    tmpMarker = this.getAuthorYearParenthesisMarker(Collections.singletonList(currentEntry), database, null, unlimAuthors);
                    continue;
                }
                String thisMarker = this.getAuthorYearParenthesisMarker(Collections.singletonList(currentEntry), database, null, unlimAuthors);
                String authorField = this.getStringCitProperty(AUTHOR_FIELD);
                int maxAuthors = this.getIntCitProperty(MAX_AUTHORS);
                String author = this.getCitationMarkerField(currentEntry, database.get(currentEntry), authorField);
                AuthorList al = AuthorList.parse(author);
                int prevALim = unlimAuthors[i - 1];
                if (thisMarker.equals(tmpMarker) && (al.getNumberOfAuthors() <= maxAuthors || unlimAuthors[i] == prevALim)) continue;
                if (piv > -1 && i > piv + 1) {
                    this.group(entries, uniquefiers, piv, i - 1);
                }
                tmpMarker = thisMarker;
                piv = i;
            }
            if (piv >= 0) {
                this.group(entries, uniquefiers, piv, uniquefiers.length - 1);
            }
        }
        if (inParenthesis) {
            return this.getAuthorYearParenthesisMarker(entries, database, uniquefiers, unlimAuthors);
        }
        return this.getAuthorYearInTextMarker(entries, database, uniquefiers, unlimAuthors);
    }

    private void group(List<BibEntry> entries, String[] uniquefiers, int from, int to) {
        String separator = this.getStringCitProperty(UNIQUEFIER_SEPARATOR);
        StringBuilder sb = new StringBuilder(uniquefiers[from]);
        for (int i = from + 1; i <= to; ++i) {
            sb.append(separator);
            sb.append(uniquefiers[i]);
            entries.set(i, null);
        }
        uniquefiers[from] = sb.toString();
    }

    private String getAuthorYearParenthesisMarker(List<BibEntry> entries, Map<BibEntry, BibDatabase> database, String[] uniquifiers, int[] unlimAuthors) {
        String authorField = this.getStringCitProperty(AUTHOR_FIELD);
        int maxA = this.getIntCitProperty(MAX_AUTHORS);
        String yearSep = this.getStringCitProperty(YEAR_SEPARATOR);
        String startBrace = this.getStringCitProperty(BRACKET_BEFORE);
        String endBrace = this.getStringCitProperty(BRACKET_AFTER);
        String citationSeparator = this.getStringCitProperty(CITATION_SEPARATOR);
        String yearField = this.getStringCitProperty(YEAR_FIELD);
        String andString = this.getStringCitProperty(AUTHOR_LAST_SEPARATOR);
        StringBuilder sb = new StringBuilder(startBrace);
        for (int j = 0; j < entries.size(); ++j) {
            BibEntry currentEntry = entries.get(j);
            if (currentEntry == null) continue;
            if (j > 0) {
                sb.append(citationSeparator);
            }
            BibDatabase currentDatabase = database.get(currentEntry);
            int unlimA = unlimAuthors == null ? -1 : unlimAuthors[j];
            int maxAuthors = unlimA > 0 ? unlimA : maxA;
            String author = this.getCitationMarkerField(currentEntry, currentDatabase, authorField);
            String authorString = this.createAuthorList(author, maxAuthors, andString, yearSep);
            sb.append(authorString);
            String year = this.getCitationMarkerField(currentEntry, currentDatabase, yearField);
            if (year != null) {
                sb.append(year);
            }
            if (uniquifiers == null || uniquifiers[j] == null) continue;
            sb.append(uniquifiers[j]);
        }
        sb.append(endBrace);
        return sb.toString();
    }

    private String getAuthorYearInTextMarker(List<BibEntry> entries, Map<BibEntry, BibDatabase> database, String[] uniquefiers, int[] unlimAuthors) {
        String authorField = this.getStringCitProperty(AUTHOR_FIELD);
        int maxA = this.getIntCitProperty(MAX_AUTHORS);
        String yearSep = this.getStringCitProperty(IN_TEXT_YEAR_SEPARATOR);
        String startBrace = this.getStringCitProperty(BRACKET_BEFORE);
        String endBrace = this.getStringCitProperty(BRACKET_AFTER);
        String citationSeparator = this.getStringCitProperty(CITATION_SEPARATOR);
        String yearField = this.getStringCitProperty(YEAR_FIELD);
        String andString = this.getStringCitProperty(AUTHOR_LAST_SEPARATOR_IN_TEXT);
        if (andString == null) {
            andString = this.getStringCitProperty(AUTHOR_LAST_SEPARATOR);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < entries.size(); ++i) {
            int maxAuthors;
            BibEntry currentEntry = entries.get(i);
            if (currentEntry == null) continue;
            BibDatabase currentDatabase = database.get(currentEntry);
            int unlimA = unlimAuthors == null ? -1 : unlimAuthors[i];
            int n = maxAuthors = unlimA > 0 ? unlimA : maxA;
            if (i > 0) {
                sb.append(citationSeparator);
            }
            String author = this.getCitationMarkerField(currentEntry, currentDatabase, authorField);
            String authorString = this.createAuthorList(author, maxAuthors, andString, yearSep);
            sb.append(authorString);
            sb.append(startBrace);
            String year = this.getCitationMarkerField(currentEntry, currentDatabase, yearField);
            if (year != null) {
                sb.append(year);
            }
            if (uniquefiers != null && uniquefiers[i] != null) {
                sb.append(uniquefiers[i]);
            }
            sb.append(endBrace);
        }
        return sb.toString();
    }

    private String getCitationMarkerField(BibEntry entry, BibDatabase database, String field2) {
        String[] fields;
        String authorField = this.getStringCitProperty(AUTHOR_FIELD);
        for (String s2 : fields = field2.split("/")) {
            Optional<String> content = entry.getResolvedFieldOrAlias(s2, database);
            if (!content.isPresent() || content.get().trim().isEmpty()) continue;
            if (field2.equals(authorField) && StringUtil.isInCurlyBrackets(content.get())) {
                return "{" + this.fieldFormatter.format(content.get()) + "}";
            }
            return this.fieldFormatter.format(content.get());
        }
        return "";
    }

    private String getAuthorLastName(AuthorList al, int number) {
        StringBuilder sb = new StringBuilder();
        if (al.getNumberOfAuthors() > number) {
            Author a = al.getAuthor(number);
            a.getVon().filter(von -> !von.isEmpty()).ifPresent(von -> sb.append((String)von).append(' '));
            sb.append(a.getLast().orElse(""));
        }
        return sb.toString();
    }

    public String insertPageInfo(String citation, String pageInfo) {
        String bracketAfter = this.getStringCitProperty(BRACKET_AFTER);
        if (citation.endsWith(bracketAfter)) {
            String first = citation.substring(0, citation.length() - bracketAfter.length());
            return first + this.getStringCitProperty(PAGE_INFO_SEPARATOR) + pageInfo + bracketAfter;
        }
        return citation + this.getStringCitProperty(PAGE_INFO_SEPARATOR) + pageInfo;
    }

    public boolean isNumberEntries() {
        return (Boolean)this.getProperty(IS_NUMBER_ENTRIES);
    }

    public boolean isSortByPosition() {
        return (Boolean)this.getProperty(IS_SORT_BY_POSITION);
    }

    public boolean isItalicCitations() {
        return (Boolean)this.citProperties.get(ITALIC_CITATIONS);
    }

    public boolean isBoldCitations() {
        return (Boolean)this.citProperties.get(BOLD_CITATIONS);
    }

    public boolean isFormatCitations() {
        return (Boolean)this.citProperties.get(FORMAT_CITATIONS);
    }

    public boolean isBibtexKeyCiteMarkers() {
        return (Boolean)this.citProperties.get(BIBTEX_KEY_CITATIONS);
    }

    public boolean getBooleanCitProperty(String key) {
        return (Boolean)this.citProperties.get(key);
    }

    public int getIntCitProperty(String key) {
        return (Integer)this.citProperties.get(key);
    }

    public String getStringCitProperty(String key) {
        return (String)this.citProperties.get(key);
    }

    public String getCitationCharacterFormat() {
        return this.getStringCitProperty(CITATION_CHARACTER_FORMAT);
    }

    public Object getProperty(String propName) {
        return this.properties.get(propName);
    }

    public boolean isFromResource() {
        return this.fromResource;
    }

    public String getLocalCopy() {
        return this.localCopy;
    }

    @Override
    public int compareTo(OOBibStyle other) {
        return this.getName().compareTo(other.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof OOBibStyle) {
            OOBibStyle otherStyle = (OOBibStyle)o;
            return Objects.equals(this.path, otherStyle.path) && Objects.equals(this.name, otherStyle.name) && Objects.equals(this.citProperties, otherStyle.citProperties) && Objects.equals(this.properties, otherStyle.properties);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.path, this.name, this.citProperties, this.properties);
    }

    private String createAuthorList(String author, int maxAuthors, String andString, String yearSep) {
        Objects.requireNonNull(author);
        String etAlString = this.getStringCitProperty(ET_AL_STRING);
        String authorSep = this.getStringCitProperty(AUTHOR_SEPARATOR);
        String oxfordComma = this.getStringCitProperty(OXFORD_COMMA);
        StringBuilder sb = new StringBuilder();
        AuthorList al = AuthorList.parse(author);
        if (!al.isEmpty()) {
            sb.append(this.getAuthorLastName(al, 0));
        }
        if (al.getNumberOfAuthors() > 1 && (al.getNumberOfAuthors() <= maxAuthors || maxAuthors < 0)) {
            for (int j = 1; j < al.getNumberOfAuthors() - 1; ++j) {
                sb.append(authorSep);
                sb.append(this.getAuthorLastName(al, j));
            }
            if (al.getNumberOfAuthors() > 2) {
                sb.append(oxfordComma);
            }
            sb.append(andString);
            sb.append(this.getAuthorLastName(al, al.getNumberOfAuthors() - 1));
        } else if (al.getNumberOfAuthors() > maxAuthors) {
            sb.append(etAlString);
        }
        sb.append(yearSep);
        return sb.toString();
    }

    static enum BibStyleMode {
        NONE,
        LAYOUT,
        PROPERTIES,
        CITATION,
        NAME,
        JOURNALS;

    }
}

