/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jabref.logic.integrity.IntegrityCheck;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BiblatexEntryTypes;
import org.jabref.model.entry.BibtexEntryTypes;
import org.jabref.model.entry.InternalBibtexFields;

public class NoBibtexFieldChecker
implements IntegrityCheck.Checker {
    private List<String> getAllBiblatexOnlyFields() {
        Set allBibtexFields = BibtexEntryTypes.ALL.stream().flatMap(type -> type.getAllFields().stream()).collect(Collectors.toSet());
        return BiblatexEntryTypes.ALL.stream().flatMap(type -> type.getAllFields().stream()).filter(fieldName -> !allBibtexFields.contains(fieldName)).filter(fieldName -> !InternalBibtexFields.DEFAULT_GENERAL_FIELDS.contains(fieldName)).filter(fieldName -> !fieldName.equals("abstract")).filter(fieldName -> !fieldName.equals("review")).sorted().collect(Collectors.toList());
    }

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        List<String> allBiblatexOnlyFields = this.getAllBiblatexOnlyFields();
        return entry.getFieldNames().stream().filter(name -> allBiblatexOnlyFields.contains(name)).map(name -> new IntegrityMessage(Localization.lang("biblatex field only", new String[0]), entry, (String)name)).collect(Collectors.toList());
    }
}

