/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.util;

import java.util.Optional;
import org.jabref.model.entry.BibEntry;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OAI2Handler
extends DefaultHandler {
    private final BibEntry entry;
    private StringBuilder authors;
    private String keyname;
    private String forenames;
    private StringBuilder characters;

    public OAI2Handler(BibEntry be) {
        this.entry = be;
    }

    @Override
    public void startDocument() throws SAXException {
        this.authors = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        this.characters = new StringBuilder();
    }

    @Override
    public void endElement(String uri, String localName, String qualifiedName) throws SAXException {
        String content = this.characters.toString();
        if ("error".equals(qualifiedName)) {
            throw new RuntimeException(content);
        }
        if ("id".equals(qualifiedName)) {
            this.entry.setField("eprint", content);
        } else if ("keyname".equals(qualifiedName)) {
            this.keyname = content;
        } else if ("forenames".equals(qualifiedName)) {
            this.forenames = content;
        } else if ("journal-ref".equals(qualifiedName)) {
            String journal = content.replaceFirst("[0-9].*", "");
            this.entry.setField("journal", journal);
            String volume = content.replaceFirst(journal, "");
            volume = volume.replaceFirst(" .*", "");
            this.entry.setField("volume", volume);
            String year = content.replaceFirst(".*?\\(", "");
            year = year.replaceFirst("\\).*", "");
            this.entry.setField("year", year);
            String pages = content.replaceFirst(journal, "");
            pages = pages.replaceFirst(volume, "");
            pages = pages.replaceFirst("\\(" + year + "\\)", "");
            pages = pages.replace(" ", "");
            this.entry.setField("pages", pages);
        } else if ("datestamp".equals(qualifiedName)) {
            Optional<String> year = this.entry.getField("year");
            if (!year.isPresent() || year.get().isEmpty()) {
                this.entry.setField("year", content.replaceFirst("-.*", ""));
            }
        } else if ("title".equals(qualifiedName)) {
            this.entry.setField("title", content);
        } else if ("abstract".equals(qualifiedName)) {
            this.entry.setField("abstract", content);
        } else if ("comments".equals(qualifiedName)) {
            this.entry.setField("comment", content);
        } else if ("report-no".equals(qualifiedName)) {
            this.entry.setField("reportno", content);
        } else if ("doi".equals(qualifiedName)) {
            this.entry.setField("doi", content);
        } else if ("author".equals(qualifiedName)) {
            String author = this.forenames + " " + this.keyname;
            if (this.authors.length() > 0) {
                this.authors.append(" and ");
            }
            this.authors.append(author);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.entry.setField("author", this.authors.toString());
    }

    public static String correctLineBreaks(String s2) {
        String result = s2.replaceAll("\\n(?!\\s*\\n)", " ");
        result = result.replaceAll("\\s*\\n\\s*", "\n");
        return result.replaceAll(" {2,}", " ").replaceAll("(^\\s*|\\s+$)", "");
    }
}

