/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jabref.logic.cleanup.Cleanups;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.util.GroupsParser;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.metadata.ContentSelectors;
import org.jabref.model.metadata.MetaData;
import org.jabref.model.metadata.SaveOrderConfig;
import org.jabref.model.strings.StringUtil;
import org.jabref.model.util.FileUpdateMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaDataParser.class);
    private static FileUpdateMonitor fileMonitor;

    public MetaDataParser(FileUpdateMonitor fileMonitor) {
        MetaDataParser.fileMonitor = fileMonitor;
    }

    public MetaData parse(Map<String, String> data, Character keywordSeparator) throws ParseException {
        return this.parse(new MetaData(), data, keywordSeparator);
    }

    public MetaData parse(MetaData metaData, Map<String, String> data, Character keywordSeparator) throws ParseException {
        List<String> defaultCiteKeyPattern = new ArrayList<String>();
        HashMap<String, List<String>> nonDefaultCiteKeyPatterns = new HashMap<String, List<String>>();
        block19: for (Map.Entry<String, String> entry : data.entrySet()) {
            List<String> value = MetaDataParser.getAsList(entry.getValue());
            if (entry.getKey().startsWith("keypattern_")) {
                String entryType = entry.getKey().substring("keypattern_".length());
                nonDefaultCiteKeyPatterns.put(entryType, Collections.singletonList(MetaDataParser.getSingleItem(value)));
                continue;
            }
            if (entry.getKey().startsWith("fileDirectory-")) {
                String user = entry.getKey().substring("fileDirectory".length() + 1);
                metaData.setUserFileDirectory(user, MetaDataParser.getSingleItem(value));
                continue;
            }
            if (entry.getKey().startsWith("selector_")) {
                metaData.addContentSelector(ContentSelectors.parse(entry.getKey().substring("selector_".length()), StringUtil.unquote(entry.getValue(), '\\')));
                continue;
            }
            switch (entry.getKey()) {
                case "grouping": 
                case "groupstree": {
                    metaData.setGroups(GroupsParser.importGroups(value, keywordSeparator, fileMonitor));
                    continue block19;
                }
                case "saveActions": {
                    metaData.setSaveActions(Cleanups.parse(value));
                    continue block19;
                }
                case "databaseType": {
                    metaData.setMode(BibDatabaseMode.parse(MetaDataParser.getSingleItem(value)));
                    continue block19;
                }
                case "keypatterndefault": {
                    defaultCiteKeyPattern = Collections.singletonList(MetaDataParser.getSingleItem(value));
                    continue block19;
                }
                case "protectedFlag": {
                    if (Boolean.parseBoolean(MetaDataParser.getSingleItem(value))) {
                        metaData.markAsProtected();
                        continue block19;
                    }
                    metaData.markAsNotProtected();
                    continue block19;
                }
                case "fileDirectory": {
                    metaData.setDefaultFileDirectory(MetaDataParser.getSingleItem(value));
                    continue block19;
                }
                case "saveOrderConfig": {
                    metaData.setSaveOrderConfig(SaveOrderConfig.parse(value));
                    continue block19;
                }
            }
            metaData.putUnkownMetaDataItem(entry.getKey(), value);
        }
        if (!defaultCiteKeyPattern.isEmpty() || !nonDefaultCiteKeyPatterns.isEmpty()) {
            metaData.setCiteKeyPattern(defaultCiteKeyPattern, nonDefaultCiteKeyPatterns);
        }
        return metaData;
    }

    private static String getSingleItem(List<String> value) throws ParseException {
        if (value.size() == 1) {
            return value.get(0);
        }
        throw new ParseException("Expected a single item but received " + value.toString());
    }

    private static List<String> getAsList(String value) throws ParseException {
        StringReader valueReader = new StringReader(value);
        ArrayList<String> orderedValue = new ArrayList<String>();
        try {
            Optional<String> unit;
            while ((unit = MetaDataParser.getNextUnit(valueReader)).isPresent()) {
                orderedValue.add(unit.get());
            }
        }
        catch (IOException ex) {
            LOGGER.error("Weird error while parsing meta data.", ex);
            throw new ParseException("Weird error while parsing meta data.", ex);
        }
        return orderedValue;
    }

    private static Optional<String> getNextUnit(Reader reader) throws IOException {
        int c;
        boolean escape = false;
        StringBuilder res = new StringBuilder();
        while ((c = reader.read()) != -1) {
            if (escape) {
                res.append((char)c);
                escape = false;
                continue;
            }
            if (c == 92) {
                escape = true;
                continue;
            }
            if (c == 59) break;
            res.append((char)c);
        }
        if (res.length() > 0) {
            return Optional.of(res.toString());
        }
        return Optional.empty();
    }
}

